/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp.util;

import java.io.IOException;
import javax.media.rtp.OutputDataStream;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.RTPPushDataSource;
import net.sf.fmj.media.rtp.util.Packet;
import net.sf.fmj.media.rtp.util.PacketConsumer;

public class RTPPacketSender
implements PacketConsumer {
    RTPPushDataSource dest = null;
    RTPConnector connector = null;
    OutputDataStream outstream = null;

    public RTPPacketSender(OutputDataStream outputDataStream) {
        this.outstream = outputDataStream;
    }

    public RTPPacketSender(RTPConnector rTPConnector) throws IOException {
        this.connector = rTPConnector;
        this.outstream = rTPConnector.getDataOutputStream();
    }

    public RTPPacketSender(RTPPushDataSource rTPPushDataSource) {
        this.dest = rTPPushDataSource;
        this.outstream = rTPPushDataSource.getInputStream();
    }

    public void closeConsumer() {
    }

    public String consumerString() {
        String string = "RTPPacketSender for " + this.dest;
        return string;
    }

    public RTPConnector getConnector() {
        return this.connector;
    }

    public void sendTo(Packet packet) throws IOException {
        if (this.outstream == null) {
            throw new IOException();
        }
        this.outstream.write(packet.data, 0, packet.length);
    }
}

