/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import javax.media.rtp.Participant;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.event.ByeEvent;
import javax.media.rtp.event.InactiveReceiveStreamEvent;
import javax.media.rtp.event.RTPEvent;
import javax.media.rtp.event.TimeoutEvent;
import net.sf.fmj.media.rtp.PassiveSSRCInfo;
import net.sf.fmj.media.rtp.RTPSourceInfo;
import net.sf.fmj.media.rtp.RecvSSRCInfo;
import net.sf.fmj.media.rtp.SSRCCache;
import net.sf.fmj.media.rtp.SSRCInfo;
import net.sf.fmj.media.rtp.StreamSynch;
import net.sf.fmj.media.rtp.util.RTPMediaThread;
import net.sf.fmj.media.rtp.util.SSRCTable;

public class SSRCCacheCleaner
implements Runnable {
    private static final long RUN_INTERVAL = 5000L;
    private static final int TIMEOUT_MULTIPLIER = 5;
    private final SSRCCache cache;
    private boolean killed;
    private long lastCleaned;
    private int[] ssrcs;
    private final StreamSynch streamSynch;
    private final RTPMediaThread thread;

    public SSRCCacheCleaner(SSRCCache sSRCCache, StreamSynch streamSynch) {
        this.cache = sSRCCache;
        this.streamSynch = streamSynch;
        this.killed = false;
        this.lastCleaned = -1L;
        this.thread = new RTPMediaThread(this, "SSRC Cache Cleaner");
        this.thread.useControlPriority();
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private long cleannow(long l) {
        SSRCInfo sSRCInfo = this.cache.ourssrc;
        long l2 = Long.MAX_VALUE;
        if (sSRCInfo == null) {
            return l2;
        }
        double d = this.cache.calcReportInterval(sSRCInfo.sender, true);
        SSRCTable<SSRCInfo> sSRCTable = this.cache.cache;
        this.ssrcs = sSRCTable.keysToArray(this.ssrcs);
        for (int n : this.ssrcs) {
            Object object;
            Object object2;
            SSRCInfo sSRCInfo2;
            if (n == 0 || (sSRCInfo2 = sSRCTable.get(n)) == null || sSRCInfo2.ours) continue;
            if (sSRCInfo2.byeReceived) {
                ReceiveStream receiveStream;
                long l3 = 1000L - l + sSRCInfo2.byeTime;
                if (l3 > 0L) {
                    if (l3 >= l2) continue;
                    l2 = l3;
                    continue;
                }
                sSRCInfo2.byeTime = 0L;
                sSRCInfo2.byeReceived = false;
                this.cache.remove(sSRCInfo2.ssrc);
                this.streamSynch.remove(sSRCInfo2.ssrc);
                object2 = sSRCInfo2.sourceInfo;
                if (sSRCInfo2 instanceof RecvSSRCInfo) {
                    receiveStream = (ReceiveStream)((Object)sSRCInfo2);
                } else {
                    if (!(sSRCInfo2 instanceof PassiveSSRCInfo)) continue;
                    receiveStream = null;
                }
                ByeEvent byeEvent = new ByeEvent(this.cache.sm, (Participant)object2, receiveStream, sSRCInfo2.byereason, object2 != null && ((RTPSourceInfo)object2).getStreamCount() == 0);
                this.cache.eventhandler.postEvent(byeEvent);
                continue;
            }
            if (!((double)sSRCInfo2.lastHeardFrom + d <= (double)l)) continue;
            if (!sSRCInfo2.inactivesent) {
                RTPSourceInfo rTPSourceInfo = sSRCInfo2.sourceInfo;
                if (sSRCInfo2 instanceof ReceiveStream) {
                    object = (ReceiveStream)((Object)sSRCInfo2);
                } else {
                    if (!((double)sSRCInfo2.lastHeardFrom + d * 5.0 <= (double)l)) continue;
                    object = null;
                }
                object2 = new InactiveReceiveStreamEvent(this.cache.sm, rTPSourceInfo, (ReceiveStream)object, rTPSourceInfo != null && rTPSourceInfo.getStreamCount() == 1);
                this.cache.eventhandler.postEvent((RTPEvent)object2);
                sSRCInfo2.quiet = true;
                sSRCInfo2.inactivesent = true;
                sSRCInfo2.setAlive(false);
                continue;
            }
            if (sSRCInfo2.lastHeardFrom + 5000L > l) continue;
            this.cache.remove(sSRCInfo2.ssrc);
            RTPSourceInfo rTPSourceInfo = sSRCInfo2.sourceInfo;
            object = new TimeoutEvent(this.cache.sm, rTPSourceInfo, sSRCInfo2 instanceof ReceiveStream ? (ReceiveStream)((Object)sSRCInfo2) : null, rTPSourceInfo != null && rTPSourceInfo.getStreamCount() == 0);
            this.cache.eventhandler.postEvent((RTPEvent)object);
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long l = Long.MAX_VALUE;
        while (true) {
            long l2;
            SSRCCacheCleaner sSRCCacheCleaner = this;
            synchronized (sSRCCacheCleaner) {
                if (this.killed) {
                    break;
                }
                l2 = System.currentTimeMillis();
                long l3 = l = this.lastCleaned == -1L ? 0L : Math.min(this.lastCleaned + 5000L - l2, l);
                if (l > 0L) {
                    try {
                        this.wait(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    l = Long.MAX_VALUE;
                    continue;
                }
                this.lastCleaned = l2;
            }
            try {
                l = this.cleannow(l2);
                if (l > 0L) continue;
                l = Long.MAX_VALUE;
            }
            catch (Exception exception) {
                l = Long.MAX_VALUE;
                exception.printStackTrace();
            }
        }
    }

    public synchronized void setClean() {
        this.lastCleaned = -1L;
        this.notifyAll();
    }

    public synchronized void stop() {
        this.killed = true;
        this.notifyAll();
    }
}

