/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.DataOutputStream;
import java.io.IOException;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.RTCPReportBlock;

public class RTCPSRPacket
extends RTCPPacket {
    public int ssrc;
    public long ntptimestampmsw;
    public long ntptimestamplsw;
    public long rtptimestamp;
    public long packetcount;
    public long octetcount;
    public RTCPReportBlock[] reports;

    public RTCPSRPacket(int n, RTCPReportBlock[] rTCPReportBlockArray) {
        if (rTCPReportBlockArray.length > 31) {
            throw new IllegalArgumentException("Too many reports");
        }
        this.ssrc = n;
        this.reports = rTCPReportBlockArray;
    }

    RTCPSRPacket(RTCPPacket rTCPPacket) {
        super(rTCPPacket);
        this.type = 200;
    }

    public void assemble(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(128 + this.reports.length);
        dataOutputStream.writeByte(200);
        dataOutputStream.writeShort(6 + this.reports.length * 6);
        dataOutputStream.writeInt(this.ssrc);
        dataOutputStream.writeInt((int)this.ntptimestampmsw);
        dataOutputStream.writeInt((int)this.ntptimestamplsw);
        dataOutputStream.writeInt((int)this.rtptimestamp);
        dataOutputStream.writeInt((int)this.packetcount);
        dataOutputStream.writeInt((int)this.octetcount);
        for (int i = 0; i < this.reports.length; ++i) {
            dataOutputStream.writeInt(this.reports[i].ssrc);
            dataOutputStream.writeInt((this.reports[i].packetslost & 0xFFFFFF) + (this.reports[i].fractionlost << 24));
            dataOutputStream.writeInt((int)this.reports[i].lastseq);
            dataOutputStream.writeInt(this.reports[i].jitter);
            dataOutputStream.writeInt((int)this.reports[i].lsr);
            dataOutputStream.writeInt((int)this.reports[i].dlsr);
        }
    }

    public int calcLength() {
        return 28 + this.reports.length * 24;
    }

    public String toString() {
        return "\tRTCP SR (sender report) packet for sync source " + this.ssrc + "\n\t\tNTP timestampMSW: " + this.ntptimestampmsw + "\n\t\tNTP timestampLSW: " + this.ntptimestamplsw + "\n\t\tRTP timestamp: " + this.rtptimestamp + "\n\t\tnumber of packets sent: " + this.packetcount + "\n\t\tnumber of octets (bytes) sent: " + this.octetcount + "\n" + RTCPReportBlock.toString(this.reports);
    }
}

