/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.media.rtp.rtcp.Feedback;

public class RTCPFeedback
implements Feedback {
    public static final int SIZE = 24;
    private long ssrc = 0L;
    private int fractionLost = 0;
    private long numLost = 0L;
    private long xtndSeqNum = 0L;
    private long jitter = 0L;
    private long lsr = 0L;
    private long dlsr = 0L;

    public RTCPFeedback(byte[] byArray, int n, int n2) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray, n, n2));
        this.ssrc = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
        this.fractionLost = dataInputStream.readUnsignedByte();
        this.numLost = dataInputStream.readUnsignedShort() << 8 | dataInputStream.readUnsignedByte();
        this.xtndSeqNum = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
        this.jitter = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
        this.lsr = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
        this.dlsr = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
    }

    public long getDLSR() {
        return this.dlsr;
    }

    public int getFractionLost() {
        return this.fractionLost;
    }

    public long getJitter() {
        return this.jitter;
    }

    public long getLSR() {
        return this.lsr;
    }

    public long getNumLost() {
        return this.numLost;
    }

    public long getSSRC() {
        return this.ssrc;
    }

    public long getXtndSeqNum() {
        return this.xtndSeqNum;
    }
}

