/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.Buffer;

class JitterBuffer {
    private int capacity;
    final Condition condition;
    private Buffer[] elements;
    private int length;
    final Lock lock;
    private int locked;
    private int offset;

    public JitterBuffer(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("capacity");
        }
        this.elements = new Buffer[n];
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = new Buffer();
        }
        this.capacity = n;
        this.length = 0;
        this.locked = -1;
        this.offset = 0;
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
    }

    public void addPkt(Buffer buffer) {
        this.assertLocked(buffer);
        if (this.noMoreFree()) {
            throw new IllegalStateException("noMoreFree");
        }
        long l = this.getFirstSeq();
        long l2 = this.getLastSeq();
        long l3 = buffer.getSequenceNumber();
        if (l == 0x7FFFFFFFFFFFFFFEL && l2 == 0x7FFFFFFFFFFFFFFEL) {
            this.append(buffer);
        } else if (l3 < l) {
            this.prepend(buffer);
        } else if (l < l3 && l3 < l2) {
            this.insert(buffer);
        } else if (l3 > l2) {
            this.append(buffer);
        } else {
            this.returnFree(buffer);
        }
        this.locked = -1;
    }

    private void append(Buffer buffer) {
        int n = (this.offset + this.length) % this.capacity;
        if (n != this.locked) {
            this.elements[this.locked] = this.elements[n];
            this.elements[n] = buffer;
        }
        ++this.length;
    }

    private void assertLocked(Buffer buffer) throws IllegalStateException {
        if (this.locked == -1) {
            throw new IllegalStateException("No Buffer has been retrieved from this JitterBuffer and has not been returned yet.");
        }
        if (buffer != this.elements[this.locked]) {
            throw new IllegalArgumentException("buffer");
        }
    }

    private void assertNotLocked() throws IllegalStateException {
        if (this.locked != -1) {
            throw new IllegalStateException("A Buffer has been retrieved from this JitterBuffer and has not been returned yet.");
        }
    }

    void dropFill(int n) {
        this.assertNotLocked();
        if (n < 0 || n >= this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        n = (this.offset + n) % this.capacity;
        Buffer buffer = this.elements[n];
        if (n == this.offset) {
            this.offset = (this.offset + 1) % this.capacity;
        } else {
            int n2 = (this.offset + this.length - 1) % this.capacity;
            if (n != n2) {
                while (n != this.offset) {
                    int n3 = n - 1;
                    if (n3 < 0) {
                        n3 = this.capacity - 1;
                    }
                    this.elements[n] = this.elements[n3];
                    n = n3;
                }
                this.elements[n] = buffer;
                this.offset = (this.offset + 1) % this.capacity;
            }
        }
        --this.length;
        this.locked = n;
        this.returnFree(buffer);
    }

    public void dropFirstFill() {
        this.returnFree(this.getFill());
    }

    boolean fillNotEmpty() {
        return this.getFillCount() != 0;
    }

    boolean freeNotEmpty() {
        return this.getFreeCount() != 0;
    }

    public int getCapacity() {
        int n;
        this.lock.lock();
        try {
            n = this.capacity;
        }
        finally {
            this.lock.unlock();
        }
        return n;
    }

    public Buffer getFill() {
        this.assertNotLocked();
        if (this.noMoreFill()) {
            throw new IllegalStateException("noMoreFill");
        }
        int n = this.offset;
        Buffer buffer = this.elements[n];
        this.offset = (this.offset + 1) % this.capacity;
        --this.length;
        this.locked = n;
        return buffer;
    }

    public Buffer getFill(int n) {
        if (n < 0 || n >= this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        return this.elements[(this.offset + n) % this.capacity];
    }

    public int getFillCount() {
        int n;
        this.lock.lock();
        try {
            n = this.length;
        }
        finally {
            this.lock.unlock();
        }
        return n;
    }

    public long getFirstSeq() {
        return this.length == 0 ? 0x7FFFFFFFFFFFFFFEL : this.elements[this.offset].getSequenceNumber();
    }

    public Buffer getFree() {
        this.assertNotLocked();
        if (this.noMoreFree()) {
            throw new IllegalStateException("noMoreFree");
        }
        int n = (this.offset + this.length) % this.capacity;
        Buffer buffer = this.elements[n];
        this.locked = n;
        return buffer;
    }

    public int getFreeCount() {
        return this.capacity - this.length;
    }

    public long getLastSeq() {
        return this.length == 0 ? 0x7FFFFFFFFFFFFFFEL : this.elements[(this.offset + this.length - 1) % this.capacity].getSequenceNumber();
    }

    private void insert(Buffer buffer) {
        int n = this.offset;
        int n2 = (this.offset + this.length) % this.capacity;
        long l = buffer.getSequenceNumber();
        while (n != n2 && this.elements[n].getSequenceNumber() <= l) {
            if (++n < this.capacity) continue;
            n = 0;
        }
        if (n == this.offset) {
            this.prepend(buffer);
        } else if (n == n2) {
            this.append(buffer);
        } else {
            this.elements[this.locked] = this.elements[n2];
            int n3 = n2;
            while (n3 != n) {
                int n4 = n3 - 1;
                if (n4 < 0) {
                    n4 = this.capacity - 1;
                }
                this.elements[n3] = this.elements[n4];
                n3 = n4;
            }
            this.elements[n] = buffer;
            ++this.length;
        }
    }

    boolean noMoreFill() {
        return this.getFillCount() == 0;
    }

    boolean noMoreFree() {
        return this.getFreeCount() == 0;
    }

    private void prepend(Buffer buffer) {
        int n = this.offset - 1;
        if (n < 0) {
            n = this.capacity - 1;
        }
        if (n != this.locked) {
            this.elements[this.locked] = this.elements[n];
            this.elements[n] = buffer;
        }
        this.offset = n;
        ++this.length;
    }

    public void returnFree(Buffer buffer) {
        this.assertLocked(buffer);
        this.locked = -1;
    }

    public void setCapacity(int n) {
        int n2;
        this.assertNotLocked();
        if (n < 1) {
            throw new IllegalArgumentException("capacity");
        }
        if (this.capacity == n) {
            return;
        }
        Buffer[] bufferArray = new Buffer[n];
        while (this.getFillCount() > n) {
            this.dropFirstFill();
        }
        int n3 = Math.min(this.getFillCount(), n);
        for (n2 = 0; n2 < n3; ++n2) {
            bufferArray[n2] = this.getFill(n2);
        }
        for (n2 = n3; n2 < n; ++n2) {
            bufferArray[n2] = new Buffer();
        }
        this.capacity = n;
        this.elements = bufferArray;
        this.length = n3;
        this.offset = 0;
    }
}

