/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.protocol.httpauth;

import com.lti.utils.StringUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.MediaLocator;
import javax.media.Time;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.SourceCloneable;
import net.sf.fmj.utility.LoggerSingleton;

public class DataSource
extends PullDataSource
implements SourceCloneable {
    private static final Logger logger = LoggerSingleton.logger;
    private URLConnection conn;
    private boolean connected = false;
    private String contentTypeStr;
    private ContentDescriptor contentType;
    protected URLSourceStream[] sources;

    public DataSource() {
    }

    public DataSource(URL uRL) {
        this.setLocator(new MediaLocator(uRL));
    }

    public void connect() throws IOException {
        String string = this.getLocator().getRemainder();
        int n = string.indexOf(64);
        if (n < 0) {
            throw new IOException("Invalid httpauth url: expected: @");
        }
        int n2 = string.indexOf(58);
        if (n2 < 0 || n2 > n) {
            throw new IOException("Invalid httpaut url: expected: :");
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1, n);
        String string4 = "http:" + this.getLocator().getRemainder().substring(n + 1);
        this.conn = new URL(string4).openConnection();
        if (this.conn instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)this.conn;
            if (string2 != null && !string2.equals("")) {
                httpURLConnection.setRequestProperty("Authorization", "Basic " + StringUtils.byteArrayToBase64String((string2 + ":" + string3).getBytes()));
            }
            httpURLConnection.connect();
            int n3 = httpURLConnection.getResponseCode();
            if (n3 < 200 || n3 >= 300) {
                httpURLConnection.disconnect();
                throw new IOException("HTTP response code: " + n3);
            }
            this.contentTypeStr = ContentDescriptor.mimeTypeToPackageName(this.stripTrailer(this.conn.getContentType()));
        } else {
            this.conn.connect();
            this.contentTypeStr = ContentDescriptor.mimeTypeToPackageName(this.conn.getContentType());
        }
        this.contentType = new ContentDescriptor(this.contentTypeStr);
        this.sources = new URLSourceStream[1];
        this.sources[0] = new URLSourceStream();
        this.connected = true;
    }

    public javax.media.protocol.DataSource createClone() {
        DataSource dataSource;
        try {
            dataSource = new DataSource(this.getLocator().getURL());
        }
        catch (MalformedURLException malformedURLException) {
            logger.log(Level.WARNING, "" + malformedURLException, malformedURLException);
            return null;
        }
        if (this.connected) {
            try {
                dataSource.connect();
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "" + iOException, iOException);
                return null;
            }
        }
        return dataSource;
    }

    public void disconnect() {
        if (!this.connected) {
            return;
        }
        if (this.conn != null && this.conn instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)this.conn;
            httpURLConnection.disconnect();
        }
        this.connected = false;
    }

    public String getContentType() {
        return this.contentTypeStr;
    }

    public Object getControl(String string) {
        return null;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Time getDuration() {
        return Time.TIME_UNKNOWN;
    }

    public PullSourceStream[] getStreams() {
        if (!this.connected) {
            throw new Error("Unconnected source.");
        }
        return this.sources;
    }

    public void start() throws IOException {
    }

    public void stop() throws IOException {
    }

    private String stripTrailer(String string) {
        int n = string.indexOf(";");
        if (n < 0) {
            return string;
        }
        String string2 = string.substring(0, n);
        return string2;
    }

    class URLSourceStream
    implements PullSourceStream {
        private boolean endOfStream = false;

        URLSourceStream() {
        }

        public boolean endOfStream() {
            return this.endOfStream;
        }

        public ContentDescriptor getContentDescriptor() {
            return DataSource.this.contentType;
        }

        public long getContentLength() {
            return DataSource.this.conn.getContentLength();
        }

        public Object getControl(String string) {
            return null;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = DataSource.this.conn.getInputStream().read(byArray, n, n2);
            if (n3 == -1) {
                this.endOfStream = true;
            }
            return n3;
        }

        public boolean willReadBlock() {
            try {
                return DataSource.this.conn.getInputStream().available() <= 0;
            }
            catch (IOException iOException) {
                return true;
            }
        }
    }
}

