/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.protocol.file;

import com.lti.utils.PathUtils;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Time;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;
import javax.media.protocol.SourceCloneable;
import net.sf.fmj.media.MimeManager;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.URLUtils;

public class DataSource
extends PullDataSource
implements SourceCloneable {
    private static final Logger logger = LoggerSingleton.logger;
    protected RandomAccessFile raf;
    protected boolean connected = false;
    protected ContentDescriptor contentType;
    protected RAFPullSourceStream[] sources;
    private long contentLength = -1L;

    private static String getContentTypeFor(String string) {
        String string2 = PathUtils.extractExtension(string);
        String string3 = MimeManager.getMimeType(string2);
        if (string3 != null) {
            return string3;
        }
        string3 = URLConnection.getFileNameMap().getContentTypeFor(string);
        return string3;
    }

    public void connect() throws IOException {
        try {
            String string = URLUtils.extractValidPathFromFileUrl(this.getLocator().toExternalForm());
            if (string == null) {
                throw new IOException("Cannot determine valid file path from URL: " + this.getLocator().toExternalForm());
            }
            this.raf = new RandomAccessFile(string, "r");
            this.contentLength = this.raf.length();
            String string2 = DataSource.getContentTypeFor(string);
            if (string2 == null) {
                throw new IOException("Unknown content type for path: " + string);
            }
            this.contentType = new ContentDescriptor(ContentDescriptor.mimeTypeToPackageName(string2));
            this.sources = new RAFPullSourceStream[1];
            this.sources[0] = new RAFPullSourceStream();
            this.connected = true;
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "" + iOException, iOException);
            throw iOException;
        }
    }

    public javax.media.protocol.DataSource createClone() {
        DataSource dataSource = new DataSource();
        dataSource.setLocator(this.getLocator());
        if (this.connected) {
            try {
                dataSource.connect();
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "" + iOException, iOException);
                return null;
            }
        }
        return dataSource;
    }

    public void disconnect() {
        if (!this.connected) {
            return;
        }
        this.connected = false;
    }

    public String getContentType() {
        if (!this.connected) {
            throw new Error("Source is unconnected.");
        }
        String string = this.getLocator().getRemainder();
        String string2 = DataSource.getContentTypeFor(string);
        return ContentDescriptor.mimeTypeToPackageName(string2);
    }

    public Object getControl(String string) {
        return null;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Time getDuration() {
        return Time.TIME_UNKNOWN;
    }

    public PullSourceStream[] getStreams() {
        if (!this.connected) {
            throw new Error("Unconnected source.");
        }
        return this.sources;
    }

    public void start() throws IOException {
    }

    public void stop() throws IOException {
    }

    class RAFPullSourceStream
    implements PullSourceStream,
    Seekable {
        private boolean endOfStream = false;

        RAFPullSourceStream() {
        }

        public boolean endOfStream() {
            return this.endOfStream;
        }

        public ContentDescriptor getContentDescriptor() {
            return DataSource.this.contentType;
        }

        public long getContentLength() {
            return DataSource.this.contentLength;
        }

        public Object getControl(String string) {
            return null;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public boolean isRandomAccess() {
            return true;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = DataSource.this.raf.read(byArray, n, n2);
            if (n3 == -1) {
                this.endOfStream = true;
            }
            return n3;
        }

        public long seek(long l) {
            try {
                DataSource.this.raf.seek(l);
                return DataSource.this.raf.getFilePointer();
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "" + iOException, iOException);
                throw new RuntimeException(iOException);
            }
        }

        public long tell() {
            try {
                return DataSource.this.raf.getFilePointer();
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "" + iOException, iOException);
                throw new RuntimeException(iOException);
            }
        }

        public boolean willReadBlock() {
            return false;
        }
    }
}

