/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import com.lti.utils.synchronization.ProducerConsumerQueue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Buffer;
import net.sf.fmj.utility.LoggerSingleton;

public class BufferQueueInputStream
extends InputStream {
    private static final Logger logger = LoggerSingleton.logger;
    private final ProducerConsumerQueue q;
    private static final int DEFAULT_QUEUE_SIZE = 20;
    private boolean trace = false;
    private Buffer buffer;
    private int available = 0;

    public BufferQueueInputStream() {
        this(20);
    }

    public BufferQueueInputStream(int n) {
        this.q = new ProducerConsumerQueue(n);
    }

    public BufferQueueInputStream(ProducerConsumerQueue producerConsumerQueue) {
        this.q = producerConsumerQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() {
        ProducerConsumerQueue producerConsumerQueue = this.q;
        synchronized (producerConsumerQueue) {
            if (this.trace) {
                logger.fine(this + " available: available=" + this.available);
            }
            return this.available;
        }
    }

    public void blockingPut(Buffer buffer) {
        this.blockingPut(buffer, true);
    }

    public void blockingPut(Buffer buffer, boolean bl) {
        this.put(buffer, true, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillBuffer() throws IOException {
        try {
            ProducerConsumerQueue producerConsumerQueue = this.q;
            synchronized (producerConsumerQueue) {
                do {
                    if (this.buffer != null) {
                        if (this.buffer.isEOM()) {
                            return;
                        }
                        if (this.buffer.getLength() > 0) {
                            return;
                        }
                    }
                    this.buffer = (Buffer)this.q.get();
                    if (this.trace) {
                        logger.fine(this + " Getting buffer: " + this.buffer.getLength());
                    }
                    if (this.buffer.getLength() != 0 || this.buffer.isDiscard() || !this.trace) continue;
                    logger.fine("Skipping zero-length buffer in queue");
                } while (this.buffer.isDiscard() || this.buffer.getLength() == 0);
            }
        }
        catch (InterruptedException interruptedException) {
            logger.log(Level.WARNING, "" + interruptedException, interruptedException);
            throw new InterruptedIOException();
        }
    }

    public boolean put(Buffer buffer) {
        return this.put(buffer, true);
    }

    public boolean put(Buffer buffer, boolean bl) {
        return this.put(buffer, false, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean put(Buffer buffer, boolean bl, boolean bl2) {
        if (buffer.getLength() == -1) {
            throw new IllegalArgumentException();
        }
        if (!(buffer.getData() instanceof byte[])) {
            throw new IllegalArgumentException("Expected byte array: " + buffer.getData());
        }
        if (buffer.isEOM()) {
            logger.fine("putting EOM buffer");
        } else {
            if (buffer.getLength() == 0) {
                if (this.trace) {
                    logger.fine("Skipping zero length buffer, not adding to queue");
                }
                return true;
            }
            if (buffer.isDiscard()) {
                if (this.trace) {
                    logger.fine("Skipping discard buffer, not adding to queue");
                }
                return true;
            }
        }
        if (this.trace) {
            logger.fine(this + " BufferQueueInputStream.put: Putting buffer, length=" + buffer.getLength() + " eom=" + buffer.isEOM());
        }
        try {
            ProducerConsumerQueue producerConsumerQueue = this.q;
            synchronized (producerConsumerQueue) {
                if (!bl && this.q.isFull()) {
                    return false;
                }
                this.available += buffer.getLength();
                this.q.put(bl2 ? (Buffer)buffer.clone() : buffer);
                if (this.trace) {
                    logger.fine(this + " put: available=" + this.available);
                }
                return true;
            }
        }
        catch (InterruptedException interruptedException) {
            logger.log(Level.WARNING, "" + interruptedException, interruptedException);
            throw new RuntimeException(interruptedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        this.fillBuffer();
        if (this.buffer.getLength() <= 0 && this.buffer.isEOM()) {
            if (this.trace) {
                logger.fine(this + " BufferQueueInputStream.read: returning -1");
            }
            return -1;
        }
        byte[] byArray = (byte[])this.buffer.getData();
        int n = byArray[this.buffer.getOffset()] & 0xFF;
        this.buffer.setOffset(this.buffer.getOffset() + 1);
        this.buffer.setLength(this.buffer.getLength() - 1);
        ProducerConsumerQueue producerConsumerQueue = this.q;
        synchronized (producerConsumerQueue) {
            --this.available;
            if (this.trace) {
                logger.fine(this + " read: available=" + this.available);
            }
        }
        if (this.trace) {
            logger.fine(this + " BufferQueueInputStream.read: returning " + n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        this.fillBuffer();
        if (this.buffer.getLength() <= 0 && this.buffer.isEOM()) {
            if (this.trace) {
                logger.fine(this + " BufferQueueInputStream.read: returning -1");
            }
            return -1;
        }
        byte[] byArray2 = (byte[])this.buffer.getData();
        if (byArray2 == null) {
            throw new NullPointerException("Buffer has null data.  length=" + this.buffer.getLength() + " offset=" + this.buffer.getOffset());
        }
        int n4 = n3 = this.buffer.getLength() < n2 ? this.buffer.getLength() : n2;
        if (this.trace) {
            logger.fine(this + " BufferQueueInputStream.read: lengthToCopy=" + n3 + " buffer.getLength()=" + this.buffer.getLength() + " buffer.getOffset()=" + this.buffer.getOffset() + " b.length=" + byArray.length + " len=" + n2 + " off=" + n);
        }
        System.arraycopy(byArray2, this.buffer.getOffset(), byArray, n, n3);
        this.buffer.setOffset(this.buffer.getOffset() + n3);
        this.buffer.setLength(this.buffer.getLength() - n3);
        ProducerConsumerQueue producerConsumerQueue = this.q;
        synchronized (producerConsumerQueue) {
            this.available -= n3;
            if (this.trace) {
                logger.fine(this + " read: available=" + this.available);
            }
        }
        if (this.trace) {
            logger.fine(this + " BufferQueueInputStream.read[]: returning " + n3);
        }
        return n3;
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
    }
}

