/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.apps.transcode;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Processor;
import javax.media.ProcessorModel;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.FileTypeDescriptor;
import net.sf.fmj.ejmf.toolkit.util.StateWaiter;
import net.sf.fmj.utility.FmjStartup;
import net.sf.fmj.utility.FormatArgUtils;
import net.sf.fmj.utility.LoggerSingleton;

public class FmjTranscode {
    private static final Logger logger = LoggerSingleton.logger;

    public static void main(String[] stringArray) throws Exception {
        FmjStartup.init();
        new FmjTranscode().run(stringArray);
    }

    private static void usage() {
        System.out.println("Usage: FmjTranscode [Input URL] [Output format [Output format...]] [Output MIME type] [Output URL]");
        System.out.println();
        System.out.println("Output URL may be specified as \"render:\", in which case the output is rendered instead of sent to a specific output.");
        System.out.println("In this case, set the output MIME type to: \"raw\"");
        System.out.println();
        System.out.println("Output format syntax:");
        System.out.println("    Audio: [encoding]:[sampleRate]:[sampleSizeInBits]:[channels]:[endian]:[signed]:[frameSizeInBits]:[frameRate]:[dataType]");
        System.out.println("    where any trailing components may be omitted (to set them to be unspecified),");
        System.out.println("    any component may be set to ? to indicate unspecified, and");
        System.out.println("    the following conventions are used for non-numeric components:");
        System.out.println("    endian: B or L for big- or little- endian, respectively");
        System.out.println("    signed: S or U for signed or unsigned, respectively");
        System.out.println("    dataType: B, S, or I for byte array, short array, or int array, respectively");
        System.out.println("    Example: LINEAR:44100:16:2 corresponds to linear (PCM), 44100.0 khz, 16 bits per sample, stereo.");
        System.out.println("    Example: ULAW/RTP:8000:8:1 corresponds to ULAW/RTP, 8000.0 khz, 8 bits per sample, mono.");
        System.out.println("    Example: LINEAR:22050:8:1:?:S corresponds to linear (PCM), 22050.0 khz, 8 bits per sample, mono, unspecified endianness, signed");
        System.out.println();
        System.out.println("    Video: [encoding]:[size]:[maxDataLength]:[dataType]:[frameRate]");
        System.out.println("    where any trailing components may be omitted (to set them to be unspecified),");
        System.out.println("    any component may be set to ? to indicate unspecified, and");
        System.out.println("    the following conventions are used for non-numeric components:");
        System.out.println("    size: [width]x[height]");
        System.out.println("    frameRate: frames per second as a floating-point value");
        System.out.println("    dataType: B, S, or I for byte array, short array, or int array, respectively");
        System.out.println("    Example: JPEG corresponds to JPEG (MJPEG), with everything else unspecified");
        System.out.println("    Example: PNG:640x480 corresponds to PNG (MPNG), 640x480, with everything else unspecified");
        System.out.println();
        System.out.println("Examples:");
        System.out.println("Transcode an audio file to another format:");
        System.out.println("    file://samplemedia/gulp2.wav LINEAR:22050:8:1:?:S audio/basic file://out.au");
        System.out.println("Record live video into a video file:");
        System.out.println("    civil:/0 JPEG multipart/x-mixed-replace file://out.mmr");
        System.out.println("Transmit an audio file via RTP:");
        System.out.println("    file://samplemedia/gulp2.wav ULAW/RTP:8000:8:1 raw/rtp rtp://192.168.1.2:8000/audio/16");
        System.out.println("Transmit live audio via RTP:");
        System.out.println("    javasound://0 ULAW/RTP:8000:8:1 raw/rtp rtp://192.168.1.2:8000/audio/16");
        System.out.println("    javasound://0 ULAW/RTP:8000:8:1 raw/rtp rtp://192.168.1.2:8000/audio/16");
        System.out.println("Extract video track from a movie and re-encode into another video file:");
        System.out.println("    file://samplemedia/Apollo_15_liftoff_from_inside_LM.ogg JPEG multipart/x-mixed-replace file://out.mmr");
        System.out.println("Extract audio track from a movie and re-encode into an audio file:");
        System.out.println("    file://samplemedia/Apollo_15_liftoff_from_inside_LM.ogg LINEAR:44100:8:1 audio/basic file://out.au");
        System.out.println("Receive RTP audio and record to a file:");
        System.out.println("    rtp://192.168.1.7:8000 LINEAR:8000:8:1 audio/basic file://out.au");
        System.out.println("Transmit live video via RTP:");
        System.out.println("    civil:/0 JPEG/RTP:160x120 raw/rtp rtp://192.168.1.2:8000/video/16");
        System.out.println("Receive RTP video and record to a file:");
        System.out.println("    rtp://192.168.1.1:8000 JPEG multipart/x-mixed-replace file://out.mmr");
        System.out.println("Render live audio in a specific format:");
        System.out.println("     javasound://0 LINEAR:8000:16:1:B:S raw render:");
        System.out.println("Render audio and video (merged):");
        System.out.println("    merge:[civil:/0][javasound://0] ? raw render:");
        System.out.println("Record both audio and video (merged) to an XML movie file:");
        System.out.println("    merge:[civil:/0][javasound://0] JPEG:160x120 LINEAR:8000:8:1 video/xml file://out.xmv");
    }

    public void run(String[] stringArray) throws Exception {
        int n;
        if (stringArray.length < 4) {
            FmjTranscode.usage();
            return;
        }
        String string = stringArray[0];
        String[] stringArray2 = new String[stringArray.length - 3];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringArray[1 + i];
        }
        String string2 = stringArray[stringArray.length - 2];
        String string3 = stringArray[stringArray.length - 1];
        FileTypeDescriptor fileTypeDescriptor = new FileTypeDescriptor(ContentDescriptor.mimeTypeToPackageName(string2));
        Format[] formatArray = new Format[stringArray2.length];
        for (n = 0; n < stringArray2.length; ++n) {
            formatArray[n] = stringArray2[n].equals("?") ? null : FormatArgUtils.parse(stringArray2[n]);
        }
        logger.info("Source URL: " + string);
        logger.info("Output MIME type: " + string2);
        logger.info("Output Content descriptor: " + fileTypeDescriptor);
        for (n = 0; n < formatArray.length; ++n) {
            logger.info("Output Format " + n + ": " + formatArray[n]);
        }
        logger.info("Output URL: " + string3);
        this.transcode(string, formatArray, fileTypeDescriptor, string3);
    }

    private void transcode(String string, Format[] formatArray, ContentDescriptor contentDescriptor, String string2) throws Exception {
        ProcessorModel processorModel = new ProcessorModel(new MediaLocator(string), formatArray, contentDescriptor);
        final Processor processor = Manager.createRealizedProcessor(processorModel);
        DataSource dataSource = processor.getDataOutput();
        Object object = new MediaLocator(string2);
        DataSink dataSink = Manager.createDataSink(dataSource, (MediaLocator)object);
        dataSink.open();
        dataSink.start();
        logger.info("Starting processor");
        object = new StateWaiter(processor);
        if (!((StateWaiter)object).blockingStart()) {
            throw new Exception("Failed to start");
        }
        KeyboardInputThread keyboardInputThread = new KeyboardInputThread(processor);
        keyboardInputThread.setDaemon(true);
        keyboardInputThread.start();
        processor.addControllerListener(new ControllerListener(){

            public void controllerUpdate(ControllerEvent controllerEvent) {
                if (controllerEvent instanceof EndOfMediaEvent) {
                    logger.info("EOM, stopping processor");
                    processor.stop();
                }
            }
        });
        if (!((StateWaiter)object).blockingWait(300)) {
            throw new Exception("Failed to reach stopped state");
        }
        logger.fine("Closing processor");
        processor.close();
        logger.fine("Deallocating processor");
        processor.deallocate();
        if (dataSink != null) {
            logger.fine("Stopping dest datasink");
            dataSink.stop();
            logger.fine("Closing dest datasink");
            dataSink.close();
        }
        if (keyboardInputThread.wasProcessorStopped()) {
            logger.info("Transcode terminated.");
        } else {
            logger.info("Transcode complete.");
        }
    }

    static class KeyboardInputThread
    extends Thread {
        private final Processor processor;
        private boolean processorStopped;

        public KeyboardInputThread(Processor processor) {
            this.processor = processor;
            this.setName("KeyboardInputThread");
        }

        public void run() {
            try {
                System.out.println("Press ENTER to stop");
                int n = System.in.read();
                System.out.println("ENTER pressed, stopping processor...");
                this.processor.stop();
                this.processorStopped = true;
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "" + iOException, iOException);
            }
        }

        public boolean wasProcessorStopped() {
            return this.processorStopped;
        }
    }
}

