/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.version;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jitsi.service.version.Version;
import org.jitsi.service.version.VersionService;
import org.jitsi.videobridge.version.VersionImpl;

public class VersionServiceImpl
implements VersionService {
    private static final Pattern PARSE_VERSION_STRING_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.([\\d\\.]+)");

    public Version parseVersionString(String version) {
        Matcher matcher = PARSE_VERSION_STRING_PATTERN.matcher(version);
        if (matcher.matches() && matcher.groupCount() == 3) {
            return VersionImpl.customVersion(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), matcher.group(3));
        }
        return null;
    }

    public Version getCurrentVersion() {
        return VersionImpl.currentVersion();
    }
}

