/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.gui;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import net.java.sip.communicator.service.gui.Container;
import net.java.sip.communicator.service.gui.PluginComponent;

public abstract class PluginComponentFactory {
    private Container container;
    private String constraints;
    private int position;
    private boolean nativeComponent;
    private WeakHashMap<Object, WeakReference<PluginComponent>> pluginInstances = new WeakHashMap();

    public PluginComponentFactory(Container container) {
        this(container, null, -1, false);
    }

    public PluginComponentFactory(Container container, String constraints, int position, boolean nativeComponent) {
        this.container = container;
        this.constraints = constraints;
        this.position = position;
        this.nativeComponent = nativeComponent;
    }

    public Container getContainer() {
        return this.container;
    }

    public String getConstraints() {
        return this.constraints;
    }

    public int getPositionIndex() {
        return this.position;
    }

    public boolean isNativeComponent() {
        return this.nativeComponent;
    }

    public PluginComponent getPluginComponentInstance(Object parent) {
        PluginComponent pluginComponent;
        WeakReference<PluginComponent> ref = this.pluginInstances.get(parent);
        PluginComponent pluginComponent2 = pluginComponent = ref == null ? null : (PluginComponent)ref.get();
        if (pluginComponent == null && (pluginComponent = this.getPluginInstance()) != null) {
            ref = new WeakReference<PluginComponent>(pluginComponent);
            this.pluginInstances.put(parent, ref);
        }
        return pluginComponent;
    }

    protected abstract PluginComponent getPluginInstance();
}

