/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.video.jpeg;

import com.lti.utils.UnsignedUtils;
import net.sf.fmj.media.codec.video.jpeg.RFC2035;
import net.sf.fmj.utility.ArrayUtility;

public class JpegRTPHeader {
    public static final int HEADER_SIZE = 8;
    private final byte typeSpecific;
    private final int fragmentOffset;
    private final byte type;
    private final byte q;
    private final byte width;
    private final byte height;
    private static final int BITS_PER_BYTE = 8;
    private static final int MAX_SIGNED_BYTE = 127;
    private static final int MAX_BYTE = 255;
    private static final int MAX_BYTE_PLUS1 = 256;

    public static byte[] createQHeader(int n, int[] nArray, int[] nArray2) {
        int n2 = 4 + n;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        byte by = 0;
        byte by2 = 0;
        byArray[n3++] = by;
        byArray[n3++] = by2;
        byArray[n3++] = (byte)(n >> 8 & 0xFF);
        byArray[n3++] = (byte)n;
        if (n != 0) {
            int[] nArray3 = RFC2035.createZigZag(nArray);
            int[] nArray4 = RFC2035.createZigZag(nArray2);
            System.arraycopy(ArrayUtility.intArrayToByteArray(nArray3), 0, byArray, n3, nArray.length);
            System.arraycopy(ArrayUtility.intArrayToByteArray(nArray4), 0, byArray, n3 += nArray.length, nArray2.length);
            n3 += nArray2.length;
        }
        return byArray;
    }

    public static byte[] createRstHeader(int n, int n2, int n3, int n4) {
        byte[] byArray = new byte[4];
        int n5 = 0;
        byArray[n5++] = (byte)(n >> 8 & 0xFF);
        byArray[n5++] = (byte)n;
        byArray[n5] = (byte)((n2 & 1) << 7);
        int n6 = n5;
        byArray[n6] = (byte)(byArray[n6] | (byte)((n3 & 1) << 6));
        int n7 = n5++;
        byArray[n7] = (byte)(byArray[n7] | (byte)(n4 >> 8 & 0xFF) & 0x3F);
        byArray[n5] = (byte)n4;
        return byArray;
    }

    private static void encode3ByteIntBE(int n, byte[] byArray, int n2) {
        int n3 = 3;
        for (int i = 0; i < n3; ++i) {
            int n4 = n & 0xFF;
            if (n4 > 127) {
                n4 -= 256;
            }
            byArray[n2 + (n3 - i - 1)] = (byte)n4;
            n >>= 8;
        }
    }

    public static JpegRTPHeader parse(byte[] byArray, int n) {
        byte by;
        int n2 = n;
        byte by2 = byArray[n2++];
        int n3 = 0;
        for (by = 0; by < 3; ++by) {
            n3 <<= 8;
            n3 += byArray[n2++] & 0xFF;
        }
        by = byArray[n2++];
        byte by3 = byArray[n2++];
        byte by4 = byArray[n2++];
        byte by5 = byArray[n2++];
        return new JpegRTPHeader(by2, n3, by, by3, by4, by5);
    }

    public JpegRTPHeader(byte by, int n, byte by2, byte by3, byte by4, byte by5) {
        this.typeSpecific = by;
        this.fragmentOffset = n;
        this.type = by2;
        this.q = by3;
        this.width = by4;
        this.height = by5;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JpegRTPHeader)) {
            return false;
        }
        JpegRTPHeader jpegRTPHeader = (JpegRTPHeader)object;
        return this.typeSpecific == jpegRTPHeader.typeSpecific && this.fragmentOffset == jpegRTPHeader.fragmentOffset && this.type == jpegRTPHeader.type && this.q == jpegRTPHeader.q && this.width == jpegRTPHeader.width && this.height == jpegRTPHeader.height;
    }

    public int getFragmentOffset() {
        return this.fragmentOffset;
    }

    public int getHeightInBlocks() {
        return UnsignedUtils.uByteToInt(this.height);
    }

    public int getHeightInPixels() {
        return UnsignedUtils.uByteToInt(this.height) * 8;
    }

    public int getQ() {
        return UnsignedUtils.uByteToInt(this.q);
    }

    public int getType() {
        return UnsignedUtils.uByteToInt(this.type);
    }

    public int getTypeSpecific() {
        return UnsignedUtils.uByteToInt(this.typeSpecific);
    }

    public int getWidthInBlocks() {
        return UnsignedUtils.uByteToInt(this.width);
    }

    public int getWidthInPixels() {
        return UnsignedUtils.uByteToInt(this.width) * 8;
    }

    public int hashCode() {
        return this.typeSpecific + this.fragmentOffset + this.type + this.q + this.width + this.height;
    }

    public byte[] toBytes() {
        byte[] byArray = new byte[8];
        int n = 0;
        byArray[n++] = this.typeSpecific;
        JpegRTPHeader.encode3ByteIntBE(this.fragmentOffset, byArray, n);
        n += 3;
        byArray[n++] = this.type;
        byArray[n++] = this.q;
        byArray[n++] = this.width;
        byArray[n++] = this.height;
        return byArray;
    }

    public String toString() {
        return "typeSpecific=" + this.getTypeSpecific() + " fragmentOffset=" + this.getFragmentOffset() + " type=" + this.getType() + " q=" + this.getQ() + " w=" + this.getWidthInPixels() + " h=" + this.getHeightInPixels();
    }
}

