/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.packets.in;

import java.nio.ByteBuffer;
import net.sf.jqql.Util;
import net.sf.jqql.beans.QQUser;
import net.sf.jqql.packets.PacketParseException;
import net.sf.jqql.packets._08BasicInPacket;

public class LoginReplyPacket
extends _08BasicInPacket {
    public byte[] sessionKey;
    public byte[] ip;
    public byte[] serverIp;
    public byte[] lastLoginIp;
    public byte[] redirectIp;
    public int port;
    public int serverPort;
    public int redirectPort;
    public long loginTime;
    public long lastLoginTime;
    public byte replyCode;
    public String replyMessage;
    public byte[] clientKey;
    public byte[] authToken;

    public LoginReplyPacket(ByteBuffer byteBuffer, int n, QQUser qQUser) throws PacketParseException {
        super(byteBuffer, n, qQUser);
    }

    public String getPacketName() {
        return "Login Reply _08Packet";
    }

    public byte[] getDecryptKey(byte[] byArray) {
        return this.user.getPasswordKey();
    }

    public byte[] getFallbackDecryptKey(byte[] byArray) {
        return this.user.getInitKey();
    }

    protected void parseBody(ByteBuffer byteBuffer) throws PacketParseException {
        this.replyCode = byteBuffer.get();
        switch (this.replyCode) {
            case 0: {
                this.sessionKey = new byte[16];
                byteBuffer.get(this.sessionKey);
                byteBuffer.getInt();
                this.ip = new byte[4];
                byteBuffer.get(this.ip);
                this.port = byteBuffer.getChar();
                this.serverIp = new byte[4];
                byteBuffer.get(this.serverIp);
                this.serverPort = byteBuffer.getChar();
                this.loginTime = (long)byteBuffer.getInt() * 1000L;
                byteBuffer.getChar();
                this.authToken = new byte[24];
                byteBuffer.get(this.authToken);
                byteBuffer.position(byteBuffer.position() + 20);
                this.clientKey = new byte[32];
                byteBuffer.get(this.clientKey);
                byteBuffer.position(byteBuffer.position() + 12);
                this.lastLoginIp = new byte[4];
                byteBuffer.get(this.lastLoginIp);
                this.lastLoginTime = (long)byteBuffer.getInt() * 1000L;
                break;
            }
            case 9: {
                byte[] byArray = byteBuffer.array();
                this.replyMessage = Util.getString(byArray, 1, byArray.length - 1, "GBK");
                break;
            }
            case 10: {
                byteBuffer.getInt();
                byteBuffer.position(byteBuffer.position() + 10);
                this.redirectIp = new byte[4];
                byteBuffer.get(this.redirectIp);
                this.redirectPort = this.user.getPort();
            }
        }
    }
}

