/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.loc;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.DirInfo;
import net.kano.joscar.snaccmd.loc.LocCommand;

public class DirInfoCmd
extends LocCommand {
    public static final int CODE_SUCCESS = 1;
    public static final int CODE_ERROR = 2;
    private final int code;
    private final DirInfo dirInfo;

    protected DirInfoCmd(SnacPacket packet) {
        super(12);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock snacData = packet.getData();
        this.code = BinaryTools.getUShort((ByteBlock)snacData, (int)0);
        int tlvCount = BinaryTools.getUShort((ByteBlock)snacData, (int)2);
        ByteBlock infoBlock = snacData.subBlock(4);
        this.dirInfo = DirInfo.readDirInfo(infoBlock, tlvCount);
    }

    public DirInfoCmd(DirInfo dirInfo) {
        this(dirInfo != null ? 1 : 2, dirInfo);
    }

    public DirInfoCmd(int code, DirInfo dirInfo) {
        super(12);
        DefensiveTools.checkRange((int)code, (String)"code", (int)0);
        this.code = code;
        this.dirInfo = dirInfo;
    }

    public final int getResultCode() {
        return this.code;
    }

    public final DirInfo getDirInfo() {
        return this.dirInfo;
    }

    public void writeData(OutputStream out) throws IOException {
        BinaryTools.writeUShort((OutputStream)out, (int)this.code);
        if (this.dirInfo != null) {
            this.dirInfo.write(out);
        }
    }

    public String toString() {
        return "DirInfoCmd: code=" + this.code + ", dirinfo=<" + this.dirInfo + ">";
    }
}

