/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import gov.nist.core.GenericObject;
import gov.nist.core.Host;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class HostPort
extends GenericObject {
    protected Host host = null;
    protected int port = -1;

    public String encode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.host.encode());
        if (this.port != -1) {
            stringBuffer.append(":").append(this.port);
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HostPort hostPort = (HostPort)object;
        return this.port == hostPort.port && this.host.equals(hostPort.host);
    }

    public Host getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean hasPort() {
        return this.port != -1;
    }

    public void removePort() {
        this.port = -1;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        if (this.host == null) {
            return null;
        }
        return this.host.getInetAddress();
    }

    public void merge(Object object) {
        super.merge(object);
        if (this.port == -1) {
            this.port = ((HostPort)object).port;
        }
    }

    public Object clone() {
        HostPort hostPort = (HostPort)super.clone();
        if (this.host != null) {
            hostPort.host = (Host)this.host.clone();
        }
        return hostPort;
    }

    public String toString() {
        return this.encode();
    }
}

