/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.chat;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.Writable;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.FullUserInfo;
import net.kano.joscar.snaccmd.chat.AbstractChatMsgIcbm;
import net.kano.joscar.snaccmd.chat.ChatMsg;
import net.kano.joscar.snaccmd.icbm.RecvIcbm;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;

public class RecvChatMsgIcbm
extends AbstractChatMsgIcbm
implements RecvIcbm {
    private static final int TYPE_USERINFO = 3;
    private final FullUserInfo senderInfo;

    protected RecvChatMsgIcbm(SnacPacket packet) {
        super(6, packet);
        TlvChain chain = this.getChatTlvs();
        Tlv userTlv = chain.getLastTlv(3);
        if (userTlv != null) {
            ByteBlock userBlock = userTlv.getData();
            this.senderInfo = FullUserInfo.readUserInfo(userBlock);
        } else {
            this.senderInfo = null;
        }
    }

    public RecvChatMsgIcbm(long messageId, FullUserInfo senderInfo, ChatMsg chatMsg) {
        super(6, messageId, chatMsg);
        this.senderInfo = senderInfo;
    }

    public final FullUserInfo getSenderInfo() {
        return this.senderInfo;
    }

    protected void writeChatTlvs(OutputStream out) throws IOException {
        if (this.senderInfo != null) {
            ByteBlock senderBlock = ByteBlock.createByteBlock((LiveWritable)this.senderInfo);
            new Tlv(3, (Writable)senderBlock).write(out);
        }
    }

    public String toString() {
        return "RecvChatMsgIcbm: user=<" + this.senderInfo + "> - " + super.toString();
    }
}

