/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.RuntimeIOException;
import org.apache.mina.common.TransportType;
import org.apache.mina.common.support.BaseIoSession;
import org.apache.mina.common.support.BaseIoSessionConfig;
import org.apache.mina.common.support.IoServiceListenerSupport;
import org.apache.mina.transport.socket.nio.SocketFilterChain;
import org.apache.mina.transport.socket.nio.SocketIoProcessor;
import org.apache.mina.transport.socket.nio.SocketSessionConfig;
import org.apache.mina.transport.socket.nio.SocketSessionConfigImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SocketSessionImpl
extends BaseIoSession {
    private final IoService manager;
    private final IoServiceConfig serviceConfig;
    private final SocketSessionConfig config = new SessionConfigImpl();
    private final SocketIoProcessor ioProcessor;
    private final SocketFilterChain filterChain;
    private final SocketChannel ch;
    private final Queue<IoFilter.WriteRequest> writeRequestQueue;
    private final IoHandler handler;
    private final SocketAddress remoteAddress;
    private final SocketAddress localAddress;
    private final SocketAddress serviceAddress;
    private final IoServiceListenerSupport serviceListeners;
    private SelectionKey key;
    private int readBufferSize = 1024;

    SocketSessionImpl(IoService manager, SocketIoProcessor ioProcessor, IoServiceListenerSupport listeners, IoServiceConfig serviceConfig, SocketChannel ch, IoHandler defaultHandler, SocketAddress serviceAddress) {
        this.manager = manager;
        this.serviceListeners = listeners;
        this.ioProcessor = ioProcessor;
        this.filterChain = new SocketFilterChain(this);
        this.ch = ch;
        this.writeRequestQueue = new ConcurrentLinkedQueue<IoFilter.WriteRequest>();
        this.handler = defaultHandler;
        this.remoteAddress = ch.socket().getRemoteSocketAddress();
        this.localAddress = ch.socket().getLocalSocketAddress();
        this.serviceAddress = serviceAddress;
        this.serviceConfig = serviceConfig;
        IoSessionConfig sessionConfig = serviceConfig.getSessionConfig();
        if (sessionConfig instanceof SocketSessionConfig) {
            SocketSessionConfig cfg = (SocketSessionConfig)sessionConfig;
            this.config.setKeepAlive(cfg.isKeepAlive());
            this.config.setOobInline(cfg.isOobInline());
            this.config.setReceiveBufferSize(cfg.getReceiveBufferSize());
            this.config.setReuseAddress(cfg.isReuseAddress());
            this.config.setSendBufferSize(cfg.getSendBufferSize());
            this.config.setSoLinger(cfg.getSoLinger());
            this.config.setTcpNoDelay(cfg.isTcpNoDelay());
            if (this.config.getTrafficClass() != cfg.getTrafficClass()) {
                this.config.setTrafficClass(cfg.getTrafficClass());
            }
        }
    }

    @Override
    public IoService getService() {
        return this.manager;
    }

    @Override
    public IoServiceConfig getServiceConfig() {
        return this.serviceConfig;
    }

    @Override
    public IoSessionConfig getConfig() {
        return this.config;
    }

    SocketIoProcessor getIoProcessor() {
        return this.ioProcessor;
    }

    @Override
    public IoFilterChain getFilterChain() {
        return this.filterChain;
    }

    SocketChannel getChannel() {
        return this.ch;
    }

    IoServiceListenerSupport getServiceListeners() {
        return this.serviceListeners;
    }

    SelectionKey getSelectionKey() {
        return this.key;
    }

    void setSelectionKey(SelectionKey key) {
        this.key = key;
    }

    @Override
    public IoHandler getHandler() {
        return this.handler;
    }

    @Override
    protected void close0() {
        this.filterChain.fireFilterClose(this);
    }

    Queue<IoFilter.WriteRequest> getWriteRequestQueue() {
        return this.writeRequestQueue;
    }

    @Override
    protected void write0(IoFilter.WriteRequest writeRequest) {
        this.filterChain.fireFilterWrite(this, writeRequest);
    }

    @Override
    public TransportType getTransportType() {
        return TransportType.SOCKET;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public SocketAddress getServiceAddress() {
        return this.serviceAddress;
    }

    @Override
    protected void updateTrafficMask() {
        this.ioProcessor.updateTrafficMask(this);
    }

    int getReadBufferSize() {
        return this.readBufferSize;
    }

    void setReadBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    private class SessionConfigImpl
    extends BaseIoSessionConfig
    implements SocketSessionConfig {
        private SessionConfigImpl() {
        }

        public boolean isKeepAlive() {
            try {
                return SocketSessionImpl.this.ch.socket().getKeepAlive();
            }
            catch (SocketException e) {
                throw new RuntimeIOException(e);
            }
        }

        public void setKeepAlive(boolean on) {
            try {
                SocketSessionImpl.this.ch.socket().setKeepAlive(on);
            }
            catch (SocketException e) {
                throw new RuntimeIOException(e);
            }
        }

        public boolean isOobInline() {
            try {
                return SocketSessionImpl.this.ch.socket().getOOBInline();
            }
            catch (SocketException e) {
                throw new RuntimeIOException(e);
            }
        }

        public void setOobInline(boolean on) {
            try {
                SocketSessionImpl.this.ch.socket().setOOBInline(on);
            }
            catch (SocketException e) {
                throw new RuntimeIOException(e);
            }
        }

        public boolean isReuseAddress() {
            try {
                return SocketSessionImpl.this.ch.socket().getReuseAddress();
            }
            catch (SocketException e) {
                throw new RuntimeIOException(e);
            }
        }

        public void setReuseAddress(boolean on) {
            try {
                SocketSessionImpl.this.ch.socket().setReuseAddress(on);
            }
            catch (SocketException e) {
                throw new RuntimeIOException(e);
            }
        }

        public int getSoLinger() {
            try {
                return SocketSessionImpl.this.ch.socket().getSoLinger();
            }
            catch (SocketException e) {
                throw new RuntimeIOException(e);
            }
        }

        public void setSoLinger(int linger) {
            try {
                if (linger < 0) {
                    SocketSessionImpl.this.ch.socket().setSoLinger(false, 0);
                } else {
                    SocketSessionImpl.this.ch.socket().setSoLinger(true, linger);
                }
            }
            catch (SocketException e) {
                throw new RuntimeIOException(e);
            }
        }

        public boolean isTcpNoDelay() {
            try {
                return SocketSessionImpl.this.ch.socket().getTcpNoDelay();
            }
            catch (SocketException e) {
                throw new RuntimeIOException(e);
            }
        }

        public void setTcpNoDelay(boolean on) {
            try {
                SocketSessionImpl.this.ch.socket().setTcpNoDelay(on);
            }
            catch (SocketException e) {
                throw new RuntimeIOException(e);
            }
        }

        public int getTrafficClass() {
            block3: {
                if (SocketSessionConfigImpl.isGetTrafficClassAvailable()) {
                    try {
                        return SocketSessionImpl.this.ch.socket().getTrafficClass();
                    }
                    catch (SocketException e) {
                        if (!SocketSessionConfigImpl.isSetTrafficClassAvailable()) break block3;
                        throw new RuntimeIOException(e);
                    }
                }
            }
            return 0;
        }

        public void setTrafficClass(int tc) {
            if (SocketSessionConfigImpl.isSetTrafficClassAvailable()) {
                try {
                    SocketSessionImpl.this.ch.socket().setTrafficClass(tc);
                }
                catch (SocketException e) {
                    throw new RuntimeIOException(e);
                }
            }
        }

        public int getSendBufferSize() {
            try {
                return SocketSessionImpl.this.ch.socket().getSendBufferSize();
            }
            catch (SocketException e) {
                throw new RuntimeIOException(e);
            }
        }

        public void setSendBufferSize(int size) {
            if (SocketSessionConfigImpl.isSetSendBufferSizeAvailable()) {
                try {
                    SocketSessionImpl.this.ch.socket().setSendBufferSize(size);
                }
                catch (SocketException e) {
                    throw new RuntimeIOException(e);
                }
            }
        }

        public int getReceiveBufferSize() {
            try {
                return SocketSessionImpl.this.ch.socket().getReceiveBufferSize();
            }
            catch (SocketException e) {
                throw new RuntimeIOException(e);
            }
        }

        public void setReceiveBufferSize(int size) {
            if (SocketSessionConfigImpl.isSetReceiveBufferSizeAvailable()) {
                try {
                    SocketSessionImpl.this.ch.socket().setReceiveBufferSize(size);
                }
                catch (SocketException e) {
                    throw new RuntimeIOException(e);
                }
            }
        }
    }
}

