/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.convert;

import com.owlike.genson.Context;
import com.owlike.genson.Converter;
import com.owlike.genson.Genson;
import com.owlike.genson.JsonBindingException;
import com.owlike.genson.Wrapper;
import com.owlike.genson.annotation.HandleNull;
import com.owlike.genson.convert.ChainedFactory;
import com.owlike.genson.reflect.TypeUtil;
import com.owlike.genson.stream.ObjectReader;
import com.owlike.genson.stream.ObjectWriter;
import com.owlike.genson.stream.ValueType;
import java.lang.reflect.Type;

public class NullConverterFactory
extends ChainedFactory {
    private final boolean failOnNullPrimitive;

    public NullConverterFactory(boolean failOnNullPrimitive) {
        this.failOnNullPrimitive = failOnNullPrimitive;
    }

    @Override
    protected Converter<?> create(Type type, Genson genson, Converter<?> nextConverter) {
        if (Wrapper.toAnnotatedElement(nextConverter).isAnnotationPresent(HandleNull.class)) {
            return nextConverter;
        }
        Class<?> rawClass = TypeUtil.getRawClass(type);
        if (this.failOnNullPrimitive && rawClass.isPrimitive()) {
            return new FailIfNullConverter(nextConverter);
        }
        return new NullConverterWrapper(genson.defaultValue(rawClass), nextConverter);
    }

    private class NullConverterWrapper<T>
    extends Wrapper<Converter<T>>
    implements Converter<T> {
        private final T defaultValue;

        public NullConverterWrapper(T defaultValue, Converter<T> converter) {
            super(converter);
            this.defaultValue = defaultValue;
        }

        @Override
        public void serialize(T obj, ObjectWriter writer, Context ctx) throws Exception {
            if (obj == null) {
                writer.writeNull();
            } else {
                ((Converter)this.wrapped).serialize(obj, writer, ctx);
            }
        }

        @Override
        public T deserialize(ObjectReader reader, Context ctx) throws Exception {
            if (ValueType.NULL == reader.getValueType()) {
                return this.defaultValue;
            }
            return ((Converter)this.wrapped).deserialize(reader, ctx);
        }
    }

    private class FailIfNullConverter<T>
    extends Wrapper<Converter<T>>
    implements Converter<T> {
        public FailIfNullConverter(Converter<T> delegate) {
            super(delegate);
        }

        @Override
        public void serialize(T object, ObjectWriter writer, Context ctx) throws Exception {
            if (object == null) {
                throw new JsonBindingException("Serialization of null primitives is forbidden");
            }
            ((Converter)this.wrapped).serialize(object, writer, ctx);
        }

        @Override
        public T deserialize(ObjectReader reader, Context ctx) throws Exception {
            if (ValueType.NULL == reader.getValueType()) {
                throw new JsonBindingException("Can not deserialize null to a primitive type");
            }
            return ((Converter)this.wrapped).deserialize(reader, ctx);
        }
    }
}

