/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupAlreadyExistsException;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.plugin.rest.entity.GroupEntity;
import org.jivesoftware.openfire.plugin.rest.exceptions.ServiceException;
import org.jivesoftware.openfire.plugin.rest.utils.MUCRoomUtils;

public class GroupController {
    public static final GroupController INSTANCE = new GroupController();

    public static GroupController getInstance() {
        return INSTANCE;
    }

    public List<GroupEntity> getGroups() throws ServiceException {
        Collection groups = GroupManager.getInstance().getGroups();
        ArrayList<GroupEntity> groupEntities = new ArrayList<GroupEntity>();
        for (Group group : groups) {
            GroupEntity groupEntity = new GroupEntity(group.getName(), group.getDescription());
            groupEntities.add(groupEntity);
        }
        return groupEntities;
    }

    public GroupEntity getGroup(String groupName) throws ServiceException {
        Group group;
        try {
            group = GroupManager.getInstance().getGroup(groupName);
        }
        catch (GroupNotFoundException e) {
            throw new ServiceException("Could not find group", groupName, "GroupNotFoundException", Response.Status.NOT_FOUND, e);
        }
        GroupEntity groupEntity = new GroupEntity(group.getName(), group.getDescription());
        groupEntity.setAdmins(MUCRoomUtils.convertJIDsToStringList(group.getAdmins()));
        groupEntity.setMembers(MUCRoomUtils.convertJIDsToStringList(group.getMembers()));
        return groupEntity;
    }

    public Group createGroup(GroupEntity groupEntity) throws ServiceException {
        Group group;
        if (groupEntity != null && !groupEntity.getName().isEmpty()) {
            try {
                group = GroupManager.getInstance().createGroup(groupEntity.getName());
                group.setDescription(groupEntity.getDescription());
                group.getProperties().put((Object)"sharedRoster.showInRoster", (Object)"onlyGroup");
                group.getProperties().put((Object)"sharedRoster.displayName", (Object)groupEntity.getName());
                group.getProperties().put((Object)"sharedRoster.groupList", (Object)"");
            }
            catch (GroupAlreadyExistsException e) {
                throw new ServiceException("Could not create a group", groupEntity.getName(), "GroupAlreadyExistsException", Response.Status.CONFLICT, e);
            }
        } else {
            throw new ServiceException("Could not create new group", "groups", "IllegalArgumentException", Response.Status.BAD_REQUEST);
        }
        return group;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Group updateGroup(String groupName, GroupEntity groupEntity) throws ServiceException {
        if (groupEntity == null || groupEntity.getName().isEmpty()) throw new ServiceException("Could not update new group", "groups", "IllegalArgumentException", Response.Status.BAD_REQUEST);
        if (!groupName.equals(groupEntity.getName())) throw new ServiceException("Could not update the group. The group name is different to the payload group name.", groupName + " != " + groupEntity.getName(), "IllegalArgumentException", Response.Status.BAD_REQUEST);
        try {
            Group group = GroupManager.getInstance().getGroup(groupName);
            group.setDescription(groupEntity.getDescription());
            return group;
        }
        catch (GroupNotFoundException e) {
            throw new ServiceException("Could not find group", groupName, "GroupNotFoundException", Response.Status.NOT_FOUND, e);
        }
    }

    public void deleteGroup(String groupName) throws ServiceException {
        try {
            Group group = GroupManager.getInstance().getGroup(groupName);
            GroupManager.getInstance().deleteGroup(group);
        }
        catch (GroupNotFoundException e) {
            throw new ServiceException("Could not find group", groupName, "GroupNotFoundException", Response.Status.NOT_FOUND, e);
        }
    }
}

