/*
 * Decompiled with CFR 0.152.
 */
package ymsg.support;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class EmoteManager {
    private static Hashtable defaultRoom = new Hashtable();
    private static Hashtable defaultUser = new Hashtable();
    private Hashtable room;
    private Hashtable user;
    private Vector errors;
    private Vector keys;

    private EmoteManager() {
    }

    private EmoteManager(boolean bl) {
        if (bl) {
            this.room = (Hashtable)defaultRoom.clone();
            this.user = (Hashtable)defaultUser.clone();
        } else {
            this.room = new Hashtable();
            this.user = new Hashtable();
        }
        this.errors = new Vector();
    }

    public EmoteManager(File file, boolean bl) {
        this(bl);
        try {
            EmoteManager.loadEmoteData(new FileInputStream(file), this.room, this.user, this.errors);
            this.setupKeys();
        }
        catch (IOException iOException) {
            this.errors.addElement(iOException.toString());
        }
    }

    public EmoteManager(String string, boolean bl) {
        this(bl);
        try {
            EmoteManager.loadEmoteData(new FileInputStream(string), this.room, this.user, this.errors);
            this.setupKeys();
        }
        catch (IOException iOException) {
            this.errors.addElement(iOException.toString());
        }
    }

    public EmoteManager(URL uRL, boolean bl) {
        this(bl);
        try {
            EmoteManager.loadEmoteData(uRL.openStream(), this.room, this.user, this.errors);
            this.setupKeys();
        }
        catch (IOException iOException) {
            this.errors.addElement(iOException.toString());
        }
    }

    private static void loadEmoteData(InputStream inputStream, Hashtable hashtable, Hashtable hashtable2, Vector vector) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = bufferedReader.readLine();
        int n = 0;
        while (string != null) {
            block4: {
                string = string.trim();
                ++n;
                if (string.length() > 0 && !string.startsWith("#")) {
                    try {
                        int n2 = string.indexOf("\\");
                        String string2 = string.substring(0, n2);
                        string = string.substring(n2 + 1);
                        n2 = string.indexOf("\\");
                        String string3 = string.substring(0, n2);
                        String string4 = string = string.substring(n2 + 1);
                        hashtable.put(string2, string3);
                        hashtable2.put(string2, string4);
                    }
                    catch (Exception exception) {
                        if (vector == null) break block4;
                        vector.addElement("Emote format error, line " + n);
                    }
                }
            }
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
    }

    private void setupKeys() {
        this.keys = new Vector();
        Enumeration enumeration = this.room.keys();
        while (enumeration.hasMoreElements()) {
            this.keys.addElement(enumeration.nextElement());
        }
    }

    public Vector getErrors() {
        return this.errors;
    }

    public String getRoomEmote(String string) {
        return (String)this.room.get(string);
    }

    public String getUserEmote(String string) {
        return (String)this.user.get(string);
    }

    public Vector getNames() {
        return (Vector)this.keys.clone();
    }

    public static String encodeEmote(String string, String string2) {
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = string2.indexOf("%s");
            while (n >= 0) {
                stringBuffer.append(string2.substring(0, n));
                stringBuffer.append(string);
                string2 = string2.substring(n + 2);
                n = string2.indexOf("%s");
            }
            stringBuffer.append(string2);
            return stringBuffer.toString();
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        EmoteManager emoteManager = new EmoteManager(stringArray[0], true);
        Vector vector = emoteManager.getNames();
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            System.out.println(string + ": [" + emoteManager.getRoomEmote(string) + "] [" + emoteManager.getUserEmote(string) + "]");
        }
    }

    static {
        Vector vector = new Vector();
        try {
            Class<?> clazz = new EmoteManager().getClass();
            EmoteManager.loadEmoteData(clazz.getResource("default_emotes").openStream(), defaultRoom, defaultUser, vector);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        for (int i = 0; i < vector.size(); ++i) {
            System.err.println((String)vector.elementAt(i));
        }
    }
}

