/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard.WhiteboardObjectJabberImpl;
import net.java.sip.communicator.service.protocol.WhiteboardPoint;
import net.java.sip.communicator.service.protocol.whiteboardobjects.WhiteboardObjectRect;
import net.java.sip.communicator.util.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WhiteboardObjectRectJabberImpl
extends WhiteboardObjectJabberImpl
implements WhiteboardObjectRect {
    private static final Logger logger = Logger.getLogger(WhiteboardObjectRectJabberImpl.class);
    private double height;
    private double width;
    private boolean fill;
    private WhiteboardPoint whiteboardPoint;
    private int backColor;

    public WhiteboardObjectRectJabberImpl() {
    }

    public WhiteboardObjectRectJabberImpl(String id, int thickness, int color, int backColor, WhiteboardPoint whiteboardPoint, double width, double height, boolean fill) {
        super(id, thickness, color);
        this.setBackgroundColor(backColor);
        this.setWhiteboardPoint(whiteboardPoint);
        this.setWidth(width);
        this.setHeight(height);
        this.setFill(fill);
    }

    public WhiteboardObjectRectJabberImpl(String xml) {
        block7: {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
                Document doc = builder.parse(in);
                Element e = doc.getDocumentElement();
                String elementName = e.getNodeName();
                if (elementName.equals("rect")) {
                    String id = e.getAttribute("id");
                    double x = Double.parseDouble(e.getAttribute("x"));
                    double y = Double.parseDouble(e.getAttribute("y"));
                    double width = Double.parseDouble(e.getAttribute("width"));
                    double height = Double.parseDouble(e.getAttribute("height"));
                    String stroke = e.getAttribute("stroke");
                    String stroke_width = e.getAttribute("stroke-width");
                    String fill = e.getAttribute("fill");
                    this.setID(id);
                    this.setWhiteboardPoint(new WhiteboardPoint(x, y));
                    this.setWidth(width);
                    this.setHeight(height);
                    this.setFill(!fill.equals("none"));
                    this.setThickness(Integer.parseInt(stroke_width));
                    this.setColor(Color.decode(stroke).getRGB());
                }
            }
            catch (ParserConfigurationException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Problem WhiteboardObject : " + xml));
                }
            }
            catch (IOException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Problem WhiteboardObject : " + xml));
                }
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) break block7;
                logger.debug((Object)("Problem WhiteboardObject : " + xml));
            }
        }
    }

    public double getHeight() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public boolean isFill() {
        return this.fill;
    }

    public void setFill(boolean fill) {
        this.fill = fill;
    }

    public WhiteboardPoint getWhiteboardPoint() {
        return this.whiteboardPoint;
    }

    public void setWhiteboardPoint(WhiteboardPoint whiteboardPoint) {
        this.whiteboardPoint = whiteboardPoint;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public void setBackgroundColor(int backColor) {
        this.backColor = backColor;
    }

    public int getBackgroundColor() {
        return this.backColor;
    }

    @Override
    public String toXML() {
        String s = "<rect id=\"#i\" x=\"#x\" y=\"#y\" width=\"#w\" height=\"#h\" fill=\"#f\" stroke=\"#s\" stroke-width=\"#ow\"/>";
        s = s.replaceAll("#i", this.getID());
        s = s.replaceAll("#s", this.colorToHex(this.getColor()));
        s = s.replaceAll("#ow", "" + this.getThickness());
        WhiteboardPoint p = this.getWhiteboardPoint();
        s = s.replaceAll("#x", "" + p.getX());
        s = s.replaceAll("#y", "" + p.getY());
        s = s.replaceAll("#w", "" + this.getWidth());
        s = s.replaceAll("#h", "" + this.getHeight());
        s = s.replaceAll("#f", this.isFill() ? "" + this.getColor() : "none");
        return s;
    }
}

