/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.AbstractCallJabberGTalkImpl;
import net.java.sip.communicator.impl.protocol.jabber.AbstractCallPeerJabberGTalkImpl;
import net.java.sip.communicator.impl.protocol.jabber.CallJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.CallPeerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.JabberActivator;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetBasicTelephonyJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetDesktopStreamingJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.inputevt.InputEvtAction;
import net.java.sip.communicator.impl.protocol.jabber.extensions.inputevt.InputEvtIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.inputevt.RemoteControlExtension;
import net.java.sip.communicator.service.hid.HIDService;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetDesktopSharingServer;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.CallPeerAdapter;
import net.java.sip.communicator.service.protocol.event.CallPeerChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerListener;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.service.protocol.media.MediaAwareCall;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.MediaUseCase;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.format.VideoMediaFormat;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.packet.DiscoverInfo;

public class OperationSetDesktopSharingServerJabberImpl
extends OperationSetDesktopStreamingJabberImpl
implements OperationSetDesktopSharingServer,
RegistrationStateChangeListener,
PacketListener,
PacketFilter {
    private static final Logger logger = Logger.getLogger(OperationSetDesktopSharingServerJabberImpl.class);
    private final CallPeerListener callPeerListener = new CallPeerAdapter(){

        public void peerStateChanged(CallPeerChangeEvent evt) {
            CallPeer peer = evt.getSourceCallPeer();
            CallPeerState state = peer.getState();
            if (state != null && (state.equals(CallPeerState.DISCONNECTED) || state.equals(CallPeerState.FAILED))) {
                OperationSetDesktopSharingServerJabberImpl.this.disableRemoteControl(peer);
            }
        }
    };
    private HIDService hidService = null;
    private List<String> callPeers = new ArrayList<String>();

    public OperationSetDesktopSharingServerJabberImpl(OperationSetBasicTelephonyJabberImpl basicTelephony) {
        super(basicTelephony);
        ((ProtocolProviderServiceJabberImpl)this.parentProvider).addRegistrationStateChangeListener(this);
        this.hidService = JabberActivator.getHIDService();
    }

    @Override
    public Call createVideoCall(String uri, MediaDevice device) throws OperationFailedException, ParseException {
        MediaAwareCall call = (MediaAwareCall)super.createVideoCall(uri, device);
        this.size = ((VideoMediaFormat)call.getDefaultDevice(MediaType.VIDEO).getFormat()).getSize();
        this.origin = OperationSetDesktopSharingServerJabberImpl.getOriginForMediaDevice(device);
        return call;
    }

    @Override
    public Call createVideoCall(Contact callee, MediaDevice device) throws OperationFailedException {
        MediaAwareCall call = (MediaAwareCall)super.createVideoCall(callee, device);
        this.size = ((VideoMediaFormat)call.getDefaultDevice(MediaType.VIDEO).getFormat()).getSize();
        this.origin = OperationSetDesktopSharingServerJabberImpl.getOriginForMediaDevice(device);
        return call;
    }

    @Override
    protected Call createOutgoingVideoCall(String calleeAddress) throws OperationFailedException {
        return this.createOutgoingVideoCall(calleeAddress, null);
    }

    @Override
    protected Call createOutgoingVideoCall(String calleeAddress, MediaDevice videoDevice) throws OperationFailedException {
        boolean supported = false;
        String fullCalleeURI = null;
        fullCalleeURI = calleeAddress.indexOf(47) > 0 ? calleeAddress : ((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection().getRoster().getPresence(calleeAddress).getFrom();
        if (logger.isInfoEnabled()) {
            logger.info((Object)"creating outgoing desktop sharing call...");
        }
        DiscoverInfo di = null;
        try {
            di = ((ProtocolProviderServiceJabberImpl)this.parentProvider).getDiscoveryManager().discoverInfo(fullCalleeURI);
            if (di.containsFeature("http://jitsi.org/protocol/inputevt/sharee")) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)(String.valueOf(fullCalleeURI) + ": remote-control supported"));
                }
                supported = true;
            } else if (logger.isInfoEnabled()) {
                logger.info((Object)(String.valueOf(fullCalleeURI) + ": remote-control not supported!"));
            }
        }
        catch (XMPPException ex) {
            logger.warn((Object)("could not retrieve info for " + fullCalleeURI), (Throwable)ex);
        }
        if (((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection() == null) {
            throw new OperationFailedException("Failed to create OutgoingJingleSession.\nwe don't have a valid XMPPConnection.", 4);
        }
        CallJabberImpl call = new CallJabberImpl((OperationSetBasicTelephonyJabberImpl)this.basicTelephony);
        MediaUseCase useCase = this.getMediaUseCase();
        if (videoDevice != null) {
            call.setVideoDevice(videoDevice, useCase);
        }
        call.setLocalVideoAllowed(true, useCase);
        call.setLocalInputEvtAware(supported);
        ((OperationSetBasicTelephonyJabberImpl)this.basicTelephony).createOutgoingCall(call, calleeAddress);
        new CallPeerJabberImpl(calleeAddress, call);
        return call;
    }

    @Override
    public void setLocalVideoAllowed(Call call, MediaDevice mediaDevice, boolean allowed) throws OperationFailedException {
        ((AbstractCallJabberGTalkImpl)call).setLocalInputEvtAware(allowed);
        super.setLocalVideoAllowed(call, mediaDevice, allowed);
    }

    public void enableRemoteControl(CallPeer callPeer) {
        callPeer.addCallPeerListener(this.callPeerListener);
        this.modifyRemoteControl(callPeer, true);
    }

    public void disableRemoteControl(CallPeer callPeer) {
        this.modifyRemoteControl(callPeer, false);
        callPeer.removeCallPeerListener(this.callPeerListener);
    }

    public void registrationStateChanged(RegistrationStateChangeEvent evt) {
        OperationSetDesktopSharingServerJabberImpl.registrationStateChanged(evt, this, this, (Connection)((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection());
    }

    public static void registrationStateChanged(RegistrationStateChangeEvent evt, PacketListener packetListener, PacketFilter packetFilter, Connection connection) {
        if (connection == null) {
            return;
        }
        if (evt.getNewState() == RegistrationState.REGISTERING) {
            connection.addPacketListener(packetListener, packetFilter);
        } else if (evt.getNewState() == RegistrationState.UNREGISTERING) {
            connection.removePacketListener(packetListener);
        }
    }

    public void processPacket(Packet packet) {
        InputEvtIQ inputIQ = (InputEvtIQ)packet;
        if (inputIQ.getType() == IQ.Type.SET && inputIQ.getAction() == InputEvtAction.NOTIFY) {
            IQ ack = IQ.createResultIQ((IQ)inputIQ);
            ((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection().sendPacket((Packet)ack);
            if (this.callPeers.contains(inputIQ.getFrom())) {
                for (RemoteControlExtension p : inputIQ.getRemoteControls()) {
                    ComponentEvent evt = p.getEvent();
                    this.processComponentEvent(evt);
                }
            }
        }
    }

    public boolean accept(Packet packet) {
        return packet instanceof InputEvtIQ;
    }

    public void processComponentEvent(ComponentEvent event) {
        if (event == null) {
            return;
        }
        if (event instanceof KeyEvent) {
            this.processKeyboardEvent((KeyEvent)event);
        } else if (event instanceof MouseEvent) {
            this.processMouseEvent((MouseEvent)event);
        }
    }

    public void processKeyboardEvent(KeyEvent event) {
        if (this.hidService != null) {
            int keycode = 0;
            if (event.getKeyChar() != '\u0000' && event.getID() == 400) {
                this.hidService.keyPress(event.getKeyChar());
                this.hidService.keyRelease(event.getKeyChar());
                return;
            }
            keycode = event.getKeyCode();
            if (keycode == 0) {
                return;
            }
            switch (event.getID()) {
                case 401: {
                    this.hidService.keyPress(keycode);
                    break;
                }
                case 402: {
                    this.hidService.keyRelease(keycode);
                    break;
                }
            }
        }
    }

    public void processMouseEvent(MouseEvent event) {
        if (this.hidService != null) {
            switch (event.getID()) {
                case 501: {
                    this.hidService.mousePress(event.getModifiers());
                    break;
                }
                case 502: {
                    this.hidService.mouseRelease(event.getModifiers());
                    break;
                }
                case 503: {
                    int originX = this.origin != null ? this.origin.x : 0;
                    int originY = this.origin != null ? this.origin.y : 0;
                    int x = originX + event.getX() * this.size.width / 1000;
                    int y = originY + event.getY() * this.size.height / 1000;
                    this.hidService.mouseMove(x, y);
                    break;
                }
                case 507: {
                    MouseWheelEvent evt = (MouseWheelEvent)event;
                    this.hidService.mouseWheel(evt.getWheelRotation());
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyRemoteControl(CallPeer callPeer, boolean enables) {
        List<String> list = this.callPeers;
        synchronized (list) {
            if (this.callPeers.contains(callPeer.getAddress()) != enables && this.isRemoteControlAvailable(callPeer)) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Enables remote control: " + enables));
                }
                InputEvtIQ inputIQ = new InputEvtIQ();
                if (enables) {
                    inputIQ.setAction(InputEvtAction.START);
                } else {
                    inputIQ.setAction(InputEvtAction.STOP);
                }
                inputIQ.setType(IQ.Type.SET);
                inputIQ.setFrom(((ProtocolProviderServiceJabberImpl)this.parentProvider).getOurJID());
                inputIQ.setTo(callPeer.getAddress());
                XMPPConnection connection = ((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection();
                PacketCollector collector = connection.createPacketCollector((PacketFilter)new PacketIDFilter(inputIQ.getPacketID()));
                connection.sendPacket((Packet)inputIQ);
                Packet p = collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
                if (enables) {
                    this.receivedResponseToIqStart(callPeer, p);
                } else {
                    this.receivedResponseToIqStop(callPeer, p);
                }
                collector.cancel();
            }
        }
    }

    private void receivedResponseToIqStart(CallPeer callPeer, Packet p) {
        if (p != null && ((IQ)p).getType() == IQ.Type.RESULT) {
            this.callPeers.add(callPeer.getAddress());
        } else {
            String packetString = p == null ? "\n\tPacket is null (IQ request timeout)." : "\n\tPacket: " + p.toXML();
            logger.info((Object)("Remote peer has not received/accepted the START action to grant the remote desktop control." + packetString));
        }
    }

    private void receivedResponseToIqStop(CallPeer callPeer, Packet p) {
        if (p == null || ((IQ)p).getType() == IQ.Type.ERROR) {
            String packetString = p == null ? "\n\tPacket is null (IQ request timeout)." : "\n\tPacket: " + p.toXML();
            logger.info((Object)("Remote peer has not received/accepted the STOP action to grant the remote desktop control." + packetString));
        }
        this.callPeers.remove(callPeer.getAddress());
    }

    public boolean isRemoteControlAvailable(CallPeer callPeer) {
        DiscoverInfo discoverInfo = ((AbstractCallPeerJabberGTalkImpl)callPeer).getDiscoveryInfo();
        return ((ProtocolProviderServiceJabberImpl)this.parentProvider).getDiscoveryManager().includesFeature("http://jitsi.org/protocol/inputevt/sharer") && discoverInfo != null && discoverInfo.containsFeature("http://jitsi.org/protocol/inputevt/sharee");
    }
}

