/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.impl;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import net.sf.cindy.Session;
import net.sf.cindy.SessionAdapter;
import net.sf.cindy.SessionListener;
import net.sf.cindy.impl.SocketSession;
import net.sf.jml.Email;
import net.sf.jml.MsnClientId;
import net.sf.jml.MsnConnection;
import net.sf.jml.MsnContact;
import net.sf.jml.MsnContactList;
import net.sf.jml.MsnMessageChain;
import net.sf.jml.MsnMessageIterator;
import net.sf.jml.MsnOwner;
import net.sf.jml.MsnProtocol;
import net.sf.jml.MsnSwitchboard;
import net.sf.jml.event.MsnSwitchboardAdapter;
import net.sf.jml.impl.AbstractMessenger;
import net.sf.jml.impl.MsnConnectionImpl;
import net.sf.jml.impl.MsnContactListImpl;
import net.sf.jml.impl.MsnOwnerImpl;
import net.sf.jml.impl.SimpleSwitchboard;
import net.sf.jml.protocol.MsnMessage;
import net.sf.jml.protocol.MsnOutgoingMessage;
import net.sf.jml.protocol.MsnSession;
import net.sf.jml.protocol.incoming.IncomingXFR;
import net.sf.jml.protocol.outgoing.OutgoingCVR;
import net.sf.jml.protocol.outgoing.OutgoingPNG;
import net.sf.jml.protocol.outgoing.OutgoingUSRInitNS;
import net.sf.jml.protocol.outgoing.OutgoingVER;

public abstract class BasicMessenger
extends AbstractMessenger {
    private final MsnOwnerImpl owner;
    private final MsnContactListImpl contactList;
    private MsnConnectionImpl connection;
    private MsnSession session;
    private Vector preLoginSessionListeners = new Vector();
    private final Set switchboards = new HashSet();

    public BasicMessenger(Email email, String string) {
        this.owner = new MsnOwnerImpl(this, email, string);
        this.contactList = new MsnContactListImpl(this);
    }

    public MsnOwner getOwner() {
        return this.owner;
    }

    public MsnContactList getContactList() {
        return this.contactList;
    }

    public MsnConnection getConnection() {
        return this.connection;
    }

    public void login() {
        this.login("messenger.hotmail.com", 1863);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void logout() {
        if (this.session == null) {
            return;
        }
        MsnSwitchboard[] msnSwitchboardArray = this.getActiveSwitchboards();
        for (int i = 0; i < msnSwitchboardArray.length; ++i) {
            msnSwitchboardArray[i].close();
        }
        Set set = this.switchboards;
        synchronized (set) {
            this.switchboards.clear();
        }
        this.session.close();
    }

    public boolean send(MsnOutgoingMessage msnOutgoingMessage, boolean bl) {
        if (this.session != null) {
            if (bl) {
                return this.session.sendSynchronousMessage(msnOutgoingMessage);
            }
            this.session.sendSynchronousMessage(msnOutgoingMessage);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MsnSwitchboard[] getActiveSwitchboards() {
        Set set = this.switchboards;
        synchronized (set) {
            MsnSwitchboard[] msnSwitchboardArray = new MsnSwitchboard[this.switchboards.size()];
            this.switchboards.toArray(msnSwitchboardArray);
            return msnSwitchboardArray;
        }
    }

    public MsnMessageChain getIncomingMessageChain() {
        if (this.session == null) {
            return null;
        }
        return this.session.getIncomingMessageChain();
    }

    public MsnMessageChain getOutgoingMessageChain() {
        if (this.session == null) {
            return null;
        }
        return this.session.getOutgoingMessageChain();
    }

    public synchronized void login(String string, int n) {
        if (this.session != null && this.session.isAvailable()) {
            return;
        }
        this.connection = new MsnConnectionImpl();
        this.connection.setRemoteIP(string);
        this.connection.setRemotePort(n);
        this.session = new MsnSession(this, (SocketAddress)new InetSocketAddress(string, n));
        this.session.addSessionListener((SessionListener)new MessengerSessionListener());
        int n2 = this.preLoginSessionListeners.size();
        for (int i = 0; i < n2; ++i) {
            this.session.addSessionListener((SessionListener)this.preLoginSessionListeners.get(i));
        }
        this.session.start();
    }

    public void setActualMsnProtocol(MsnProtocol msnProtocol) {
        super.setActualMsnProtocol(msnProtocol);
        this.owner.fSetClientId(MsnClientId.getDefaultSupportedClientId(msnProtocol));
    }

    public void addSessionListener(SessionListener sessionListener) {
        if (this.session != null) {
            this.session.addSessionListener(sessionListener);
        } else {
            this.preLoginSessionListeners.add(sessionListener);
        }
    }

    public String toString() {
        return "MsnMessenger: " + this.owner.getEmail();
    }

    public void sendText(final Email email, final String string) {
        if (email == null || string == null) {
            return;
        }
        MsnSwitchboard[] msnSwitchboardArray = this.getActiveSwitchboards();
        for (int i = 0; i < msnSwitchboardArray.length; ++i) {
            if (!msnSwitchboardArray[i].containContact(email) || msnSwitchboardArray[i].getAllContacts().length != 1) continue;
            msnSwitchboardArray[i].sendText(string);
            return;
        }
        final Object object = new Object();
        this.addSwitchboardListener(new MsnSwitchboardAdapter(){

            public void switchboardStarted(MsnSwitchboard msnSwitchboard) {
                if (msnSwitchboard.getAttachment() == object) {
                    msnSwitchboard.inviteContact(email);
                }
            }

            public void contactJoinSwitchboard(MsnSwitchboard msnSwitchboard, MsnContact msnContact) {
                if (msnSwitchboard.getAttachment() == object && email.equals(msnContact.getEmail())) {
                    msnSwitchboard.setAttachment(null);
                    BasicMessenger.this.removeSwitchboardListener(this);
                    msnSwitchboard.sendText(string);
                }
            }
        });
        this.newSwitchboard(object);
    }

    public MsnSwitchboard newSwitchboard(String string, int n, boolean bl, String string2, int n2, Object object) {
        final SimpleSwitchboard simpleSwitchboard = new SimpleSwitchboard(this, bl, string, n);
        simpleSwitchboard.setAuthStr(string2);
        simpleSwitchboard.addSessionListener((SessionListener)new SessionAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void sessionEstablished(Session session) {
                Set set = BasicMessenger.this.switchboards;
                synchronized (set) {
                    BasicMessenger.this.switchboards.add(simpleSwitchboard);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void sessionClosed(Session session) {
                Set set = BasicMessenger.this.switchboards;
                synchronized (set) {
                    BasicMessenger.this.switchboards.remove(simpleSwitchboard);
                }
            }
        });
        simpleSwitchboard.setSessionId(n2);
        simpleSwitchboard.setAttachment(object);
        simpleSwitchboard.start();
        return simpleSwitchboard;
    }

    private class MessengerSessionListener
    extends SessionAdapter {
        private MessengerSessionListener() {
        }

        public void sessionEstablished(Session session) {
            Socket socket = ((SocketSession)session).getChannel().socket();
            BasicMessenger.this.connection.setInternalIP(socket.getLocalAddress().getHostAddress());
            BasicMessenger.this.connection.setInternalPort(socket.getLocalPort());
            OutgoingVER outgoingVER = new OutgoingVER(null);
            outgoingVER.setSupportedProtocol(BasicMessenger.this.getSupportedProtocol());
            BasicMessenger.this.send(outgoingVER, false);
            OutgoingCVR outgoingCVR = new OutgoingCVR(null);
            outgoingCVR.setEmail(BasicMessenger.this.owner.getEmail());
            BasicMessenger.this.send(outgoingCVR, false);
            OutgoingUSRInitNS outgoingUSRInitNS = new OutgoingUSRInitNS(null);
            outgoingUSRInitNS.setEmail(BasicMessenger.this.owner.getEmail());
            BasicMessenger.this.send(outgoingUSRInitNS, false);
        }

        public void sessionTimeout(Session session) {
            OutgoingPNG outgoingPNG = new OutgoingPNG(BasicMessenger.this.getActualMsnProtocol());
            BasicMessenger.this.send(outgoingPNG, false);
        }

        public void sessionClosed(Session session) {
            MsnMessage msnMessage;
            MsnMessageChain msnMessageChain = ((MsnSession)session.getAttachment()).getIncomingMessageChain();
            MsnMessageIterator msnMessageIterator = msnMessageChain.iterator();
            if (msnMessageIterator.hasPrevious() && (msnMessage = msnMessageIterator.previous()) instanceof IncomingXFR && !((IncomingXFR)msnMessage).isTransferredToSwitchboard()) {
                return;
            }
            BasicMessenger.this.logout();
            BasicMessenger.this.fireLogout();
            BasicMessenger.this.connection = null;
        }
    }
}

