/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.ssi;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ssi.SsiCommand;
import net.kano.joscar.snaccmd.ssi.SsiItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ItemsCmd
extends SsiCommand {
    private final List<SsiItem> items;

    protected ItemsCmd(int command, SnacPacket packet) {
        super(command);
        SsiItem item;
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock block = packet.getData();
        ArrayList<SsiItem> itemList = new ArrayList<SsiItem>();
        while ((item = SsiItem.readSsiItem(block)) != null) {
            itemList.add(item);
            block = block.subBlock(item.getTotalSize());
        }
        this.items = DefensiveTools.getUnmodifiable(itemList);
    }

    protected ItemsCmd(int command, Collection<? extends SsiItem> items) {
        super(command);
        this.items = DefensiveTools.getSafeNonnullListCopy(items, (String)"items");
    }

    public final List<SsiItem> getItems() {
        return this.items;
    }

    @Override
    public void writeData(OutputStream out) throws IOException {
        for (SsiItem item : this.items) {
            item.write(out);
        }
    }

    public String toString() {
        return MiscTools.getClassName(this) + ": " + this.items.size() + " items: " + this.items;
    }
}

