/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.openymsg.network.Session;
import org.openymsg.network.UserStore;
import org.openymsg.network.YMSG9Packet;
import org.openymsg.network.YahooIdentity;
import org.openymsg.network.YahooUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YahooConference {
    protected Set<YahooUser> users;
    protected String room;
    private boolean closed;
    private Queue<YMSG9Packet> packetBuffer;
    private Session parent;
    private YahooIdentity identity;
    private UserStore userStore;

    YahooConference(UserStore userStore, YahooIdentity yahooIdentity, String string, Session session, boolean bl) {
        this.userStore = userStore;
        this.identity = yahooIdentity;
        this.users = new HashSet<YahooUser>();
        this.parent = session;
        this.room = string;
        this.closed = false;
        this.packetBuffer = bl ? new LinkedList<YMSG9Packet>() : null;
    }

    YahooConference(UserStore userStore, YahooIdentity yahooIdentity, String string, Session session) {
        this(userStore, yahooIdentity, string, session, true);
    }

    void closeConference() {
        this.closed = true;
    }

    public String getName() {
        return this.room;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Set<YahooUser> getMembers() {
        return new HashSet<YahooUser>(this.users);
    }

    public YahooIdentity getIdentity() {
        return this.identity;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("name=").append(this.room).append(" users=").append(this.users.size()).append(" id=").append(this.identity.getId()).append(" closed?=").append(this.closed);
        return stringBuffer.toString();
    }

    boolean isInvited() {
        return this.packetBuffer == null;
    }

    Queue<YMSG9Packet> inviteReceived() {
        LinkedList<YMSG9Packet> linkedList = new LinkedList<YMSG9Packet>(this.packetBuffer);
        this.packetBuffer = null;
        return linkedList;
    }

    void addPacket(YMSG9Packet yMSG9Packet) {
        if (this.packetBuffer == null) {
            throw new IllegalStateException("Cannot buffer packets, invite already received");
        }
        this.packetBuffer.add(yMSG9Packet);
    }

    public Set<YahooUser> getUsers() {
        return this.users;
    }

    synchronized void addUsers(String[] stringArray) {
        for (String string : stringArray) {
            this.addUser(string);
        }
    }

    synchronized void addUser(String string) {
        if (!this.exists(string) && !this.parent.isValidYahooID(string)) {
            this.users.add(this.userStore.getOrCreate(string));
        }
    }

    synchronized void removeUser(String string) {
        YahooUser yahooUser = null;
        for (YahooUser yahooUser2 : this.users) {
            if (!yahooUser2.getId().equals(string)) continue;
            yahooUser = yahooUser2;
            break;
        }
        if (yahooUser != null) {
            this.users.remove(yahooUser);
        }
    }

    private boolean exists(String string) {
        for (YahooUser yahooUser : this.users) {
            if (!yahooUser.getId().equals(string)) continue;
            return true;
        }
        return false;
    }
}

