/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.jrobin.core.ArcDef;
import org.jrobin.core.Archive;
import org.jrobin.core.DataImporter;
import org.jrobin.core.Datasource;
import org.jrobin.core.DsDef;
import org.jrobin.core.FetchData;
import org.jrobin.core.FetchRequest;
import org.jrobin.core.Header;
import org.jrobin.core.RrdAllocator;
import org.jrobin.core.RrdBackend;
import org.jrobin.core.RrdBackendFactory;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdFileBackend;
import org.jrobin.core.RrdFileBackendFactory;
import org.jrobin.core.RrdToolReader;
import org.jrobin.core.RrdUpdater;
import org.jrobin.core.Sample;
import org.jrobin.core.Util;
import org.jrobin.core.XmlReader;
import org.jrobin.core.XmlWriter;

public class RrdDb
implements RrdUpdater {
    public static final String PREFIX_XML = "xml:/";
    public static final String PREFIX_RRDTool = "rrdtool:/";
    static final int XML_INITIAL_BUFFER_CAPACITY = 100000;
    private RrdBackend backend;
    private RrdAllocator allocator = new RrdAllocator();
    private Header header;
    private Datasource[] datasources;
    private Archive[] archives;
    private boolean closed = false;

    public RrdDb(RrdDef rrdDef) throws RrdException, IOException {
        this(rrdDef, RrdFileBackendFactory.getDefaultFactory());
    }

    public RrdDb(RrdDef rrdDef, RrdBackendFactory rrdBackendFactory) throws RrdException, IOException {
        rrdDef.validate();
        String string = rrdDef.getPath();
        this.backend = rrdBackendFactory.open(string, false);
        try {
            this.backend.setLength(rrdDef.getEstimatedSize());
            this.header = new Header(this, rrdDef);
            DsDef[] dsDefArray = rrdDef.getDsDefs();
            this.datasources = new Datasource[dsDefArray.length];
            for (int i = 0; i < dsDefArray.length; ++i) {
                this.datasources[i] = new Datasource(this, dsDefArray[i]);
            }
            ArcDef[] arcDefArray = rrdDef.getArcDefs();
            this.archives = new Archive[arcDefArray.length];
            for (int i = 0; i < arcDefArray.length; ++i) {
                this.archives[i] = new Archive(this, arcDefArray[i]);
            }
        }
        catch (IOException iOException) {
            this.backend.close();
            throw iOException;
        }
    }

    public RrdDb(String string, boolean bl) throws IOException, RrdException {
        this(string, bl, RrdBackendFactory.getDefaultFactory());
    }

    public RrdDb(String string, boolean bl, RrdBackendFactory rrdBackendFactory) throws FileNotFoundException, IOException, RrdException {
        if (!rrdBackendFactory.exists(string)) {
            throw new FileNotFoundException("Could not open " + string + " [non existent]");
        }
        this.backend = rrdBackendFactory.open(string, bl);
        try {
            int n;
            this.header = new Header(this, (RrdDef)null);
            this.header.validateHeader();
            int n2 = this.header.getDsCount();
            this.datasources = new Datasource[n2];
            for (n = 0; n < n2; ++n) {
                this.datasources[n] = new Datasource(this, null);
            }
            n = this.header.getArcCount();
            this.archives = new Archive[n];
            for (int i = 0; i < n; ++i) {
                this.archives[i] = new Archive(this, null);
            }
        }
        catch (RrdException rrdException) {
            this.backend.close();
            throw rrdException;
        }
        catch (IOException iOException) {
            this.backend.close();
            throw iOException;
        }
    }

    public RrdDb(String string) throws IOException, RrdException {
        this(string, false);
    }

    public RrdDb(String string, RrdBackendFactory rrdBackendFactory) throws IOException, RrdException {
        this(string, false, rrdBackendFactory);
    }

    public RrdDb(String string, String string2) throws IOException, RrdException {
        this(string, string2, RrdBackendFactory.getDefaultFactory());
    }

    public RrdDb(String string, String string2, RrdBackendFactory rrdBackendFactory) throws IOException, RrdException {
        DataImporter dataImporter;
        if (string2.startsWith(PREFIX_RRDTool)) {
            String string3 = string2.substring(PREFIX_RRDTool.length());
            dataImporter = new RrdToolReader(string3);
        } else if (string2.startsWith(PREFIX_XML)) {
            string2 = string2.substring(PREFIX_XML.length());
            dataImporter = new XmlReader(string2);
        } else {
            dataImporter = new XmlReader(string2);
        }
        this.backend = rrdBackendFactory.open(string, false);
        try {
            int n;
            this.backend.setLength(dataImporter.getEstimatedSize());
            this.header = new Header(this, dataImporter);
            this.datasources = new Datasource[dataImporter.getDsCount()];
            for (n = 0; n < this.datasources.length; ++n) {
                this.datasources[n] = new Datasource(this, dataImporter, n);
            }
            this.archives = new Archive[dataImporter.getArcCount()];
            for (n = 0; n < this.archives.length; ++n) {
                this.archives[n] = new Archive(this, dataImporter, n);
            }
            dataImporter.release();
        }
        catch (RrdException rrdException) {
            this.backend.close();
            throw rrdException;
        }
        catch (IOException iOException) {
            this.backend.close();
            throw iOException;
        }
    }

    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.backend.close();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Header getHeader() {
        return this.header;
    }

    public Datasource getDatasource(int n) {
        return this.datasources[n];
    }

    public Archive getArchive(int n) {
        return this.archives[n];
    }

    public String[] getDsNames() throws IOException {
        int n = this.datasources.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.datasources[i].getDsName();
        }
        return stringArray;
    }

    public Sample createSample(long l) throws IOException {
        return new Sample(this, l);
    }

    public Sample createSample() throws IOException {
        return this.createSample(Util.getTime());
    }

    public FetchRequest createFetchRequest(String string, long l, long l2, long l3) throws RrdException {
        return new FetchRequest(this, string, l, l2, l3);
    }

    public FetchRequest createFetchRequest(String string, long l, long l2) throws RrdException {
        return this.createFetchRequest(string, l, l2, 1L);
    }

    synchronized void store(Sample sample) throws IOException, RrdException {
        if (this.closed) {
            throw new RrdException("RRD already closed, cannot store this  sample");
        }
        long l = sample.getTime();
        long l2 = this.header.getLastUpdateTime();
        if (l2 >= l) {
            throw new RrdException("Bad sample timestamp " + l + ". Last update time was " + l2 + ", at least one second step is required");
        }
        double[] dArray = sample.getValues();
        for (int i = 0; i < this.datasources.length; ++i) {
            double d = dArray[i];
            this.datasources[i].process(l, d);
        }
        this.header.setLastUpdateTime(l);
    }

    synchronized FetchData fetchData(FetchRequest fetchRequest) throws IOException, RrdException {
        if (this.closed) {
            throw new RrdException("RRD already closed, cannot fetch data");
        }
        Archive archive = this.findMatchingArchive(fetchRequest);
        return archive.fetchData(fetchRequest);
    }

    public Archive findMatchingArchive(FetchRequest fetchRequest) throws RrdException, IOException {
        String string = fetchRequest.getConsolFun();
        long l = fetchRequest.getFetchStart();
        long l2 = fetchRequest.getFetchEnd();
        long l3 = fetchRequest.getResolution();
        Archive archive = null;
        Archive archive2 = null;
        long l4 = 0L;
        long l5 = 0L;
        for (Archive archive3 : this.archives) {
            long l6;
            if (!archive3.getConsolFun().equals(string)) continue;
            long l7 = archive3.getArcStep();
            long l8 = archive3.getStartTime() - l7;
            long l9 = archive3.getEndTime();
            long l10 = l2 - l;
            if (l9 >= l2 && l8 <= l) {
                l6 = Math.abs(archive3.getArcStep() - l3);
                if (l6 >= l4 && archive != null) continue;
                l4 = l6;
                archive = archive3;
                continue;
            }
            l6 = l10;
            if (l8 > l) {
                l6 -= l8 - l;
            }
            if (l9 < l2) {
                l6 -= l2 - l9;
            }
            if (archive2 != null && l5 >= l6) continue;
            archive2 = archive3;
            l5 = l6;
        }
        if (archive != null) {
            return archive;
        }
        if (archive2 != null) {
            return archive2;
        }
        throw new RrdException("RRD file does not contain RRA:" + string + " archive");
    }

    public Archive findStartMatchArchive(String string, long l, long l2) throws IOException {
        int n = 0;
        int n2 = -1;
        long l3 = Long.MAX_VALUE;
        long l4 = Long.MAX_VALUE;
        for (int i = 0; i < this.archives.length; ++i) {
            if (!this.archives[i].getConsolFun().equals(string)) continue;
            long l5 = this.archives[i].getArcStep();
            long l6 = Math.abs(l2 - l5);
            if (l >= this.archives[i].getStartTime()) {
                if (l6 == 0L) {
                    return this.archives[i];
                }
                if (l6 >= l3) continue;
                l3 = l6;
                n2 = i;
                continue;
            }
            if (l6 >= l4) continue;
            l4 = l6;
            n = i;
        }
        return n2 >= 0 ? this.archives[n2] : this.archives[n];
    }

    public synchronized String dump() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.header.dump());
        for (Datasource rrdUpdater : this.datasources) {
            stringBuffer.append(rrdUpdater.dump());
        }
        for (RrdUpdater rrdUpdater : this.archives) {
            stringBuffer.append(((Archive)rrdUpdater).dump());
        }
        return stringBuffer.toString();
    }

    void archive(Datasource datasource, double d, long l) throws IOException, RrdException {
        int n = this.getDsIndex(datasource.getDsName());
        for (Archive archive : this.archives) {
            archive.archive(n, d, l);
        }
    }

    public int getDsIndex(String string) throws RrdException, IOException {
        for (int i = 0; i < this.datasources.length; ++i) {
            if (!this.datasources[i].getDsName().equals(string)) continue;
            return i;
        }
        throw new RrdException("Unknown datasource name: " + string);
    }

    public boolean containsDs(String string) throws IOException {
        for (Datasource datasource : this.datasources) {
            if (!datasource.getDsName().equals(string)) continue;
            return true;
        }
        return false;
    }

    Datasource[] getDatasources() {
        return this.datasources;
    }

    Archive[] getArchives() {
        return this.archives;
    }

    public synchronized void dumpXml(OutputStream outputStream) throws IOException {
        XmlWriter xmlWriter = new XmlWriter(outputStream);
        xmlWriter.startTag("rrd");
        this.header.appendXml(xmlWriter);
        for (Datasource rrdUpdater : this.datasources) {
            rrdUpdater.appendXml(xmlWriter);
        }
        for (RrdUpdater rrdUpdater : this.archives) {
            ((Archive)rrdUpdater).appendXml(xmlWriter);
        }
        xmlWriter.closeTag();
        xmlWriter.flush();
    }

    public synchronized void exportXml(OutputStream outputStream) throws IOException {
        this.dumpXml(outputStream);
    }

    public synchronized String getXml() throws IOException, RrdException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(100000);
        this.dumpXml(byteArrayOutputStream);
        return byteArrayOutputStream.toString();
    }

    public synchronized String exportXml() throws IOException, RrdException {
        return this.getXml();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dumpXml(String string) throws IOException, RrdException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string, false);
            this.dumpXml(fileOutputStream);
        }
        finally {
            if (fileOutputStream != null) {
                ((OutputStream)fileOutputStream).close();
            }
        }
    }

    public synchronized void exportXml(String string) throws IOException, RrdException {
        this.dumpXml(string);
    }

    public synchronized long getLastUpdateTime() throws IOException {
        return this.header.getLastUpdateTime();
    }

    public synchronized RrdDef getRrdDef() throws RrdException, IOException {
        Object object;
        long l = this.header.getLastUpdateTime();
        long l2 = this.header.getStep();
        String string = this.backend.getPath();
        RrdDef rrdDef = new RrdDef(string, l, l2);
        for (Datasource rrdUpdater : this.datasources) {
            object = new DsDef(rrdUpdater.getDsName(), rrdUpdater.getDsType(), rrdUpdater.getHeartbeat(), rrdUpdater.getMinValue(), rrdUpdater.getMaxValue());
            rrdDef.addDatasource((DsDef)object);
        }
        for (RrdUpdater rrdUpdater : this.archives) {
            object = new ArcDef(((Archive)rrdUpdater).getConsolFun(), ((Archive)rrdUpdater).getXff(), ((Archive)rrdUpdater).getSteps(), ((Archive)rrdUpdater).getRows());
            rrdDef.addArchive((ArcDef)object);
        }
        return rrdDef;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public synchronized void copyStateTo(RrdUpdater rrdUpdater) throws IOException, RrdException {
        int n;
        int n2;
        if (!(rrdUpdater instanceof RrdDb)) {
            throw new RrdException("Cannot copy RrdDb object to " + rrdUpdater.getClass().getName());
        }
        RrdDb rrdDb = (RrdDb)rrdUpdater;
        this.header.copyStateTo(rrdDb.header);
        for (n2 = 0; n2 < this.datasources.length; ++n2) {
            n = Util.getMatchingDatasourceIndex(this, n2, rrdDb);
            if (n < 0) continue;
            this.datasources[n2].copyStateTo(rrdDb.datasources[n]);
        }
        for (n2 = 0; n2 < this.archives.length; ++n2) {
            n = Util.getMatchingArchiveIndex(this, n2, rrdDb);
            if (n < 0) continue;
            this.archives[n2].copyStateTo(rrdDb.archives[n]);
        }
    }

    public Datasource getDatasource(String string) throws IOException {
        try {
            return this.getDatasource(this.getDsIndex(string));
        }
        catch (RrdException rrdException) {
            return null;
        }
    }

    public int getArcIndex(String string, int n) throws RrdException, IOException {
        for (int i = 0; i < this.archives.length; ++i) {
            if (!this.archives[i].getConsolFun().equals(string) || this.archives[i].getSteps() != n) continue;
            return i;
        }
        throw new RrdException("Could not find archive " + string + "/" + n);
    }

    public Archive getArchive(String string, int n) throws IOException {
        try {
            return this.getArchive(this.getArcIndex(string, n));
        }
        catch (RrdException rrdException) {
            return null;
        }
    }

    public String getCanonicalPath() throws IOException {
        if (this.backend instanceof RrdFileBackend) {
            return ((RrdFileBackend)this.backend).getCanonicalPath();
        }
        throw new IOException("The underlying backend has no canonical path");
    }

    public String getPath() {
        return this.backend.getPath();
    }

    public RrdBackend getRrdBackend() {
        return this.backend;
    }

    public RrdAllocator getRrdAllocator() {
        return this.allocator;
    }

    public synchronized byte[] getBytes() throws IOException {
        return this.backend.readAll();
    }

    public static void setDefaultFactory(String string) throws RrdException {
        RrdBackendFactory.setDefaultFactory(string);
    }

    public synchronized double[] getLastDatasourceValues() throws IOException {
        double[] dArray = new double[this.datasources.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.datasources[i].getLastValue();
        }
        return dArray;
    }

    public synchronized double getLastDatasourceValue(String string) throws IOException, RrdException {
        int n = this.getDsIndex(string);
        return this.datasources[n].getLastValue();
    }

    public int getDsCount() {
        return this.datasources.length;
    }

    public int getArcCount() {
        return this.archives.length;
    }

    public long getLastArchiveUpdateTime() throws IOException {
        long l = 0L;
        for (Archive archive : this.archives) {
            l = Math.max(l, archive.getEndTime());
        }
        return l;
    }

    public synchronized String getInfo() throws IOException {
        return this.header.getInfo();
    }

    public synchronized void setInfo(String string) throws IOException {
        this.header.setInfo(string);
    }

    public static void main(String[] stringArray) {
        System.out.println("JRobin Java Library :: RRDTool choice for the Java world");
        System.out.println("==================================================================");
        System.out.println("JRobin base directory: " + Util.getJRobinHomeDirectory());
        long l = Util.getTime();
        System.out.println("Current timestamp: " + l + ": " + new Date(l * 1000L));
        System.out.println("------------------------------------------------------------------");
        System.out.println("For the latest information visit: http://www.jrobin.org");
        System.out.println("(C) 2003-2005 Sasa Markovic. All rights reserved.");
    }
}

