/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.macos;

import com.install4j.runtime.installer.Installer;
import com.install4j.runtime.installer.config.AssociationConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.ServiceConfig;
import com.install4j.runtime.installer.fileinst.FileInstaller;
import com.install4j.runtime.installer.frontend.InstallerFrontend;
import com.install4j.runtime.installer.platform.unix.SudoExecution;
import com.install4j.runtime.installer.platform.unix.UnixFileSystem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.StringTokenizer;

public class MacosSpecificInstaller {
    private static final File STARTUP_ITEMS_FILE = new File("/Library/StartupItems");
    private static final String STARTUP_PARAMETERS_PLIST_NAME = "StartupParameters.plist";

    private static void installStartupItem(File file, File file2, String string, String string2) throws IOException {
        if (!file2.exists()) {
            return;
        }
        File file3 = new File(Installer.getRuntimeDir(file), string);
        file3.mkdirs();
        File file4 = new File(file3, string);
        PrintWriter printWriter = new PrintWriter(new FileWriter(file4));
        printWriter.println("#! /bin/sh");
        printWriter.println(file2.getAbsolutePath() + " $@");
        printWriter.close();
        UnixFileSystem.setMode(493, file4);
        File file5 = new File(file3, STARTUP_PARAMETERS_PLIST_NAME);
        printWriter = new PrintWriter(new FileWriter(file5));
        printWriter.println("{");
        printWriter.println("  Description     = \"" + string + "\";");
        printWriter.println("  Provides        = (\"" + string + "\");");
        printWriter.println("  Requires        = (" + MacosSpecificInstaller.formatRequires(string2) + ");");
        printWriter.println("  OrderPreference = \"Late\";");
        printWriter.println("}");
        printWriter.close();
        File file6 = new File(STARTUP_ITEMS_FILE, string);
        try {
            Process process = SudoExecution.execute(new String[]{"mkdir", STARTUP_ITEMS_FILE.getAbsolutePath()});
            process.waitFor();
            process = SudoExecution.execute(new String[]{"rm", "-R", file6.getAbsolutePath()});
            process.waitFor();
            process = SudoExecution.execute(new String[]{"mv", file3.getAbsolutePath(), file6.getAbsolutePath()});
            process.waitFor();
            process = SudoExecution.execute(new String[]{"chown", "-R", "root:wheel", file6.getAbsolutePath()});
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static String formatRequires(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append("\"");
            stringBuffer.append(stringTokenizer.nextToken().trim());
            stringBuffer.append("\"");
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public static void installService(File file, ServiceConfig serviceConfig) throws IOException {
        File file2 = new File(file, serviceConfig.getFile());
        if (!file2.exists()) {
            return;
        }
        MacosSpecificInstaller.installStartupItem(file, file2, serviceConfig.getName(), serviceConfig.getDependencies());
        Runtime.getRuntime().exec(new String[]{"/bin/sh", file2.getAbsolutePath(), "start"});
    }

    public static void uninstallService(File file, ServiceConfig serviceConfig) throws IOException {
        File file2 = new File(file, serviceConfig.getFile());
        if (!file2.exists()) {
            return;
        }
        Process process = Runtime.getRuntime().exec(new String[]{"/bin/sh", file2.getAbsolutePath(), "stop"});
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        if (serviceConfig.getName().trim().length() > 0) {
            File file3 = new File(STARTUP_ITEMS_FILE, serviceConfig.getName());
            SudoExecution.execute(new String[]{"rm", "-R", file3.getAbsolutePath()});
        }
    }

    public static void doInstallation(File file, Installer installer) throws IOException {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        Iterator iterator = installerConfig.getAssociations().iterator();
        while (iterator.hasNext()) {
            AssociationConfig associationConfig = (AssociationConfig)iterator.next();
            if (!associationConfig.isSelected()) continue;
            String string = associationConfig.getExtension();
            File file2 = installerConfig.getMacSpecificConfig().isSingleBundle() ? new File(file, installerConfig.getApplicationName() + ".app/Contents/" + "Info.plist") : new File(file, associationConfig.getLauncherExecutable() + "/Contents/" + "Info.plist");
            if (!file2.exists()) continue;
            MacosSpecificInstaller.addAssociation(file2, string, associationConfig.getDescription(), associationConfig.getMacIcon());
        }
        MacosSpecificInstaller.createAdditionalIcons(file, installer);
    }

    private static void createAdditionalIcons(File file, Installer installer) throws IOException {
        InstallerFrontend installerFrontend = installer.getInstallerFrontend();
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        String string = installerConfig.getDesktopExecutable();
        if (!string.trim().equals("")) {
            File file2 = new File(file, string);
            if (installerFrontend.isCreateDesktopIcon()) {
                File file3 = new File(new File(System.getProperty("user.home"), "Desktop"), installerConfig.getApplicationName());
                UnixFileSystem.createLink(file2.getAbsolutePath(), file3);
                FileInstaller.getInstance().registerUninstallFile(file3);
            }
        }
    }

    private static void addAssociation(File file, String string, String string2, String string3) throws IOException {
        File file2 = new File(file.getAbsolutePath() + ".temp");
        file2.delete();
        file.renameTo(file2);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        String string4 = bufferedReader.readLine();
        while (string4 != null) {
            printWriter.println(string4);
            if (string4.trim().equals("<!-- I4J_INSERT_DOCTYPE -->")) {
                MacosSpecificInstaller.insertAssociation(printWriter, string, string2, string3);
            }
            string4 = bufferedReader.readLine();
        }
        printWriter.close();
        bufferedReader.close();
        file2.delete();
    }

    private static void insertAssociation(PrintWriter printWriter, String string, String string2, String string3) {
        printWriter.println("<dict>");
        printWriter.println("<key>CFBundleTypeExtensions</key>");
        printWriter.println("<array>");
        printWriter.println("<string>" + string + "</string>");
        printWriter.println("</array>");
        printWriter.println("<key>CFBundleTypeName</key>");
        printWriter.println("<string>" + string2 + "</string>");
        if (string3.length() > 0) {
            printWriter.println("<key>CFBundleTypeIconFile</key>");
            printWriter.println("<string>" + string3 + "</string>");
        }
        printWriter.println("<key>CFBundleTypeRole</key>");
        printWriter.println("<string>Viewer</string>");
        printWriter.println("</dict>");
    }
}

