/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.runtime.installer.Uninstaller;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.screens.UninstallFailureScreen;
import com.install4j.runtime.installer.frontend.screens.UninstallationScreen;
import com.install4j.runtime.wizard.WizardBase;
import java.text.MessageFormat;
import javax.swing.ImageIcon;

public class UninstallerWizard
extends WizardBase {
    private static final ImageIcon ICON_FRAME = GUIHelper.loadIcon("install4j_icon.png");
    private static final int FRAME_WIDTH = 500;
    private static final int FRAME_HEIGHT = 390;
    private Uninstaller uninstaller;
    private UninstallationScreen uninstallationScreen;
    private UninstallFailureScreen uninstallFailureScreen;
    private boolean success = false;

    public UninstallerWizard(Uninstaller uninstaller) {
        super("");
        this.uninstaller = uninstaller;
        GUIHelper.setSystemLaF();
        String string = MessageFormat.format(Messages.getMessages().getString("UninstallAppFullTitle"), InstallerConfig.getCurrentInstance().getApplicationNameWithVersion());
        this.setTitle(string);
        this.setupScreens();
    }

    public UninstallationScreen getUninstallationScreen() {
        return this.uninstallationScreen;
    }

    public UninstallFailureScreen getUninstallFailureScreen() {
        return this.uninstallFailureScreen;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean bl) {
        this.success = bl;
    }

    public Uninstaller getUninstaller() {
        return this.uninstaller;
    }

    public void showFrame() {
        super.showFrame(null, ICON_FRAME);
    }

    protected int getFrameWidth() {
        return 500;
    }

    protected int getFrameHeight() {
        return 390;
    }

    protected boolean isQuitOnWindowClose() {
        return false;
    }

    protected void setupScreens() {
        this.uninstallationScreen = new UninstallationScreen(this);
        this.uninstallFailureScreen = new UninstallFailureScreen(this);
        this.registerScreen(this.uninstallationScreen);
        this.registerScreen(this.uninstallFailureScreen);
    }

    protected void afterHide() {
        if (this.isSuccess() && !Uninstaller.checkReboot()) {
            this.showDone(InstallerConfig.getCurrentInstance().getApplicationNameWithVersion());
        }
        System.exit(0);
    }

    private void showDone(String string) {
        String string2 = MessageFormat.format(Messages.getMessages().getString("UninstalledAll"), string);
        GUIHelper.showMessage(null, string2, 1);
    }
}

