/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.screens;

import com.install4j.api.CustomScreen;
import com.install4j.runtime.installer.frontend.InstallerScreen;
import com.install4j.runtime.installer.frontend.InstallerWizard;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import javax.swing.JPanel;

public class CustomScreenAdapter
extends InstallerScreen {
    private CustomScreen screen;

    public CustomScreenAdapter(InstallerWizard installerWizard, CustomScreen customScreen) {
        super(installerWizard);
        this.screen = customScreen;
        this.initScreen();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.btnPrevious) {
            if (!this.screen.previous()) {
                return;
            }
        } else if (object == this.btnForward) {
            if (!this.screen.next()) {
                return;
            }
            if (this.screen.isFinishScreen()) {
                this.getInstallerWizard().finish();
                return;
            }
        } else if (object == this.btnCancel && !this.screen.cancel()) {
            return;
        }
        super.actionPerformed(actionEvent);
    }

    protected boolean supportsPrevious() {
        return this.screen.showOnPrevious();
    }

    protected boolean supportsNext() {
        return this.screen.showOnNext();
    }

    public void activate() {
        super.activate();
        this.screen.activated();
    }

    public void deactivate() {
        super.deactivate();
        this.screen.deactivated();
    }

    protected void addScreenContent(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        if (this.screen.isFillHorizontal()) {
            gridBagConstraints.fill = 2;
        }
        if (this.screen.isFillVertical()) {
            gridBagConstraints.fill = 3;
        }
        if (this.screen.isFillHorizontal() && this.screen.isFillVertical()) {
            gridBagConstraints.fill = 1;
        }
        jPanel.add((Component)this.screen, gridBagConstraints);
        this.btnPrevious.setVisible(this.screen.isPreviousVisible());
        this.btnForward.setVisible(this.screen.isNextVisible() || this.screen.isFinishScreen());
        this.btnCancel.setVisible(this.screen.isCancelVisible());
        if (this.screen.isFinishScreen()) {
            this.btnForward.setText(this.messages.getString("ButtonFinish"));
        }
    }

    protected String getTitle() {
        return this.screen.getTitle();
    }

    protected String getSubTitle() {
        return this.screen.getSubTitle();
    }

    protected boolean needsSpacer() {
        return !this.screen.isFillVertical();
    }
}

