/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pl.mn.communicator.GGException;
import pl.mn.communicator.GGToken;
import pl.mn.communicator.IRegistrationService;
import pl.mn.communicator.Session;
import pl.mn.communicator.packet.http.ChangePasswordRequest;
import pl.mn.communicator.packet.http.CommonRegisterResponse;
import pl.mn.communicator.packet.http.GGTokenRequest;
import pl.mn.communicator.packet.http.HttpRequest;
import pl.mn.communicator.packet.http.HttpResponse;
import pl.mn.communicator.packet.http.RegisterGGAccountRequest;
import pl.mn.communicator.packet.http.SendAndRemindPasswordRequest;
import pl.mn.communicator.packet.http.UnregisterGGPasswordRequest;

public class DefaultRegistrationService
implements IRegistrationService {
    private static final String WINDOW_ENCODING = "windows-1250";
    private static final Log LOGGER = LogFactory.getLog((Class)DefaultRegistrationService.class);
    private Session m_session = null;

    public DefaultRegistrationService(Session session) {
        if (session == null) {
            throw new NullPointerException("session cannot be null");
        }
        this.m_session = session;
    }

    public GGToken getRegistrationToken() throws GGException {
        HttpRequest tokenRequest = null;
        try {
            tokenRequest = new GGTokenRequest(this.m_session.getGGConfiguration());
            tokenRequest.connect();
            GGTokenRequest.GGTokenResponse response = (GGTokenRequest.GGTokenResponse)((GGTokenRequest)tokenRequest).getResponse();
            if (!response.isOKResponse()) {
                throw new GGException("Error occured while requesting Gadu-Gadu token, reason: " + response.getResponseMessage());
            }
            GGToken gGToken = response.getGGToken();
            return gGToken;
        }
        catch (IOException ex) {
            throw new GGException("Unable to get token", ex);
        }
        finally {
            if (tokenRequest != null) {
                tokenRequest.disconnect();
            }
        }
    }

    public void changePassword(int uin, String email, String oldPassword, String newPassword, String tokenID, String tokenVal) throws GGException {
        if (uin < 0) {
            throw new IllegalArgumentException("uin cannot be less than 0");
        }
        if (email == null) {
            throw new NullPointerException("email cannot be null");
        }
        if (oldPassword == null) {
            throw new NullPointerException("oldPassword cannot be null");
        }
        if (newPassword == null) {
            throw new NullPointerException("newPassword cannot be null");
        }
        if (tokenID == null) {
            throw new NullPointerException("tokenID cannot be null");
        }
        if (tokenVal == null) {
            throw new NullPointerException("tokenVal cannot be null");
        }
        HttpRequest changePasswordRequest = null;
        try {
            changePasswordRequest = new ChangePasswordRequest(this.m_session.getGGConfiguration(), uin, email, oldPassword, newPassword, tokenID, tokenVal);
            changePasswordRequest.connect();
            changePasswordRequest.sendRequest();
            CommonRegisterResponse response = (CommonRegisterResponse)((ChangePasswordRequest)changePasswordRequest).getResponse();
            if (!response.isOKResponse()) {
                throw new GGException("Error occured while trying to change Gadu-Gadu password, reason: " + response.getResponseMessage());
            }
        }
        catch (IOException ex) {
            throw new GGException("Unable to change Gadu-Gadu password", ex);
        }
        finally {
            if (changePasswordRequest != null) {
                changePasswordRequest.disconnect();
            }
        }
    }

    public int registerAccount(String email, String password, String tokenID, String tokenVal) throws GGException {
        if (email == null) {
            throw new NullPointerException("email cannot be null");
        }
        if (password == null) {
            throw new NullPointerException("password cannot be null");
        }
        if (tokenID == null) {
            throw new NullPointerException("password cannot be null");
        }
        if (tokenVal == null) {
            throw new NullPointerException("password cannot be null");
        }
        HttpRequest request = null;
        try {
            request = new RegisterGGAccountRequest(this.m_session.getGGConfiguration(), email, password, tokenID, tokenVal);
            request.connect();
            request.sendRequest();
            RegisterGGAccountRequest.RegisterGGAccountResponse response = (RegisterGGAccountRequest.RegisterGGAccountResponse)((RegisterGGAccountRequest)request).getResponse();
            if (!response.isOKResponse()) {
                throw new GGException("Error occured while requesting to send password, reason: " + response.getResponseMessage());
            }
            int n = response.getNewUin();
            return n;
        }
        catch (IOException ex) {
            throw new GGException("Unable to remind and send password", ex);
        }
        finally {
            if (request != null) {
                request.disconnect();
            }
        }
    }

    public void unregisterAccount(int uin, String password, String tokenID, String tokenVal) throws GGException {
        if (uin < 0) {
            throw new IllegalArgumentException("uin cannot be less than 0");
        }
        if (password == null) {
            throw new NullPointerException("password cannot be null");
        }
        if (tokenID == null) {
            throw new NullPointerException("tokenID cannot be null");
        }
        if (tokenVal == null) {
            throw new NullPointerException("tokenVal cannot be null");
        }
        HttpRequest unregisterGGPasswordRequest = null;
        try {
            unregisterGGPasswordRequest = new UnregisterGGPasswordRequest(this.m_session.getGGConfiguration(), uin, password, tokenID, tokenVal);
            unregisterGGPasswordRequest.connect();
            unregisterGGPasswordRequest.sendRequest();
            CommonRegisterResponse response = (CommonRegisterResponse)((UnregisterGGPasswordRequest)unregisterGGPasswordRequest).getResponse();
            if (!response.isOKResponse()) {
                throw new GGException("Error occured while trying to unregister Gadu-Gadu account, reason: " + response.getResponseMessage());
            }
        }
        catch (IOException ex) {
            throw new GGException("Unable to unregister account", ex);
        }
        finally {
            if (unregisterGGPasswordRequest != null) {
                unregisterGGPasswordRequest.disconnect();
            }
        }
    }

    public void sendPassword(int uin, String email, String tokenID, String tokenVal) throws GGException {
        if (uin < 0) {
            throw new IllegalArgumentException("uin cannot be less than 0");
        }
        if (email == null) {
            throw new NullPointerException("email cannot be null");
        }
        if (tokenID == null) {
            throw new NullPointerException("tokenID cannot be null");
        }
        if (tokenVal == null) {
            throw new NullPointerException("tokenVal cannot be null");
        }
        HttpRequest request = null;
        try {
            request = new SendAndRemindPasswordRequest(this.m_session.getGGConfiguration(), uin, email, tokenID, tokenVal);
            request.connect();
            request.sendRequest();
            HttpResponse response = ((SendAndRemindPasswordRequest)request).getResponse();
            if (!response.isOKResponse()) {
                throw new GGException("Error occured while requesting to send password, response: " + response.getResponseMessage());
            }
        }
        catch (IOException ex) {
            throw new GGException("Unable to remind and send password", ex);
        }
        finally {
            if (request != null) {
                request.disconnect();
            }
        }
    }
}

