/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Socks5Proxy {
    private static Socks5Proxy socks5Server;
    private Socks5ServerProcess serverProcess;
    private Thread serverThread;
    private ServerSocket serverSocket;
    private final Map<String, Socket> connectionMap = new ConcurrentHashMap<String, Socket>();
    private final List<String> allowedConnections = Collections.synchronizedList(new LinkedList());
    private final Set<String> localAddresses = Collections.synchronizedSet(new LinkedHashSet());

    private Socks5Proxy() {
        this.serverProcess = new Socks5ServerProcess();
        try {
            this.localAddresses.add(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public static synchronized Socks5Proxy getSocks5Proxy() {
        if (socks5Server == null) {
            socks5Server = new Socks5Proxy();
        }
        if (SmackConfiguration.isLocalSocks5ProxyEnabled()) {
            socks5Server.start();
        }
        return socks5Server;
    }

    public synchronized void start() {
        if (this.isRunning()) {
            return;
        }
        try {
            if (SmackConfiguration.getLocalSocks5ProxyPort() < 0) {
                int port = Math.abs(SmackConfiguration.getLocalSocks5ProxyPort());
                for (int i = 0; i < 65535 - port; ++i) {
                    try {
                        this.serverSocket = new ServerSocket(port + i);
                        break;
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                }
            } else {
                this.serverSocket = new ServerSocket(SmackConfiguration.getLocalSocks5ProxyPort());
            }
            if (this.serverSocket != null) {
                this.serverThread = new Thread(this.serverProcess);
                this.serverThread.start();
            }
        }
        catch (IOException e) {
            System.err.println("couldn't setup local SOCKS5 proxy on port " + SmackConfiguration.getLocalSocks5ProxyPort() + ": " + e.getMessage());
        }
    }

    public synchronized void stop() {
        if (!this.isRunning()) {
            return;
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (this.serverThread != null && this.serverThread.isAlive()) {
            try {
                this.serverThread.interrupt();
                this.serverThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.serverThread = null;
        this.serverSocket = null;
    }

    public void addLocalAddress(String address) {
        if (address == null) {
            throw new IllegalArgumentException("address may not be null");
        }
        this.localAddresses.add(address);
    }

    public void removeLocalAddress(String address) {
        this.localAddresses.remove(address);
    }

    public List<String> getLocalAddresses() {
        return Collections.unmodifiableList(new ArrayList<String>(this.localAddresses));
    }

    public void replaceLocalAddresses(List<String> addresses) {
        if (addresses == null) {
            throw new IllegalArgumentException("list must not be null");
        }
        this.localAddresses.clear();
        this.localAddresses.addAll(addresses);
    }

    public int getPort() {
        if (!this.isRunning()) {
            return -1;
        }
        return this.serverSocket.getLocalPort();
    }

    protected Socket getSocket(String digest) {
        return this.connectionMap.get(digest);
    }

    protected void addTransfer(String digest) {
        this.allowedConnections.add(digest);
    }

    protected void removeTransfer(String digest) {
        this.allowedConnections.remove(digest);
        this.connectionMap.remove(digest);
    }

    public boolean isRunning() {
        return this.serverSocket != null;
    }

    private class Socks5ServerProcess
    implements Runnable {
        private Socks5ServerProcess() {
        }

        public void run() {
            while (true) {
                Socket socket = null;
                try {
                    if (Socks5Proxy.this.serverSocket.isClosed() || Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    socket = Socks5Proxy.this.serverSocket.accept();
                    this.establishConnection(socket);
                    continue;
                }
                catch (SocketException e) {
                    continue;
                }
                catch (Exception e) {
                    try {
                        if (socket == null) continue;
                        socket.close();
                    }
                    catch (IOException iOException) {
                    }
                    continue;
                }
                break;
            }
        }

        private void establishConnection(Socket socket) throws XMPPException, IOException {
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            DataInputStream in = new DataInputStream(socket.getInputStream());
            int b = in.read();
            if (b != 5) {
                throw new XMPPException("Only SOCKS5 supported");
            }
            b = in.read();
            byte[] auth = new byte[b];
            in.readFully(auth);
            byte[] authMethodSelectionResponse = new byte[2];
            authMethodSelectionResponse[0] = 5;
            boolean noAuthMethodFound = false;
            for (int i = 0; i < auth.length; ++i) {
                if (auth[i] != 0) continue;
                noAuthMethodFound = true;
                break;
            }
            if (!noAuthMethodFound) {
                authMethodSelectionResponse[1] = -1;
                out.write(authMethodSelectionResponse);
                out.flush();
                throw new XMPPException("Authentication method not supported");
            }
            authMethodSelectionResponse[1] = 0;
            out.write(authMethodSelectionResponse);
            out.flush();
            byte[] connectionRequest = Socks5Utils.receiveSocks5Message(in);
            String responseDigest = new String(connectionRequest, 5, (int)connectionRequest[4]);
            if (!Socks5Proxy.this.allowedConnections.contains(responseDigest)) {
                connectionRequest[1] = 5;
                out.write(connectionRequest);
                out.flush();
                throw new XMPPException("Connection is not allowed");
            }
            connectionRequest[1] = 0;
            out.write(connectionRequest);
            out.flush();
            Socks5Proxy.this.connectionMap.put(responseDigest, socket);
        }
    }
}

