/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.cmd;

import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import org.jrobin.cmd.ColonSplitter;
import org.jrobin.cmd.RrdToolCmd;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphConstants;
import org.jrobin.graph.RrdGraphDef;
import org.jrobin.graph.RrdGraphInfo;

class RrdGraphCmd
extends RrdToolCmd
implements RrdGraphConstants {
    static final Color BLIND_COLOR = new Color(0, 0, 0, 0);
    private RrdGraphDef gdef;

    RrdGraphCmd() {
    }

    String getCmdType() {
        return "graph";
    }

    Object execute() throws RrdException, IOException {
        String[] stringArray;
        this.gdef = new RrdGraphDef();
        String string = this.getOptionValue("s", "start", "end-1d");
        String string2 = this.getOptionValue("e", "end", "now");
        this.gdef.setTimeSpan(Util.getTimestamps(string, string2));
        this.parseXGrid(this.getOptionValue("x", "x-grid"));
        this.parseYGrid(this.getOptionValue("y", "y-grid"));
        this.gdef.setAltYGrid(this.getBooleanOption("Y", "alt-y-grid"));
        this.gdef.setNoMinorGrid(this.getBooleanOption(null, "no-minor"));
        this.gdef.setAltYMrtg(this.getBooleanOption("R", "alt-y-mrtg"));
        this.gdef.setAltAutoscale(this.getBooleanOption("A", "alt-autoscale"));
        this.gdef.setAltAutoscaleMax(this.getBooleanOption("M", "alt-autoscale-max"));
        String string3 = this.getOptionValue("X", "units-exponent");
        if (string3 != null) {
            this.gdef.setUnitsExponent(RrdGraphCmd.parseInt(string3));
        }
        if ((string3 = this.getOptionValue("L", "units-length")) != null) {
            this.gdef.setUnitsLength(RrdGraphCmd.parseInt(string3));
        }
        if ((string3 = this.getOptionValue("v", "vertical-label")) != null) {
            this.gdef.setVerticalLabel(string3);
        }
        if ((string3 = this.getOptionValue("w", "width")) != null) {
            this.gdef.setWidth(RrdGraphCmd.parseInt(string3));
        }
        if ((string3 = this.getOptionValue("h", "height")) != null) {
            this.gdef.setHeight(RrdGraphCmd.parseInt(string3));
        }
        this.gdef.setInterlaced(this.getBooleanOption("i", "interlaced"));
        string3 = this.getOptionValue("f", "imginfo");
        if (string3 != null) {
            this.gdef.setImageInfo(string3);
        }
        if ((string3 = this.getOptionValue("a", "imgformat")) != null) {
            this.gdef.setImageFormat(string3);
        }
        if ((string3 = this.getOptionValue("B", "background")) != null) {
            this.gdef.setBackgroundImage(string3);
        }
        if ((string3 = this.getOptionValue("O", "overlay")) != null) {
            this.gdef.setOverlayImage(string3);
        }
        if ((string3 = this.getOptionValue("U", "unit")) != null) {
            this.gdef.setUnit(string3);
        }
        this.gdef.setLazy(this.getBooleanOption("z", "lazy"));
        string3 = this.getOptionValue("u", "upper-limit");
        if (string3 != null) {
            this.gdef.setMaxValue(RrdGraphCmd.parseDouble(string3));
        }
        if ((string3 = this.getOptionValue("l", "lower-limit")) != null) {
            this.gdef.setMinValue(RrdGraphCmd.parseDouble(string3));
        }
        this.gdef.setRigid(this.getBooleanOption("r", "rigid"));
        string3 = this.getOptionValue("b", "base");
        if (string3 != null) {
            this.gdef.setBase(RrdGraphCmd.parseDouble(string3));
        }
        this.gdef.setLogarithmic(this.getBooleanOption("o", "logarithmic"));
        this.parseColors(this.getMultipleOptionValues("c", "color"));
        this.gdef.setNoLegend(this.getBooleanOption("g", "no-legend"));
        this.gdef.setOnlyGraph(this.getBooleanOption("j", "only-graph"));
        this.gdef.setForceRulesLegend(this.getBooleanOption("F", "force-rules-legend"));
        string3 = this.getOptionValue("t", "title");
        if (string3 != null) {
            this.gdef.setTitle(string3);
        }
        if ((string3 = this.getOptionValue("S", "step")) != null) {
            this.gdef.setStep(RrdGraphCmd.parseLong(string3));
        }
        if ((stringArray = this.getRemainingWords()).length < 2) {
            throw new RrdException("Image filename must be specified");
        }
        this.gdef.setFilename(stringArray[1]);
        for (int i = 2; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("DEF:")) {
                this.parseDef(stringArray[i]);
                continue;
            }
            if (stringArray[i].startsWith("CDEF:")) {
                this.parseCDef(stringArray[i]);
                continue;
            }
            if (stringArray[i].startsWith("PRINT:")) {
                this.parsePrint(stringArray[i]);
                continue;
            }
            if (stringArray[i].startsWith("GPRINT:")) {
                this.parseGPrint(stringArray[i]);
                continue;
            }
            if (stringArray[i].startsWith("COMMENT:")) {
                this.parseComment(stringArray[i]);
                continue;
            }
            if (stringArray[i].startsWith("HRULE:")) {
                this.parseHRule(stringArray[i]);
                continue;
            }
            if (stringArray[i].startsWith("VRULE:")) {
                this.parseVRule(stringArray[i]);
                continue;
            }
            if (stringArray[i].startsWith("LINE1:") || stringArray[i].startsWith("LINE2:") || stringArray[i].startsWith("LINE3:")) {
                this.parseLine(stringArray[i]);
                continue;
            }
            if (stringArray[i].startsWith("AREA:")) {
                this.parseArea(stringArray[i]);
                continue;
            }
            if (stringArray[i].startsWith("STACK:")) {
                this.parseStack(stringArray[i]);
                continue;
            }
            throw new RrdException("Unexpected GRAPH token encountered: " + stringArray[i]);
        }
        RrdGraphInfo rrdGraphInfo = new RrdGraph(this.gdef).getRrdGraphInfo();
        if (rrdGraphInfo.getFilename().equals("-")) {
            RrdGraphCmd.println(new String(rrdGraphInfo.getBytes()));
        } else {
            String[] stringArray2;
            RrdGraphCmd.println(rrdGraphInfo.getWidth() + "x" + rrdGraphInfo.getHeight());
            for (String string4 : stringArray2 = rrdGraphInfo.getPrintLines()) {
                RrdGraphCmd.println(string4);
            }
            if (rrdGraphInfo.getImgInfo() != null && rrdGraphInfo.getImgInfo().length() > 0) {
                RrdGraphCmd.println(rrdGraphInfo.getImgInfo());
            }
        }
        return rrdGraphInfo;
    }

    private void parseLine(String string) throws RrdException {
        String[] stringArray = new ColonSplitter(string).split();
        if (stringArray.length != 2 && stringArray.length != 3) {
            throw new RrdException("Invalid LINE statement: " + string);
        }
        String[] stringArray2 = stringArray[1].split("#");
        if (stringArray2.length != 1 && stringArray2.length != 2) {
            throw new RrdException("Invalid LINE statement: " + string);
        }
        float f = Integer.parseInt(stringArray[0].substring(stringArray[0].length() - 1));
        String string2 = stringArray2[0];
        Color color = stringArray2.length == 2 ? Util.parseColor(stringArray2[1]) : BLIND_COLOR;
        String string3 = stringArray.length == 3 ? stringArray[2] : null;
        this.gdef.line(string2, color, string3, f);
    }

    private void parseArea(String string) throws RrdException {
        String[] stringArray = new ColonSplitter(string).split();
        if (stringArray.length != 2 && stringArray.length != 3) {
            throw new RrdException("Invalid AREA statement: " + string);
        }
        String[] stringArray2 = stringArray[1].split("#");
        if (stringArray2.length != 1 && stringArray2.length != 2) {
            throw new RrdException("Invalid AREA statement: " + string);
        }
        String string2 = stringArray2[0];
        Color color = stringArray2.length == 2 ? Util.parseColor(stringArray2[1]) : BLIND_COLOR;
        String string3 = stringArray.length == 3 ? stringArray[2] : null;
        this.gdef.area(string2, color, string3);
    }

    private void parseStack(String string) throws RrdException {
        String[] stringArray = new ColonSplitter(string).split();
        if (stringArray.length != 2 && stringArray.length != 3) {
            throw new RrdException("Invalid STACK statement: " + string);
        }
        String[] stringArray2 = stringArray[1].split("#");
        if (stringArray2.length != 1 && stringArray2.length != 2) {
            throw new RrdException("Invalid STACK statement: " + string);
        }
        String string2 = stringArray2[0];
        Color color = stringArray2.length == 2 ? Util.parseColor(stringArray2[1]) : BLIND_COLOR;
        String string3 = stringArray.length == 3 ? stringArray[2] : null;
        this.gdef.stack(string2, color, string3);
    }

    private void parseHRule(String string) throws RrdException {
        String[] stringArray = new ColonSplitter(string).split();
        if (stringArray.length < 2 || stringArray.length > 3) {
            throw new RrdException("Invalid HRULE statement: " + string);
        }
        String[] stringArray2 = stringArray[1].split("#");
        if (stringArray2.length != 2) {
            throw new RrdException("Invalid HRULE statement: " + string);
        }
        double d = RrdGraphCmd.parseDouble(stringArray2[0]);
        Paint paint = Util.parseColor(stringArray2[1]);
        this.gdef.hrule(d, paint, stringArray.length == 3 ? stringArray[2] : null);
    }

    private void parseVRule(String string) throws RrdException {
        String[] stringArray = new ColonSplitter(string).split();
        if (stringArray.length < 2 || stringArray.length > 3) {
            throw new RrdException("Invalid VRULE statement: " + string);
        }
        String[] stringArray2 = stringArray[1].split("#");
        if (stringArray2.length != 2) {
            throw new RrdException("Invalid VRULE statement: " + string);
        }
        long l = Util.getTimestamp(stringArray2[0]);
        Paint paint = Util.parseColor(stringArray2[1]);
        this.gdef.vrule(l, paint, stringArray.length == 3 ? stringArray[2] : null);
    }

    private void parseComment(String string) throws RrdException {
        String[] stringArray = new ColonSplitter(string).split();
        if (stringArray.length != 2) {
            throw new RrdException("Invalid COMMENT specification: " + string);
        }
        this.gdef.comment(stringArray[1]);
    }

    private void parseDef(String string) throws RrdException {
        String[] stringArray = new ColonSplitter(string).split();
        if (stringArray.length != 4) {
            throw new RrdException("Invalid DEF specification: " + string);
        }
        String[] stringArray2 = stringArray[1].split("=");
        if (stringArray2.length != 2) {
            throw new RrdException("Invalid DEF specification: " + string);
        }
        this.gdef.datasource(stringArray2[0], stringArray2[1], stringArray[2], stringArray[3]);
    }

    private void parseCDef(String string) throws RrdException {
        String[] stringArray = new ColonSplitter(string).split();
        if (stringArray.length != 2) {
            throw new RrdException("Invalid CDEF specification: " + string);
        }
        String[] stringArray2 = stringArray[1].split("=");
        if (stringArray2.length != 2) {
            throw new RrdException("Invalid DEF specification: " + string);
        }
        this.gdef.datasource(stringArray2[0], stringArray2[1]);
    }

    private void parsePrint(String string) throws RrdException {
        String[] stringArray = new ColonSplitter(string).split();
        if (stringArray.length != 4) {
            throw new RrdException("Invalid PRINT specification: " + string);
        }
        this.gdef.print(stringArray[1], stringArray[2], stringArray[3]);
    }

    private void parseGPrint(String string) throws RrdException {
        String[] stringArray = new ColonSplitter(string).split();
        if (stringArray.length != 4) {
            throw new RrdException("Invalid GPRINT specification: " + string);
        }
        this.gdef.gprint(stringArray[1], stringArray[2], stringArray[3]);
    }

    private void parseColors(String[] stringArray) throws RrdException {
        if (stringArray == null) {
            return;
        }
        for (String string : stringArray) {
            String[] stringArray2 = string.split("#");
            if (stringArray2.length != 2) {
                throw new RrdException("Invalid COLOR specification: " + string);
            }
            String string2 = stringArray2[0];
            Paint paint = Util.parseColor(stringArray2[1]);
            this.gdef.setColor(string2, paint);
        }
    }

    private void parseYGrid(String string) throws RrdException {
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("none")) {
            this.gdef.setDrawYGrid(false);
            return;
        }
        String[] stringArray = new ColonSplitter(string).split();
        if (stringArray.length != 2) {
            throw new RrdException("Invalid YGRID settings: " + string);
        }
        double d = RrdGraphCmd.parseDouble(stringArray[0]);
        int n = RrdGraphCmd.parseInt(stringArray[1]);
        this.gdef.setValueAxis(d, n);
    }

    private void parseXGrid(String string) throws RrdException {
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("none")) {
            this.gdef.setDrawXGrid(false);
            return;
        }
        String[] stringArray = new ColonSplitter(string).split();
        if (stringArray.length != 8) {
            throw new RrdException("Invalid XGRID settings: " + string);
        }
        int n = this.resolveUnit(stringArray[0]);
        int n2 = this.resolveUnit(stringArray[2]);
        int n3 = this.resolveUnit(stringArray[4]);
        int n4 = RrdGraphCmd.parseInt(stringArray[1]);
        int n5 = RrdGraphCmd.parseInt(stringArray[3]);
        int n6 = RrdGraphCmd.parseInt(stringArray[5]);
        int n7 = RrdGraphCmd.parseInt(stringArray[6]);
        String string2 = stringArray[7];
        this.gdef.setTimeAxis(n, n4, n2, n5, n3, n6, n7, string2);
    }

    private int resolveUnit(String string) throws RrdException {
        String[] stringArray = new String[]{"SECOND", "MINUTE", "HOUR", "DAY", "WEEK", "MONTH", "YEAR"};
        int[] nArray = new int[]{13, 12, 11, 5, 3, 2, 1};
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            return nArray[i];
        }
        throw new RrdException("Unknown time unit specified: " + string);
    }
}

