/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.address;

import gov.nist.core.GenericObject;
import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.core.NameValue;
import gov.nist.core.NameValueList;
import gov.nist.javax.sip.address.Authority;
import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.address.TelephoneNumber;
import gov.nist.javax.sip.address.UserInfo;
import java.text.ParseException;
import java.util.Iterator;
import javax.sip.address.SipURI;

public class SipUri
extends GenericURI
implements SipURI {
    protected String scheme = "sip";
    protected Authority authority;
    protected NameValueList uriParms = new NameValueList();
    protected NameValueList qheaders = new NameValueList();
    protected TelephoneNumber telephoneSubscriber;

    public SipUri() {
        this.qheaders.setSeparator("&");
    }

    public void setScheme(String string) {
        if (string.compareToIgnoreCase("sip") != 0 && string.compareToIgnoreCase("sips") != 0) {
            throw new IllegalArgumentException("bad scheme " + string);
        }
        this.scheme = string.toLowerCase();
    }

    public String getScheme() {
        return this.scheme;
    }

    public void clearUriParms() {
        this.uriParms = new NameValueList();
    }

    public void clearPassword() {
        UserInfo userInfo;
        if (this.authority != null && (userInfo = this.authority.getUserInfo()) != null) {
            userInfo.clearPassword();
        }
    }

    public Authority getAuthority() {
        return this.authority;
    }

    public void clearQheaders() {
        this.qheaders = new NameValueList();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SipURI) {
            String string;
            String string2;
            String string3;
            SipUri sipUri = this;
            SipURI sipURI = (SipURI)object;
            if (sipUri.isSecure() ^ sipURI.isSecure()) {
                return false;
            }
            if (sipUri.getUser() == null ^ sipURI.getUser() == null) {
                return false;
            }
            if (sipUri.getUserPassword() == null ^ sipURI.getUserPassword() == null) {
                return false;
            }
            if (sipUri.getUser() != null && !sipUri.getUser().equals(sipURI.getUser())) {
                return false;
            }
            if (sipUri.getUserPassword() != null && !sipUri.getUserPassword().equals(sipURI.getUserPassword())) {
                return false;
            }
            if (sipUri.getHost() == null ^ sipURI.getHost() == null) {
                return false;
            }
            if (sipUri.getHost() != null && !sipUri.getHost().equalsIgnoreCase(sipURI.getHost())) {
                return false;
            }
            if (sipUri.getPort() != sipURI.getPort()) {
                return false;
            }
            Iterator iterator = sipUri.getParameterNames();
            while (iterator.hasNext()) {
                string3 = (String)iterator.next();
                string2 = sipUri.getParameter(string3);
                string = sipURI.getParameter(string3);
                if (string2 == null || string == null || string2.equalsIgnoreCase(string)) continue;
                return false;
            }
            if (sipUri.getUserParam() == null ^ sipURI.getUserParam() == null) {
                return false;
            }
            if (sipUri.getTTLParam() == -1 ^ sipURI.getTTLParam() == -1) {
                return false;
            }
            if (sipUri.getMethodParam() == null ^ sipURI.getMethodParam() == null) {
                return false;
            }
            if (sipUri.getMAddrParam() == null ^ sipURI.getMAddrParam() == null) {
                return false;
            }
            iterator = sipUri.getHeaderNames();
            while (iterator.hasNext()) {
                string3 = (String)iterator.next();
                string2 = sipUri.getHeader(string3);
                string = sipURI.getHeader(string3);
                if (string2 == null || string == null || string2.equalsIgnoreCase(string)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String encode() {
        return this.encode(new StringBuffer()).toString();
    }

    public StringBuffer encode(StringBuffer stringBuffer) {
        stringBuffer.append(this.scheme).append(":");
        if (this.authority != null) {
            this.authority.encode(stringBuffer);
        }
        if (!this.uriParms.isEmpty()) {
            stringBuffer.append(";");
            this.uriParms.encode(stringBuffer);
        }
        if (!this.qheaders.isEmpty()) {
            stringBuffer.append("?");
            this.qheaders.encode(stringBuffer);
        }
        return stringBuffer;
    }

    public String toString() {
        return this.encode();
    }

    public String getUserAtHost() {
        String string = "";
        if (this.authority.getUserInfo() != null) {
            string = this.authority.getUserInfo().getUser();
        }
        String string2 = this.authority.getHost().encode();
        StringBuffer stringBuffer = null;
        stringBuffer = string.equals("") ? new StringBuffer() : new StringBuffer(string).append("@");
        return stringBuffer.append(string2).toString();
    }

    public String getUserAtHostPort() {
        String string = "";
        if (this.authority.getUserInfo() != null) {
            string = this.authority.getUserInfo().getUser();
        }
        String string2 = this.authority.getHost().encode();
        int n = this.authority.getPort();
        StringBuffer stringBuffer = null;
        stringBuffer = string.equals("") ? new StringBuffer() : new StringBuffer(string).append("@");
        if (n != -1) {
            return stringBuffer.append(string2).append(":").append(n).toString();
        }
        return stringBuffer.append(string2).toString();
    }

    public Object getParm(String string) {
        Object object = this.uriParms.getValue(string);
        return object;
    }

    public String getMethod() {
        return (String)this.getParm("method");
    }

    public NameValueList getUriParms() {
        return this.uriParms;
    }

    public void removeUriParms() {
        this.uriParms = new NameValueList();
    }

    public NameValueList getQheaders() {
        return this.qheaders;
    }

    public String getUserType() {
        return (String)this.uriParms.getValue("user");
    }

    public String getUserPassword() {
        if (this.authority == null) {
            return null;
        }
        return this.authority.getPassword();
    }

    public void setUserPassword(String string) {
        if (this.authority == null) {
            this.authority = new Authority();
        }
        this.authority.setPassword(string);
    }

    public TelephoneNumber getTelephoneSubscriber() {
        if (this.telephoneSubscriber == null) {
            this.telephoneSubscriber = new TelephoneNumber();
        }
        return this.telephoneSubscriber;
    }

    public HostPort getHostPort() {
        if (this.authority == null || this.authority.getHost() == null) {
            return null;
        }
        return this.authority.getHostPort();
    }

    public int getPort() {
        HostPort hostPort = this.getHostPort();
        if (hostPort == null) {
            return -1;
        }
        return hostPort.getPort();
    }

    public String getHost() {
        if (this.authority == null) {
            return null;
        }
        if (this.authority.getHost() == null) {
            return null;
        }
        return this.authority.getHost().encode();
    }

    public boolean isUserTelephoneSubscriber() {
        String string = (String)this.uriParms.getValue("user");
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase("phone");
    }

    public void removeTTL() {
        if (this.uriParms != null) {
            this.uriParms.delete("ttl");
        }
    }

    public void removeMAddr() {
        if (this.uriParms != null) {
            this.uriParms.delete("maddr");
        }
    }

    public void removeTransport() {
        if (this.uriParms != null) {
            this.uriParms.delete("transport");
        }
    }

    public void removeHeader(String string) {
        if (this.qheaders != null) {
            this.qheaders.delete(string);
        }
    }

    public void removeHeaders() {
        this.qheaders = new NameValueList();
    }

    public void removeUserType() {
        if (this.uriParms != null) {
            this.uriParms.delete("user");
        }
    }

    public void removePort() {
        this.authority.removePort();
    }

    public void removeMethod() {
        if (this.uriParms != null) {
            this.uriParms.delete("method");
        }
    }

    public void setUser(String string) {
        if (this.authority == null) {
            this.authority = new Authority();
        }
        this.authority.setUser(string);
    }

    public void removeUser() {
        this.authority.removeUserInfo();
    }

    public void setDefaultParm(String string, Object object) {
        if (this.uriParms.getValue(string) == null) {
            NameValue nameValue = new NameValue(string, object);
            this.uriParms.set(nameValue);
        }
    }

    public void setAuthority(Authority authority) {
        this.authority = authority;
    }

    public void setHost(Host host) {
        if (this.authority == null) {
            this.authority = new Authority();
        }
        this.authority.setHost(host);
    }

    public void setUriParms(NameValueList nameValueList) {
        this.uriParms = nameValueList;
    }

    public void setUriParm(String string, Object object) {
        NameValue nameValue = new NameValue(string, object);
        this.uriParms.set(nameValue);
    }

    public void setQheaders(NameValueList nameValueList) {
        this.qheaders = nameValueList;
    }

    public void setMAddr(String string) {
        NameValue nameValue = this.uriParms.getNameValue("maddr");
        Host host = new Host();
        host.setAddress(string);
        if (nameValue != null) {
            nameValue.setValue(host);
        } else {
            nameValue = new NameValue("maddr", host);
            this.uriParms.set(nameValue);
        }
    }

    public void setUserParam(String string) {
        this.uriParms.set("user", string);
    }

    public void setMethod(String string) {
        this.uriParms.set("method", string);
    }

    public void setIsdnSubAddress(String string) {
        if (this.telephoneSubscriber == null) {
            this.telephoneSubscriber = new TelephoneNumber();
        }
        this.telephoneSubscriber.setIsdnSubaddress(string);
    }

    public void setTelephoneSubscriber(TelephoneNumber telephoneNumber) {
        this.telephoneSubscriber = telephoneNumber;
    }

    public void setPort(int n) {
        if (this.authority == null) {
            this.authority = new Authority();
        }
        this.authority.setPort(n);
    }

    public boolean hasParameter(String string) {
        return this.uriParms.getValue(string) != null;
    }

    public void setQHeader(NameValue nameValue) {
        this.qheaders.set(nameValue);
    }

    public void setUriParameter(NameValue nameValue) {
        this.uriParms.set(nameValue);
    }

    public boolean hasTransport() {
        return this.hasParameter("transport");
    }

    public void removeParameter(String string) {
        this.uriParms.delete(string);
    }

    public void setHostPort(HostPort hostPort) {
        if (this.authority == null) {
            this.authority = new Authority();
        }
        this.authority.setHostPort(hostPort);
    }

    public Object clone() {
        SipUri sipUri = (SipUri)super.clone();
        if (this.authority != null) {
            sipUri.authority = (Authority)this.authority.clone();
        }
        if (this.uriParms != null) {
            sipUri.uriParms = (NameValueList)this.uriParms.clone();
        }
        if (this.qheaders != null) {
            sipUri.qheaders = (NameValueList)this.qheaders.clone();
        }
        if (this.telephoneSubscriber != null) {
            sipUri.telephoneSubscriber = (TelephoneNumber)this.telephoneSubscriber.clone();
        }
        return sipUri;
    }

    public String getHeader(String string) {
        return this.qheaders.getValue(string) != null ? this.qheaders.getValue(string).toString() : null;
    }

    public Iterator getHeaderNames() {
        return this.qheaders.getNames();
    }

    public String getLrParam() {
        boolean bl = this.hasParameter("lr");
        return bl ? "true" : null;
    }

    public String getMAddrParam() {
        NameValue nameValue = this.uriParms.getNameValue("maddr");
        if (nameValue == null) {
            return null;
        }
        String string = (String)nameValue.getValue();
        return string;
    }

    public String getMethodParam() {
        return this.getParameter("method");
    }

    public String getParameter(String string) {
        Object object = this.uriParms.getValue(string);
        if (object == null) {
            return null;
        }
        if (object instanceof GenericObject) {
            return ((GenericObject)object).encode();
        }
        return object.toString();
    }

    public Iterator getParameterNames() {
        return this.uriParms.getNames();
    }

    public int getTTLParam() {
        Integer n = (Integer)this.uriParms.getValue("ttl");
        if (n != null) {
            return n;
        }
        return -1;
    }

    public String getTransportParam() {
        if (this.uriParms != null) {
            return (String)this.uriParms.getValue("transport");
        }
        return null;
    }

    public String getUser() {
        return this.authority.getUser();
    }

    public boolean isSecure() {
        return this.getScheme().equalsIgnoreCase("sips");
    }

    public boolean isSipURI() {
        return true;
    }

    public void setHeader(String string, String string2) {
        NameValue nameValue = new NameValue(string, string2);
        this.qheaders.set(nameValue);
    }

    public void setHost(String string) throws ParseException {
        Host host = new Host(string);
        this.setHost(host);
    }

    public void setLrParam() {
        this.uriParms.set("lr", null);
    }

    public void setMAddrParam(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("bad maddr");
        }
        this.setParameter("maddr", string);
    }

    public void setMethodParam(String string) throws ParseException {
        this.setParameter("method", string);
    }

    public void setParameter(String string, String string2) throws ParseException {
        if (string.equalsIgnoreCase("ttl")) {
            try {
                int n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("bad parameter " + string2, 0);
            }
        }
        this.uriParms.set(string, string2);
    }

    public void setSecure(boolean bl) {
        this.scheme = bl ? "sips" : "sip";
    }

    public void setTTLParam(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Bad ttl value");
        }
        if (this.uriParms != null) {
            NameValue nameValue = new NameValue("ttl", new Integer(n));
            this.uriParms.set(nameValue);
        }
    }

    public void setTransportParam(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("null arg");
        }
        if (string.compareToIgnoreCase("UDP") != 0 && string.compareToIgnoreCase("TLS") != 0 && string.compareToIgnoreCase("TCP") != 0) {
            throw new ParseException("bad transport " + string, 0);
        }
        NameValue nameValue = new NameValue("transport", string.toLowerCase());
        this.uriParms.set(nameValue);
    }

    public String getUserParam() {
        return this.getParameter("user");
    }

    public boolean hasLrParam() {
        return this.uriParms.getNameValue("lr") != null;
    }

    public boolean hasGrParam() {
        return this.uriParms.getNameValue("gr") != null;
    }

    public void setGrParam(String string) {
        this.uriParms.set("gr", string);
    }

    public String getGrParam() {
        return (String)this.uriParms.getValue("gr");
    }
}

