/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network.challenge;

public class SHA1 {
    private int[] m_h = new int[5];
    private int[] m_w = new int[80];
    private int m_iLenW;
    private long m_lBitCount;
    private static final byte[] s_pad0x80 = new byte[]{-128};
    private static final byte[] s_pad0x00 = new byte[]{0};

    public SHA1() {
        this.initH();
        this.initW();
    }

    public void reset() {
        this.m_lBitCount = 0L;
        this.m_iLenW = 0;
        this.initH();
        this.initW();
    }

    public void update(byte[] bytes) {
        this.update(bytes, 0, bytes.length);
    }

    public void update(byte[] bytes, int iOffset, int iLen) {
        for (int i = iOffset; i < iLen; ++i) {
            int n = this.m_iLenW / 4;
            this.m_w[n] = this.m_w[n] << 8;
            int n2 = this.m_iLenW / 4;
            this.m_w[n2] = this.m_w[n2] | bytes[i] & 0xFF;
            if (++this.m_iLenW % 64 == 0) {
                this.hashBlock();
                this.m_iLenW = 0;
            }
            this.m_lBitCount += 8L;
        }
    }

    public byte[] digest() {
        byte[] padlen = new byte[]{(byte)(this.m_lBitCount >> 56 & 0xFFL), (byte)(this.m_lBitCount >> 48 & 0xFFL), (byte)(this.m_lBitCount >> 40 & 0xFFL), (byte)(this.m_lBitCount >> 32 & 0xFFL), (byte)(this.m_lBitCount >> 24 & 0xFFL), (byte)(this.m_lBitCount >> 16 & 0xFFL), (byte)(this.m_lBitCount >> 8 & 0xFFL), (byte)(this.m_lBitCount >> 0 & 0xFFL)};
        this.update(s_pad0x80, 0, 1);
        while (this.m_iLenW != 56) {
            this.update(s_pad0x00, 0, 1);
        }
        this.update(padlen, 0, 8);
        byte[] hashout = new byte[20];
        for (int i = 0; i < 20; ++i) {
            hashout[i] = (byte)(this.m_h[i / 4] >> 24);
            int n = i / 4;
            this.m_h[n] = this.m_h[n] << 8;
        }
        this.reset();
        return hashout;
    }

    public void setBitCount(long lCount) {
        this.m_lBitCount = lCount;
    }

    private void initH() {
        this.m_h[0] = 1732584193;
        this.m_h[1] = -271733879;
        this.m_h[2] = -1732584194;
        this.m_h[3] = 271733878;
        this.m_h[4] = -1009589776;
    }

    private void initW() {
        for (int i = 0; i < this.m_w.length; ++i) {
            this.m_w[i] = 0;
        }
    }

    private int shaRotl(int iX, int iN) {
        return iX << iN | iX >>> 32 - iN;
    }

    private void hashBlock() {
        int iTemp;
        int t;
        for (t = 16; t <= 79; ++t) {
            this.m_w[t] = this.shaRotl(this.m_w[t - 3] ^ this.m_w[t - 8] ^ this.m_w[t - 14] ^ this.m_w[t - 16], 1);
        }
        int iA = this.m_h[0];
        int iB = this.m_h[1];
        int iC = this.m_h[2];
        int iD = this.m_h[3];
        int iE = this.m_h[4];
        for (t = 0; t <= 19; ++t) {
            iTemp = this.shaRotl(iA, 5) + ((iC ^ iD) & iB ^ iD) + iE + this.m_w[t] + 1518500249;
            iE = iD;
            iD = iC;
            iC = this.shaRotl(iB, 30);
            iB = iA;
            iA = iTemp;
        }
        for (t = 20; t <= 39; ++t) {
            iTemp = this.shaRotl(iA, 5) + (iB ^ iC ^ iD) + iE + this.m_w[t] + 1859775393;
            iE = iD;
            iD = iC;
            iC = this.shaRotl(iB, 30);
            iB = iA;
            iA = iTemp;
        }
        for (t = 40; t <= 59; ++t) {
            iTemp = this.shaRotl(iA, 5) + (iB & iC | iD & (iB | iC)) + iE + this.m_w[t] + -1894007588;
            iE = iD;
            iD = iC;
            iC = this.shaRotl(iB, 30);
            iB = iA;
            iA = iTemp;
        }
        for (t = 60; t <= 79; ++t) {
            iTemp = this.shaRotl(iA, 5) + (iB ^ iC ^ iD) + iE + this.m_w[t] + -899497514;
            iE = iD;
            iD = iC;
            iC = this.shaRotl(iB, 30);
            iB = iA;
            iA = iTemp;
        }
        this.m_h[0] = this.m_h[0] + iA;
        this.m_h[1] = this.m_h[1] + iB;
        this.m_h[2] = this.m_h[2] + iC;
        this.m_h[3] = this.m_h[3] + iD;
        this.m_h[4] = this.m_h[4] + iE;
    }
}

