/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.ElementTags;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.Phrase;
import com.lowagie.text.html.Markup;
import java.util.Properties;

public class Paragraph
extends Phrase {
    private static final long serialVersionUID = 7852314969733375514L;
    protected int alignment = -1;
    protected float indentationLeft;
    protected float indentationRight;
    protected float spacingBefore;
    protected float spacingAfter;
    protected boolean keeptogether = false;
    protected float multipliedLeading = 0.0f;
    private float firstLineIndent = 0.0f;
    private float extraParagraphSpace = 0.0f;

    public Paragraph() {
    }

    public Paragraph(float f) {
        super(f);
    }

    public Paragraph(Chunk chunk) {
        super(chunk);
    }

    public Paragraph(float f, Chunk chunk) {
        super(f, chunk);
    }

    public Paragraph(String string) {
        super(string);
    }

    public Paragraph(String string, Font font) {
        super(string, font);
    }

    public Paragraph(float f, String string) {
        super(f, string);
    }

    public Paragraph(float f, String string, Font font) {
        super(f, string, font);
    }

    public Paragraph(Phrase phrase) {
        super(phrase.leading, "", phrase.font());
        super.add(phrase);
        if (phrase instanceof Paragraph) {
            Paragraph paragraph = (Paragraph)phrase;
            this.setAlignment(paragraph.alignment());
            this.setExtraParagraphSpace(paragraph.getExtraParagraphSpace());
            this.setFirstLineIndent(paragraph.getFirstLineIndent());
            this.setIndentationLeft(paragraph.indentationLeft());
            this.setIndentationRight(paragraph.indentationRight());
            this.setSpacingAfter(paragraph.spacingAfter());
            this.setSpacingBefore(paragraph.spacingBefore());
        }
    }

    public Paragraph(Properties properties) {
        this("", FontFactory.getFont(properties));
        String string = (String)properties.remove("itext");
        if (string != null) {
            Chunk chunk = new Chunk(string);
            string = (String)properties.remove(ElementTags.GENERICTAG);
            if (string != null) {
                chunk.setGenericTag(string);
            }
            this.add(chunk);
        }
        if ((string = (String)properties.remove("align")) != null) {
            this.setAlignment(string);
        }
        if ((string = (String)properties.remove("leading")) != null) {
            this.setLeading(Float.parseFloat(string + "f"));
        } else {
            string = (String)properties.remove("line-height");
            if (string != null) {
                this.setLeading(Markup.parseLength(string));
            } else {
                this.setLeading(16.0f);
            }
        }
        string = (String)properties.remove("indentationleft");
        if (string != null) {
            this.setIndentationLeft(Float.parseFloat(string + "f"));
        }
        if ((string = (String)properties.remove("indentationright")) != null) {
            this.setIndentationRight(Float.parseFloat(string + "f"));
        }
        if ((string = (String)properties.remove("keeptogether")) != null) {
            this.keeptogether = Boolean.valueOf(string);
        }
    }

    public int type() {
        return 12;
    }

    public boolean add(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            list.setIndentationLeft(list.indentationLeft() + this.indentationLeft);
            list.setIndentationRight(this.indentationRight);
            return super.add(list);
        }
        if (object instanceof Image) {
            super.addSpecial(object);
            return true;
        }
        if (object instanceof Paragraph) {
            super.add(object);
            super.add(Chunk.NEWLINE);
            return true;
        }
        return super.add(object);
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public void setAlignment(String string) {
        if ("Center".equalsIgnoreCase(string)) {
            this.alignment = 1;
            return;
        }
        if ("Right".equalsIgnoreCase(string)) {
            this.alignment = 2;
            return;
        }
        if ("Justify".equalsIgnoreCase(string)) {
            this.alignment = 3;
            return;
        }
        if ("JustifyAll".equalsIgnoreCase(string)) {
            this.alignment = 8;
            return;
        }
        this.alignment = 0;
    }

    public void setIndentationLeft(float f) {
        this.indentationLeft = f;
    }

    public void setIndentationRight(float f) {
        this.indentationRight = f;
    }

    public void setSpacingBefore(float f) {
        this.spacingBefore = f;
    }

    public void setSpacingAfter(float f) {
        this.spacingAfter = f;
    }

    public void setKeepTogether(boolean bl) {
        this.keeptogether = bl;
    }

    public boolean getKeepTogether() {
        return this.keeptogether;
    }

    public int alignment() {
        return this.alignment;
    }

    public float indentationLeft() {
        return this.indentationLeft;
    }

    public float indentationRight() {
        return this.indentationRight;
    }

    public float spacingBefore() {
        return this.spacingBefore;
    }

    public float spacingAfter() {
        return this.spacingAfter;
    }

    public static boolean isTag(String string) {
        return "paragraph".equals(string);
    }

    public void setLeading(float f, float f2) {
        this.leading = f;
        this.multipliedLeading = f2;
    }

    public void setLeading(float f) {
        this.leading = f;
        this.multipliedLeading = 0.0f;
    }

    public float getMultipliedLeading() {
        return this.multipliedLeading;
    }

    public float getTotalLeading() {
        float f;
        float f2 = f = this.font == null ? 12.0f * this.multipliedLeading : this.font.leading(this.multipliedLeading);
        if (f > 0.0f && !this.leadingDefined()) {
            return f;
        }
        return this.leading() + f;
    }

    public float getFirstLineIndent() {
        return this.firstLineIndent;
    }

    public void setFirstLineIndent(float f) {
        this.firstLineIndent = f;
    }

    public float getExtraParagraphSpace() {
        return this.extraParagraphSpace;
    }

    public void setExtraParagraphSpace(float f) {
        this.extraParagraphSpace = f;
    }
}

