/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.address;

import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.javax.sip.address.NetObject;
import gov.nist.javax.sip.address.UserInfo;

public class Authority
extends NetObject {
    protected HostPort hostPort;
    protected UserInfo userInfo;

    public String encode() {
        return this.encode(new StringBuffer()).toString();
    }

    public StringBuffer encode(StringBuffer stringBuffer) {
        if (this.userInfo != null) {
            this.userInfo.encode(stringBuffer);
            stringBuffer.append("@");
            this.hostPort.encode(stringBuffer);
        } else {
            this.hostPort.encode(stringBuffer);
        }
        return stringBuffer;
    }

    public boolean equals(Object object) {
        if (object.getClass() != this.getClass()) {
            return false;
        }
        Authority authority = (Authority)object;
        if (!this.hostPort.equals(authority.hostPort)) {
            return false;
        }
        return this.userInfo == null || authority.userInfo == null || this.userInfo.equals(authority.userInfo);
    }

    public HostPort getHostPort() {
        return this.hostPort;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public String getPassword() {
        if (this.userInfo == null) {
            return null;
        }
        return this.userInfo.password;
    }

    public String getUser() {
        return this.userInfo != null ? this.userInfo.user : null;
    }

    public Host getHost() {
        if (this.hostPort == null) {
            return null;
        }
        return this.hostPort.getHost();
    }

    public int getPort() {
        if (this.hostPort == null) {
            return -1;
        }
        return this.hostPort.getPort();
    }

    public void removePort() {
        if (this.hostPort != null) {
            this.hostPort.removePort();
        }
    }

    public void setPassword(String string) {
        if (this.userInfo == null) {
            this.userInfo = new UserInfo();
        }
        this.userInfo.setPassword(string);
    }

    public void setUser(String string) {
        if (this.userInfo == null) {
            this.userInfo = new UserInfo();
        }
        this.userInfo.setUser(string);
    }

    public void setHost(Host host) {
        if (this.hostPort == null) {
            this.hostPort = new HostPort();
        }
        this.hostPort.setHost(host);
    }

    public void setPort(int n) {
        if (this.hostPort == null) {
            this.hostPort = new HostPort();
        }
        this.hostPort.setPort(n);
    }

    public void setHostPort(HostPort hostPort) {
        this.hostPort = hostPort;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public void removeUserInfo() {
        this.userInfo = null;
    }

    public Object clone() {
        Authority authority = (Authority)super.clone();
        if (this.hostPort != null) {
            authority.hostPort = (HostPort)this.hostPort.clone();
        }
        if (this.userInfo != null) {
            authority.userInfo = (UserInfo)this.userInfo.clone();
        }
        return authority;
    }
}

