/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.jnodes.smack;

import org.jivesoftware.smack.packet.IQ;

public class JingleChannelIQ
extends IQ {
    public static final String NAME = "channel";
    public static final String NAMESPACE = "http://jabber.org/protocol/jinglenodes#channel";
    private Protocol protocol = Protocol.udp;
    private String host;
    private int porta = -1;
    private int portb = -1;
    private String id;

    public JingleChannelIQ() {
        this.setType(IQ.Type.GET);
        this.setPacketID(IQ.nextID());
    }

    public String getChildElementXML() {
        StringBuilder str = new StringBuilder();
        str.append("<").append(NAME).append(" xmlns='").append(NAMESPACE).append("' protocol='").append((Object)this.protocol).append("' ");
        if (this.porta > 0 && this.portb > 0 && this.host != null) {
            str.append("host='").append(this.host).append("' ");
            str.append("porta='").append(this.porta).append("' ");
            str.append("portb='").append(this.portb).append("' ");
        }
        str.append("/>");
        return str.toString();
    }

    public boolean isRequest() {
        return IQ.Type.GET.equals(this.getType());
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public int getPortb() {
        return this.portb;
    }

    public void setPortb(int portb) {
        this.portb = portb;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPorta() {
        return this.porta;
    }

    public void setPorta(int porta) {
        this.porta = porta;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public static IQ createEmptyResult(IQ iq) {
        return JingleChannelIQ.createIQ(iq.getPacketID(), iq.getFrom(), iq.getTo(), IQ.Type.RESULT);
    }

    public static IQ createEmptyError(IQ iq) {
        return JingleChannelIQ.createIQ(iq.getPacketID(), iq.getFrom(), iq.getTo(), IQ.Type.ERROR);
    }

    public static IQ createEmptyError() {
        return JingleChannelIQ.createIQ(null, null, null, IQ.Type.ERROR);
    }

    public static IQ createIQ(String ID, String to, String from, IQ.Type type) {
        IQ iqPacket = new IQ(){

            public String getChildElementXML() {
                return null;
            }
        };
        iqPacket.setPacketID(ID);
        iqPacket.setTo(to);
        iqPacket.setFrom(from);
        iqPacket.setType(type);
        return iqPacket;
    }

    public static enum Protocol {
        udp,
        tcp;

    }
}

