/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io.nio;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.io.Connection;
import org.mortbay.io.EndPoint;
import org.mortbay.io.nio.SelectChannelEndPoint;
import org.mortbay.log.Log;
import org.mortbay.thread.Timeout;

public abstract class SelectorManager
extends AbstractLifeCycle {
    private boolean _delaySelectKeyUpdate = true;
    private long _maxIdleTime;
    private long _lowResourcesConnections;
    private long _lowResourcesMaxIdleTime;
    private transient SelectSet[] _selectSet;
    private int _selectSets = 1;
    private volatile int _set;

    public void setMaxIdleTime(long maxIdleTime) {
        this._maxIdleTime = maxIdleTime;
    }

    public void setSelectSets(int selectSets) {
        long lrc = this._lowResourcesConnections * (long)this._selectSets;
        this._selectSets = selectSets;
        this._lowResourcesConnections = lrc / (long)this._selectSets;
    }

    public long getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public int getSelectSets() {
        return this._selectSets;
    }

    public boolean isDelaySelectKeyUpdate() {
        return this._delaySelectKeyUpdate;
    }

    public void register(SocketChannel channel, Object att) throws IOException {
        int s = this._set++;
        SelectSet set = this._selectSet[s %= this._selectSets];
        set.addChange(channel, att);
        set.wakeup();
    }

    public void register(ServerSocketChannel acceptChannel) throws IOException {
        int s = this._set++;
        SelectSet set = this._selectSet[s %= this._selectSets];
        set.addChange(acceptChannel);
        set.wakeup();
    }

    public long getLowResourcesConnections() {
        return this._lowResourcesConnections * (long)this._selectSets;
    }

    public void setLowResourcesConnections(long lowResourcesConnections) {
        this._lowResourcesConnections = (lowResourcesConnections + (long)this._selectSets - 1L) / (long)this._selectSets;
    }

    public long getLowResourcesMaxIdleTime() {
        return this._lowResourcesMaxIdleTime;
    }

    public void setLowResourcesMaxIdleTime(long lowResourcesMaxIdleTime) {
        this._lowResourcesMaxIdleTime = lowResourcesMaxIdleTime;
    }

    public void doSelect(int acceptorID) throws IOException {
        if (this._selectSet != null && this._selectSet.length > acceptorID && this._selectSet[acceptorID] != null) {
            this._selectSet[acceptorID].doSelect();
        }
    }

    public void setDelaySelectKeyUpdate(boolean delaySelectKeyUpdate) {
        this._delaySelectKeyUpdate = delaySelectKeyUpdate;
    }

    protected abstract SocketChannel acceptChannel(SelectionKey var1) throws IOException;

    public abstract boolean dispatch(Runnable var1) throws IOException;

    protected void doStart() throws Exception {
        this._selectSet = new SelectSet[this._selectSets];
        for (int i = 0; i < this._selectSet.length; ++i) {
            this._selectSet[i] = new SelectSet(i);
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        for (int i = 0; i < this._selectSet.length; ++i) {
            this._selectSet[i].stop();
        }
        super.doStop();
        this._selectSet = null;
    }

    public void doStop(int i) throws Exception {
        this._selectSet[i].stop();
    }

    protected abstract void endPointClosed(SelectChannelEndPoint var1);

    protected abstract void endPointOpened(SelectChannelEndPoint var1);

    protected abstract Connection newConnection(SocketChannel var1, SelectChannelEndPoint var2);

    protected abstract SelectChannelEndPoint newEndPoint(SocketChannel var1, SelectSet var2, SelectionKey var3) throws IOException;

    protected void connectionFailed(SocketChannel channel, Throwable ex, Object attachment) {
        Log.warn((Throwable)ex);
    }

    public class SelectSet {
        private transient int _change;
        private transient List[] _changes;
        private transient Timeout _idleTimeout;
        private transient int _nextSet;
        private transient Timeout _retryTimeout;
        private transient Selector _selector;
        private transient int _setID;
        private transient boolean _selecting;
        private transient int _jvmBug;

        SelectSet(int acceptorID) throws Exception {
            this._setID = acceptorID;
            this._idleTimeout = new Timeout();
            this._idleTimeout.setDuration(SelectorManager.this.getMaxIdleTime());
            this._retryTimeout = new Timeout();
            this._retryTimeout.setDuration(0L);
            this._selector = Selector.open();
            this._changes = new ArrayList[]{new ArrayList(), new ArrayList()};
            this._change = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChange(Object point) {
            List[] listArray = this._changes;
            synchronized (this._changes) {
                this._changes[this._change].add(point);
                if (point instanceof SocketChannel) {
                    this._changes[this._change].add(null);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChange(SocketChannel channel, Object att) {
            List[] listArray = this._changes;
            synchronized (this._changes) {
                this._changes[this._change].add(channel);
                this._changes[this._change].add(att);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelIdle(Timeout.Task task) {
            SelectSet selectSet = this;
            synchronized (selectSet) {
                task.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void doSelect() throws IOException {
            SelectionKey key = null;
            try {
                List[] listArray = this._changes;
                synchronized (this._changes) {
                    block67: {
                        block66: {
                            List changes = this._changes[this._change];
                            this._change = this._change == 0 ? 1 : 0;
                            this._selecting = true;
                            // ** MonitorExit[var3_2] (shouldn't be in output)
                            for (int i = 0; i < changes.size(); ++i) {
                                try {
                                    AbstractSelectableChannel channel;
                                    Object o = changes.get(i);
                                    if (o instanceof EndPoint) {
                                        SelectChannelEndPoint endpoint = (SelectChannelEndPoint)o;
                                        endpoint.doUpdateKey();
                                        continue;
                                    }
                                    if (o instanceof Runnable) {
                                        SelectorManager.this.dispatch((Runnable)o);
                                        continue;
                                    }
                                    if (o instanceof SocketChannel) {
                                        channel = (SocketChannel)o;
                                        Object att = changes.get(++i);
                                        if (channel.isRegistered()) {
                                            throw new IllegalStateException();
                                        }
                                        if (((SocketChannel)channel).isConnected()) {
                                            key = channel.register(this._selector, 1, att);
                                            SelectChannelEndPoint endpoint = SelectorManager.this.newEndPoint((SocketChannel)channel, this, key);
                                            key.attach(endpoint);
                                            endpoint.dispatch();
                                            continue;
                                        }
                                        channel.register(this._selector, 8, att);
                                        continue;
                                    }
                                    if (!(o instanceof ServerSocketChannel)) throw new IllegalArgumentException(o.toString());
                                    channel = (ServerSocketChannel)o;
                                    channel.register(this.getSelector(), 16);
                                    continue;
                                }
                                catch (CancelledKeyException e) {
                                    if (SelectorManager.this.isRunning()) {
                                        Log.warn((Throwable)e);
                                        continue;
                                    }
                                    Log.debug((Throwable)e);
                                }
                            }
                            changes.clear();
                            long idle_next = 0L;
                            long retry_next = 0L;
                            long now = System.currentTimeMillis();
                            SelectSet selectSet = this;
                            synchronized (selectSet) {
                                this._idleTimeout.setNow(now);
                                this._retryTimeout.setNow(now);
                                if (SelectorManager.this._lowResourcesConnections > 0L && (long)this._selector.keys().size() > SelectorManager.this._lowResourcesConnections) {
                                    this._idleTimeout.setDuration(SelectorManager.this._lowResourcesMaxIdleTime);
                                } else {
                                    this._idleTimeout.setDuration(SelectorManager.this._maxIdleTime);
                                }
                                idle_next = this._idleTimeout.getTimeToNext();
                                retry_next = this._retryTimeout.getTimeToNext();
                            }
                            long wait = 1000L;
                            if (idle_next >= 0L && wait > idle_next) {
                                wait = idle_next;
                            }
                            if (wait > 0L && retry_next >= 0L && wait > retry_next) {
                                wait = retry_next;
                            }
                            if (wait <= 10L) break block66;
                            long before = now;
                            int selected = this._selector.select(wait);
                            now = System.currentTimeMillis();
                            this._idleTimeout.setNow(now);
                            this._retryTimeout.setNow(now);
                            if (selected == 0 && wait > 0L && now - before < wait / 2L && this._selector.selectedKeys().size() == 0) {
                                if (this._jvmBug++ > 5) {
                                    Iterator<SelectionKey> iter = this._selector.keys().iterator();
                                    while (iter.hasNext()) {
                                        key = iter.next();
                                        if (!key.isValid() || key.interestOps() != 0) continue;
                                        key.cancel();
                                    }
                                    try {
                                        Thread.sleep(20L);
                                    }
                                    catch (InterruptedException e) {
                                        Log.ignore((Throwable)e);
                                    }
                                }
                                break block67;
                            } else {
                                this._jvmBug = 0;
                            }
                            break block67;
                        }
                        this._selector.selectNow();
                        this._jvmBug = 0;
                    }
                    if (this._selector == null) return;
                    if (!this._selector.isOpen()) {
                        return;
                    }
                    Iterator<SelectionKey> iter = this._selector.selectedKeys().iterator();
                    while (iter.hasNext()) {
                        key = iter.next();
                        try {
                            block69: {
                                SelectChannelEndPoint endpoint;
                                SocketChannel channel;
                                Object att;
                                block70: {
                                    block68: {
                                        if (!key.isValid()) {
                                            key.cancel();
                                            SelectChannelEndPoint endpoint2 = (SelectChannelEndPoint)key.attachment();
                                            if (endpoint2 == null) continue;
                                            endpoint2.doUpdateKey();
                                            continue;
                                        }
                                        att = key.attachment();
                                        if (!(att instanceof SelectChannelEndPoint)) break block68;
                                        SelectChannelEndPoint endpoint3 = (SelectChannelEndPoint)att;
                                        endpoint3.dispatch();
                                        break block69;
                                    }
                                    if (!key.isAcceptable()) break block70;
                                    channel = SelectorManager.this.acceptChannel(key);
                                    if (channel == null) continue;
                                    channel.configureBlocking(false);
                                    ++this._nextSet;
                                    this._nextSet %= SelectorManager.this._selectSet.length;
                                    if (this._nextSet == this._setID) {
                                        SelectionKey cKey = channel.register(SelectorManager.this._selectSet[this._nextSet].getSelector(), 1);
                                        endpoint = SelectorManager.this.newEndPoint(channel, SelectorManager.this._selectSet[this._nextSet], cKey);
                                        cKey.attach(endpoint);
                                        if (endpoint != null) {
                                            endpoint.dispatch();
                                        }
                                        break block69;
                                    } else {
                                        SelectorManager.this._selectSet[this._nextSet].addChange(channel);
                                        SelectorManager.this._selectSet[this._nextSet].wakeup();
                                    }
                                    break block69;
                                }
                                if (key.isConnectable()) {
                                    channel = (SocketChannel)key.channel();
                                    boolean connected = false;
                                    try {
                                        connected = channel.finishConnect();
                                    }
                                    catch (Exception e) {
                                        SelectorManager.this.connectionFailed(channel, e, att);
                                    }
                                    finally {
                                        if (connected) {
                                            key.interestOps(1);
                                            endpoint = SelectorManager.this.newEndPoint(channel, this, key);
                                            key.attach(endpoint);
                                            endpoint.dispatch();
                                        } else {
                                            key.cancel();
                                        }
                                    }
                                } else {
                                    channel = (SocketChannel)key.channel();
                                    SelectChannelEndPoint endpoint4 = SelectorManager.this.newEndPoint(channel, this, key);
                                    key.attach(endpoint4);
                                    if (key.isReadable()) {
                                        endpoint4.dispatch();
                                    }
                                }
                            }
                            key = null;
                        }
                        catch (CancelledKeyException e) {
                            Log.ignore((Throwable)e);
                        }
                        catch (Exception e) {
                            if (SelectorManager.this.isRunning()) {
                                Log.warn((Throwable)e);
                            } else {
                                Log.ignore((Throwable)e);
                            }
                            if (key == null || key.channel() instanceof ServerSocketChannel || !key.isValid()) continue;
                            key.interestOps(0);
                            key.cancel();
                        }
                    }
                    this._selector.selectedKeys().clear();
                    Timeout.Task task = null;
                    SelectSet selectSet = this;
                    synchronized (selectSet) {
                        task = this._idleTimeout.expired();
                        if (task == null) {
                            task = this._retryTimeout.expired();
                        }
                    }
                    while (task != null) {
                        task.expire();
                        selectSet = this;
                        synchronized (selectSet) {
                            if (this._selector == null) {
                                return;
                            }
                            task = this._idleTimeout.expired();
                            if (task == null) {
                                task = this._retryTimeout.expired();
                            }
                        }
                    }
                    return;
                }
            }
            catch (CancelledKeyException e) {
                Log.ignore((Throwable)e);
                return;
            }
            finally {
                SelectSet selectSet = this;
                synchronized (selectSet) {
                    this._selecting = false;
                }
            }
        }

        public SelectorManager getManager() {
            return SelectorManager.this;
        }

        public long getNow() {
            return this._idleTimeout.getNow();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleIdle(Timeout.Task task) {
            SelectSet selectSet = this;
            synchronized (selectSet) {
                if (this._idleTimeout.getDuration() <= 0L) {
                    return;
                }
                task.schedule(this._idleTimeout);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleTimeout(Timeout.Task task, long timeout) {
            SelectSet selectSet = this;
            synchronized (selectSet) {
                this._retryTimeout.schedule(task, timeout);
            }
        }

        public void wakeup() {
            Selector selector = this._selector;
            if (selector != null) {
                selector.wakeup();
            }
        }

        Selector getSelector() {
            return this._selector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() throws Exception {
            boolean selecting = true;
            while (selecting) {
                this.wakeup();
                SelectSet selectSet = this;
                synchronized (selectSet) {
                    selecting = this._selecting;
                }
            }
            ArrayList<SelectionKey> keys = new ArrayList<SelectionKey>(this._selector.keys());
            Iterator<SelectionKey> iter = keys.iterator();
            while (iter.hasNext()) {
                EndPoint endpoint;
                SelectionKey key = iter.next();
                if (key == null || (endpoint = (EndPoint)key.attachment()) == null) continue;
                try {
                    endpoint.close();
                }
                catch (IOException e) {
                    Log.ignore((Throwable)e);
                }
            }
            SelectSet selectSet = this;
            synchronized (selectSet) {
                this._idleTimeout.cancelAll();
                this._retryTimeout.cancelAll();
                try {
                    if (this._selector != null) {
                        this._selector.close();
                    }
                }
                catch (IOException e) {
                    Log.ignore((Throwable)e);
                }
                this._selector = null;
            }
        }
    }
}

