/*
 * Decompiled with CFR 0.152.
 */
package de.javawi.jstun.util;

import de.javawi.jstun.util.Address;
import de.javawi.jstun.util.UtilityException;
import java.net.UnknownHostException;
import junit.framework.TestCase;

public class AddressTest
extends TestCase {
    Address address;

    public AddressTest(String mesg) {
        super(mesg);
    }

    protected void setUp() throws Exception {
        this.address = new Address("192.168.100.1");
    }

    public void testAddressIntIntIntInt() {
        try {
            Address comp = new Address(192, 168, 100, 1);
            AddressTest.assertTrue((boolean)this.address.equals(comp));
        }
        catch (UtilityException ue) {
            ue.printStackTrace();
        }
    }

    public void testAddressString() {
        try {
            Address comp = new Address("192.168.100.1");
            AddressTest.assertTrue((boolean)this.address.equals(comp));
        }
        catch (UtilityException ue) {
            ue.printStackTrace();
        }
    }

    public void testAddressByteArray() {
        try {
            byte[] data = new byte[]{-64, -88, 100, 1};
            Address comp = new Address(data);
            AddressTest.assertTrue((boolean)this.address.equals(comp));
        }
        catch (UtilityException ue) {
            ue.printStackTrace();
        }
    }

    public void testToString() {
        try {
            Address comp = new Address("192.168.100.1");
            AddressTest.assertTrue((boolean)this.address.equals(comp));
        }
        catch (UtilityException ue) {
            ue.printStackTrace();
        }
    }

    public void testGetBytes() {
        try {
            byte[] data = this.address.getBytes();
            AddressTest.assertTrue((data[0] == -64 ? 1 : 0) != 0);
            AddressTest.assertTrue((data[1] == -88 ? 1 : 0) != 0);
            AddressTest.assertTrue((data[2] == 100 ? 1 : 0) != 0);
            AddressTest.assertTrue((data[3] == 1 ? 1 : 0) != 0);
        }
        catch (UtilityException ue) {
            ue.printStackTrace();
        }
    }

    public void testGetInetAddress() {
        try {
            Address comp = new Address("192.168.100.1");
            AddressTest.assertTrue((boolean)this.address.getInetAddress().equals(comp.getInetAddress()));
            comp = new Address("192.168.100.2");
            AddressTest.assertFalse((boolean)this.address.getInetAddress().equals(comp.getInetAddress()));
        }
        catch (UtilityException ue) {
            ue.printStackTrace();
        }
        catch (UnknownHostException uhe) {
            uhe.printStackTrace();
        }
    }

    public void testEqualsObject() {
        try {
            Address comp = new Address("192.168.100.1");
            AddressTest.assertTrue((boolean)this.address.equals(comp));
            comp = new Address("192.168.100.2");
            AddressTest.assertFalse((boolean)this.address.equals(comp));
        }
        catch (UtilityException ue) {
            ue.printStackTrace();
        }
    }
}

