/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.document;

import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfParagraphStyle;

public class RtfDocumentSettings {
    private RtfDocument document = null;
    private boolean outputTableRowDefinitionAfter = true;
    private boolean outputDebugLineBreaks = true;
    private boolean alwaysGenerateSoftLinebreaks = false;
    private boolean alwaysUseUnicode = true;
    private int dataCacheStyle = 2;

    public RtfDocumentSettings(RtfDocument document) {
        this.document = document;
    }

    public boolean isOutputDebugLineBreaks() {
        return this.outputDebugLineBreaks;
    }

    public void setOutputDebugLineBreaks(boolean outputDebugLineBreaks) {
        this.outputDebugLineBreaks = outputDebugLineBreaks;
    }

    public boolean isOutputTableRowDefinitionAfter() {
        return this.outputTableRowDefinitionAfter;
    }

    public void setOutputTableRowDefinitionAfter(boolean outputTableRowDefinitionAfter) {
        this.outputTableRowDefinitionAfter = outputTableRowDefinitionAfter;
    }

    public boolean isAlwaysGenerateSoftLinebreaks() {
        return this.alwaysGenerateSoftLinebreaks;
    }

    public void setAlwaysGenerateSoftLinebreaks(boolean alwaysGenerateSoftLinebreaks) {
        this.alwaysGenerateSoftLinebreaks = alwaysGenerateSoftLinebreaks;
    }

    public boolean isAlwaysUseUnicode() {
        return this.alwaysUseUnicode;
    }

    public void setAlwaysUseUnicode(boolean alwaysUseUnicode) {
        this.alwaysUseUnicode = alwaysUseUnicode;
    }

    public void registerParagraphStyle(RtfParagraphStyle rtfParagraphStyle) {
        this.document.getDocumentHeader().registerParagraphStyle(rtfParagraphStyle);
    }

    public void setDataCacheStyle(int dataCacheStyle) {
        switch (dataCacheStyle) {
            case 2: {
                this.dataCacheStyle = 2;
                break;
            }
            case 1: {
                this.dataCacheStyle = 1;
                break;
            }
            default: {
                this.dataCacheStyle = 2;
            }
        }
    }

    public int getDataCacheStyle() {
        return this.dataCacheStyle;
    }
}

