/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.screens;

import com.install4j.api.ProgressInterface;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.InstallerScreen;
import com.install4j.runtime.installer.frontend.InstallerWizard;
import com.install4j.runtime.installer.frontend.components.ProgressDisplay;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class ProgressScreen
extends InstallerScreen
implements ProgressInterface {
    private ProgressDisplay progressDisplay;
    private int currentPercent;

    public ProgressScreen(InstallerWizard installerWizard) {
        super(installerWizard);
        this.initScreen();
    }

    public void activate() {
        this.progressDisplay.activate();
        super.activate();
    }

    public void setStatusMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressScreen.this.progressDisplay.setStatusMessage(string);
            }
        });
    }

    public void setDetailMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressScreen.this.progressDisplay.setDetailMessage(string);
            }
        });
    }

    public void setPercentCompleted(final int n) {
        if (n > -1) {
            if (this.currentPercent == n) {
                return;
            }
            this.currentPercent = n;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressScreen.this.progressDisplay.setPercentCompleted(n <= 100 ? n : 100);
            }
        });
    }

    public void setIndeterminateProgress(boolean bl) {
        this.progressDisplay.setIndeterminateProgress(bl);
    }

    public void showFailure(String string) {
        GUIHelper.showMessage(this.getParentWindow(), string, 0);
    }

    public int askOverwrite(File file) {
        String string = file.getPath() + "\n" + this.messages.getString("FileExists");
        int n = GUIHelper.showOptionDialog(this.getParentWindow(), string, new String[]{this.messages.getString("ButtonYes"), this.messages.getString("ButtonYesToAll"), this.messages.getString("ButtonNo"), this.messages.getString("ButtonNoToAll")}, 3);
        switch (n) {
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 4;
            }
        }
        return 1;
    }

    public int askRetry(File file) {
        int n = GUIHelper.showOptionDialog(this.getParentWindow(), MessageFormat.format(this.messages.getString("AskRetryInstallFile"), file.getPath()), new String[]{this.messages.getString("ButtonYes"), this.messages.getString("ButtonNo"), this.messages.getString("ButtonCancel")}, 3);
        switch (n) {
            case 0: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
        }
        return 3;
    }

    public boolean askContinue(File file) {
        int n = GUIHelper.showOptionDialog(this.getParentWindow(), MessageFormat.format(this.messages.getString("AskContinue"), file.getPath()), new String[]{this.messages.getString("ButtonOK"), this.messages.getString("ButtonCancel")}, 3);
        return n == 0;
    }

    protected void addScreenContent(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        jPanel.add((Component)this.progressDisplay, gridBagConstraints);
        ++gridBagConstraints.gridy;
    }

    protected void setupControls() {
        super.setupControls();
        this.progressDisplay = new ProgressDisplay();
        this.progressDisplay.setStatusMessage(this.messages.getString("WizardPreparing"));
        this.btnForward.setVisible(false);
        this.btnPrevious.setVisible(false);
    }

    protected boolean supportsPrevious() {
        return false;
    }
}

