/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.jrobin.core.RrdBackend;
import org.jrobin.core.Util;

public class RrdFileBackend
extends RrdBackend {
    protected boolean readOnly;
    protected RandomAccessFile file;

    protected RrdFileBackend(String string, boolean bl) throws IOException {
        super(string);
        this.readOnly = bl;
        this.file = new RandomAccessFile(string, bl ? "r" : "rw");
    }

    public void close() throws IOException {
        this.file.close();
    }

    public static String getCanonicalPath(String string) throws IOException {
        return Util.getCanonicalPath(string);
    }

    public String getCanonicalPath() throws IOException {
        return RrdFileBackend.getCanonicalPath(this.getPath());
    }

    protected void write(long l, byte[] byArray) throws IOException {
        this.file.seek(l);
        this.file.write(byArray);
    }

    protected void read(long l, byte[] byArray) throws IOException {
        this.file.seek(l);
        if (this.file.read(byArray) != byArray.length) {
            throw new IOException("Not enough bytes available in file " + this.getPath());
        }
    }

    public long getLength() throws IOException {
        return this.file.length();
    }

    protected void setLength(long l) throws IOException {
        this.file.setLength(l);
    }
}

