/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.data.DataProcessor;
import org.jrobin.graph.CommentText;
import org.jrobin.graph.ValueScaler;

class PrintText
extends CommentText {
    static final String UNIT_MARKER = "([^%]?)%(s|S)";
    static final Pattern UNIT_PATTERN = Pattern.compile("([^%]?)%(s|S)");
    private final String srcName;
    private final String consolFun;
    private final boolean includedInGraph;

    PrintText(String string, String string2, String string3, boolean bl) {
        super(string3);
        this.srcName = string;
        this.consolFun = string2;
        this.includedInGraph = bl;
    }

    boolean isPrint() {
        return !this.includedInGraph;
    }

    void resolveText(DataProcessor dataProcessor, ValueScaler valueScaler) throws RrdException {
        super.resolveText(dataProcessor, valueScaler);
        if (this.resolvedText != null) {
            double d = dataProcessor.getAggregate(this.srcName, this.consolFun);
            Matcher matcher = UNIT_PATTERN.matcher(this.resolvedText);
            if (matcher.find()) {
                ValueScaler.Scaled scaled = valueScaler.scale(d, matcher.group(2).equals("s"));
                this.resolvedText = this.resolvedText.substring(0, matcher.start()) + matcher.group(1) + scaled.unit + this.resolvedText.substring(matcher.end());
                d = scaled.value;
            }
            this.resolvedText = Util.sprintf(this.resolvedText, d);
            this.trimIfGlue();
        }
    }
}

