/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.util.Arrays;
import org.jrobin.core.Util;

class Normalizer {
    private final double[] timestamps;
    final int count;
    final double step;

    Normalizer(long l, long l2, int n) {
        this.count = n;
        this.step = (l2 - l) / (long)(n - 1);
        this.timestamps = new double[n];
        for (int i = 0; i < n; ++i) {
            this.timestamps[i] = (double)l + (double)i / (double)(n - 1) * (double)(l2 - l);
        }
    }

    double[] getTimestamps() {
        return this.timestamps;
    }

    double[] normalize(long[] lArray, double[] dArray) {
        int n;
        int n2 = lArray.length;
        long l = lArray[1] - lArray[0];
        if (n2 == this.count && (double)l == this.step && (double)lArray[0] == this.timestamps[0]) {
            return Normalizer.getCopyOf(dArray);
        }
        double[] dArray2 = new double[this.count];
        Arrays.fill(dArray2, Double.NaN);
        int n3 = 0;
        for (n = 0; n < n2 && n3 < this.count; ++n) {
            double d = dArray[n];
            if (Double.isNaN(d)) continue;
            long l2 = lArray[n] - l;
            while (n3 < this.count && (double)l2 >= this.timestamps[n3]) {
                ++n3;
            }
            boolean bl = true;
            for (int i = n3; bl && i < this.count; ++i) {
                double d2;
                double d3 = this.timestamps[i] - this.step;
                double d4 = Math.max((double)l2, d3);
                if (d4 < (d2 = Math.min((double)lArray[n], this.timestamps[i]))) {
                    dArray2[i] = Util.sum(dArray2[i], (d2 - d4) * dArray[n]);
                    continue;
                }
                bl = false;
            }
        }
        n = 0;
        while (n < this.count) {
            int n4 = n++;
            dArray2[n4] = dArray2[n4] / this.step;
        }
        return dArray2;
    }

    private static double[] getCopyOf(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, n);
        return dArray2;
    }
}

