/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core.jrrd;

import java.io.IOException;
import org.jrobin.core.jrrd.Constants;
import org.jrobin.core.jrrd.RRDFile;

public class Header
implements Constants {
    static final long offset = 0L;
    long size;
    String version;
    int dsCount;
    int rraCount;
    int pdpStep;

    Header(RRDFile rRDFile) throws IOException {
        if (!rRDFile.readString(4).equals("RRD")) {
            throw new IOException("Invalid COOKIE");
        }
        this.version = rRDFile.readString(5);
        if (!this.version.equals("0001")) {
            throw new IOException("Unsupported RRD version (" + this.version + ")");
        }
        rRDFile.align();
        rRDFile.readDouble();
        this.dsCount = rRDFile.readInt();
        this.rraCount = rRDFile.readInt();
        this.pdpStep = rRDFile.readInt();
        rRDFile.align();
        rRDFile.skipBytes(80);
        this.size = rRDFile.getFilePointer() - 0L;
    }

    public String getVersion() {
        return this.version;
    }

    public int getDSCount() {
        return this.dsCount;
    }

    public int getRRACount() {
        return this.rraCount;
    }

    public int getPDPStep() {
        return this.pdpStep;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[Header: OFFSET=0x00, SIZE=0x");
        stringBuffer.append(Long.toHexString(this.size));
        stringBuffer.append(", version=");
        stringBuffer.append(this.version);
        stringBuffer.append(", dsCount=");
        stringBuffer.append(this.dsCount);
        stringBuffer.append(", rraCount=");
        stringBuffer.append(this.rraCount);
        stringBuffer.append(", pdpStep=");
        stringBuffer.append(this.pdpStep);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

