/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.jrobin.core.ArcDef;
import org.jrobin.core.DsDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.core.XmlWriter;

public class RrdDef {
    public static final long DEFAULT_STEP = 300L;
    public static final long DEFAULT_INITIAL_SHIFT = -10L;
    private String path;
    private long startTime = Util.getTime() + -10L;
    private long step = 300L;
    private ArrayList<DsDef> dsDefs = new ArrayList();
    private ArrayList<ArcDef> arcDefs = new ArrayList();

    public RrdDef(String string) throws RrdException {
        if (string == null || string.length() == 0) {
            throw new RrdException("No path specified");
        }
        this.path = string;
    }

    public RrdDef(String string, long l) throws RrdException {
        this(string);
        if (l <= 0L) {
            throw new RrdException("Invalid RRD step specified: " + l);
        }
        this.step = l;
    }

    public RrdDef(String string, long l, long l2) throws RrdException {
        this(string, l2);
        if (l < 0L) {
            throw new RrdException("Invalid RRD start time specified: " + l);
        }
        this.startTime = l;
    }

    public String getPath() {
        return this.path;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getStep() {
        return this.step;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public void setStartTime(long l) {
        this.startTime = l;
    }

    public void setStartTime(Date date) {
        this.startTime = Util.getTimestamp(date);
    }

    public void setStartTime(Calendar calendar) {
        this.startTime = Util.getTimestamp(calendar);
    }

    public void setStep(long l) {
        this.step = l;
    }

    public void addDatasource(DsDef dsDef) throws RrdException {
        if (this.dsDefs.contains(dsDef)) {
            throw new RrdException("Datasource already defined: " + dsDef.dump());
        }
        this.dsDefs.add(dsDef);
    }

    public void addDatasource(String string, String string2, long l, double d, double d2) throws RrdException {
        this.addDatasource(new DsDef(string, string2, l, d, d2));
    }

    public void addDatasource(String string) throws RrdException {
        long l;
        RrdException rrdException = new RrdException("Wrong rrdtool-like datasource definition: " + string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.countTokens() != 6) {
            throw rrdException;
        }
        String[] stringArray = new String[6];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        if (!stringArray[0].equalsIgnoreCase("DS")) {
            throw rrdException;
        }
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        try {
            l = Long.parseLong(stringArray[3]);
        }
        catch (NumberFormatException numberFormatException) {
            throw rrdException;
        }
        double d = Double.NaN;
        if (!stringArray[4].equalsIgnoreCase("U")) {
            try {
                d = Double.parseDouble(stringArray[4]);
            }
            catch (NumberFormatException numberFormatException) {
                throw rrdException;
            }
        }
        double d2 = Double.NaN;
        if (!stringArray[5].equalsIgnoreCase("U")) {
            try {
                d2 = Double.parseDouble(stringArray[5]);
            }
            catch (NumberFormatException numberFormatException) {
                throw rrdException;
            }
        }
        this.addDatasource(new DsDef(string2, string3, l, d, d2));
    }

    public void addDatasource(DsDef[] dsDefArray) throws RrdException {
        for (DsDef dsDef : dsDefArray) {
            this.addDatasource(dsDef);
        }
    }

    public void addArchive(ArcDef arcDef) throws RrdException {
        if (this.arcDefs.contains(arcDef)) {
            throw new RrdException("Archive already defined: " + arcDef.dump());
        }
        this.arcDefs.add(arcDef);
    }

    public void addArchive(ArcDef[] arcDefArray) throws RrdException {
        for (ArcDef arcDef : arcDefArray) {
            this.addArchive(arcDef);
        }
    }

    public void addArchive(String string, double d, int n, int n2) throws RrdException {
        this.addArchive(new ArcDef(string, d, n, n2));
    }

    public void addArchive(String string) throws RrdException {
        int n;
        int n2;
        double d;
        RrdException rrdException = new RrdException("Wrong rrdtool-like archive definition: " + string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.countTokens() != 5) {
            throw rrdException;
        }
        String[] stringArray = new String[5];
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n3] = stringTokenizer.nextToken();
            ++n3;
        }
        if (!stringArray[0].equalsIgnoreCase("RRA")) {
            throw rrdException;
        }
        String string2 = stringArray[1];
        try {
            d = Double.parseDouble(stringArray[2]);
        }
        catch (NumberFormatException numberFormatException) {
            throw rrdException;
        }
        try {
            n2 = Integer.parseInt(stringArray[3]);
        }
        catch (NumberFormatException numberFormatException) {
            throw rrdException;
        }
        try {
            n = Integer.parseInt(stringArray[4]);
        }
        catch (NumberFormatException numberFormatException) {
            throw rrdException;
        }
        this.addArchive(new ArcDef(string2, d, n2, n));
    }

    void validate() throws RrdException {
        if (this.dsDefs.size() == 0) {
            throw new RrdException("No RRD datasource specified. At least one is needed.");
        }
        if (this.arcDefs.size() == 0) {
            throw new RrdException("No RRD archive specified. At least one is needed.");
        }
    }

    public DsDef[] getDsDefs() {
        return this.dsDefs.toArray(new DsDef[0]);
    }

    public ArcDef[] getArcDefs() {
        return this.arcDefs.toArray(new ArcDef[0]);
    }

    public int getDsCount() {
        return this.dsDefs.size();
    }

    public int getArcCount() {
        return this.arcDefs.size();
    }

    public String dump() {
        StringBuffer stringBuffer = new StringBuffer("create \"");
        stringBuffer.append(this.path).append("\"");
        stringBuffer.append(" --start ").append(this.getStartTime());
        stringBuffer.append(" --step ").append(this.getStep()).append(" ");
        for (DsDef object : this.dsDefs) {
            stringBuffer.append(object.dump()).append(" ");
        }
        for (ArcDef arcDef : this.arcDefs) {
            stringBuffer.append(arcDef.dump()).append(" ");
        }
        return stringBuffer.toString().trim();
    }

    String getRrdToolCommand() {
        return this.dump();
    }

    void removeDatasource(String string) throws RrdException {
        for (int i = 0; i < this.dsDefs.size(); ++i) {
            DsDef dsDef = this.dsDefs.get(i);
            if (!dsDef.getDsName().equals(string)) continue;
            this.dsDefs.remove(i);
            return;
        }
        throw new RrdException("Could not find datasource named '" + string + "'");
    }

    void saveSingleDatasource(String string) {
        Iterator<DsDef> iterator = this.dsDefs.iterator();
        while (iterator.hasNext()) {
            DsDef dsDef = iterator.next();
            if (dsDef.getDsName().equals(string)) continue;
            iterator.remove();
        }
    }

    void removeArchive(String string, int n) throws RrdException {
        ArcDef arcDef = this.findArchive(string, n);
        if (!this.arcDefs.remove(arcDef)) {
            throw new RrdException("Could not remove archive " + string + "/" + n);
        }
    }

    ArcDef findArchive(String string, int n) throws RrdException {
        for (ArcDef arcDef : this.arcDefs) {
            if (!arcDef.getConsolFun().equals(string) || arcDef.getSteps() != n) continue;
            return arcDef;
        }
        throw new RrdException("Could not find archive " + string + "/" + n);
    }

    public void exportXmlTemplate(OutputStream outputStream) {
        XmlWriter xmlWriter = new XmlWriter(outputStream);
        xmlWriter.startTag("rrd_def");
        xmlWriter.writeTag("path", this.getPath());
        xmlWriter.writeTag("step", this.getStep());
        xmlWriter.writeTag("start", this.getStartTime());
        DsDef[] dsDefArray = this.getDsDefs();
        Object[] objectArray = dsDefArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            DsDef dsDef = objectArray[i];
            xmlWriter.startTag("datasource");
            xmlWriter.writeTag("name", dsDef.getDsName());
            xmlWriter.writeTag("type", dsDef.getDsType());
            xmlWriter.writeTag("heartbeat", dsDef.getHeartbeat());
            xmlWriter.writeTag("min", dsDef.getMinValue(), "U");
            xmlWriter.writeTag("max", dsDef.getMaxValue(), "U");
            xmlWriter.closeTag();
        }
        for (Object object : objectArray = this.getArcDefs()) {
            xmlWriter.startTag("archive");
            xmlWriter.writeTag("cf", ((ArcDef)object).getConsolFun());
            xmlWriter.writeTag("xff", ((ArcDef)object).getXff());
            xmlWriter.writeTag("steps", ((ArcDef)object).getSteps());
            xmlWriter.writeTag("rows", ((ArcDef)object).getRows());
            xmlWriter.closeTag();
        }
        xmlWriter.closeTag();
        xmlWriter.flush();
    }

    public String exportXmlTemplate() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.exportXmlTemplate(byteArrayOutputStream);
        return byteArrayOutputStream.toString();
    }

    public void exportXmlTemplate(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string, false);
        this.exportXmlTemplate(fileOutputStream);
        fileOutputStream.close();
    }

    public long getEstimatedSize() {
        int n = this.dsDefs.size();
        int n2 = this.arcDefs.size();
        int n3 = 0;
        for (ArcDef arcDef : this.arcDefs) {
            n3 += arcDef.getRows();
        }
        return RrdDef.calculateSize(n, n2, n3);
    }

    static long calculateSize(int n, int n2, int n3) {
        return 24L + 48L * (long)n + 16L * (long)n2 + 20L * (long)n * (long)n2 + 8L * (long)n * (long)n3 + (1L + 2L * (long)n + (long)n2) * 2L * 20L;
    }

    public boolean equals(Object object) {
        ArcDef[] arcDefArray;
        DsDef[] dsDefArray;
        if (object == null || !(object instanceof RrdDef)) {
            return false;
        }
        RrdDef rrdDef = (RrdDef)object;
        if (this.step != rrdDef.step) {
            return false;
        }
        DsDef[] dsDefArray2 = this.getDsDefs();
        if (dsDefArray2.length != (dsDefArray = rrdDef.getDsDefs()).length) {
            return false;
        }
        for (DsDef dsDef : dsDefArray2) {
            int n = 0;
            for (DsDef dsDef2 : dsDefArray) {
                if (!dsDef.exactlyEqual(dsDef2)) continue;
                n = 1;
                break;
            }
            if (n != 0) continue;
            return false;
        }
        Object[] objectArray = this.getArcDefs();
        if (objectArray.length != (arcDefArray = rrdDef.getArcDefs()).length) {
            return false;
        }
        for (Object object2 : objectArray) {
            int n = 0;
            for (ArcDef arcDef : arcDefArray) {
                if (!((ArcDef)object2).exactlyEqual(arcDef)) continue;
                n = 1;
                break;
            }
            if (n != 0) continue;
            return false;
        }
        return true;
    }

    public void removeDatasources() {
        this.dsDefs.clear();
    }

    public void removeArchives() {
        this.arcDefs.clear();
    }
}

