/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import org.jrobin.core.DataImporter;
import org.jrobin.core.RrdAllocator;
import org.jrobin.core.RrdBackend;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdInt;
import org.jrobin.core.RrdLong;
import org.jrobin.core.RrdString;
import org.jrobin.core.RrdUpdater;
import org.jrobin.core.Util;
import org.jrobin.core.XmlWriter;

public class Header
implements RrdUpdater {
    static final int SIGNATURE_LENGTH = 2;
    static final String SIGNATURE = "JR";
    static final String DEFAULT_SIGNATURE = "JRobin, version 0.1";
    static final String RRDTOOL_VERSION = "0001";
    private RrdDb parentDb;
    private RrdString signature;
    private RrdLong step;
    private RrdInt dsCount;
    private RrdInt arcCount;
    private RrdLong lastUpdateTime;

    Header(RrdDb rrdDb, RrdDef rrdDef) throws IOException {
        boolean bl = rrdDef != null;
        this.parentDb = rrdDb;
        this.signature = new RrdString(this);
        this.step = new RrdLong(this, true);
        this.dsCount = new RrdInt(this, true);
        this.arcCount = new RrdInt(this, true);
        this.lastUpdateTime = new RrdLong(this);
        if (bl) {
            this.signature.set(DEFAULT_SIGNATURE);
            this.step.set(rrdDef.getStep());
            this.dsCount.set(rrdDef.getDsCount());
            this.arcCount.set(rrdDef.getArcCount());
            this.lastUpdateTime.set(rrdDef.getStartTime());
        }
    }

    Header(RrdDb rrdDb, DataImporter dataImporter) throws IOException, RrdException {
        this(rrdDb, (RrdDef)null);
        String string = dataImporter.getVersion();
        if (!string.equals(RRDTOOL_VERSION)) {
            throw new RrdException("Could not unserilalize xml version " + string);
        }
        this.signature.set(DEFAULT_SIGNATURE);
        this.step.set(dataImporter.getStep());
        this.dsCount.set(dataImporter.getDsCount());
        this.arcCount.set(dataImporter.getArcCount());
        this.lastUpdateTime.set(dataImporter.getLastUpdateTime());
    }

    public String getSignature() throws IOException {
        return this.signature.get();
    }

    public String getInfo() throws IOException {
        return this.getSignature().substring(2);
    }

    public void setInfo(String string) throws IOException {
        if (string != null && string.length() > 0) {
            this.signature.set(SIGNATURE + string);
        } else {
            this.signature.set(SIGNATURE);
        }
    }

    public long getLastUpdateTime() throws IOException {
        return this.lastUpdateTime.get();
    }

    public long getStep() throws IOException {
        return this.step.get();
    }

    public int getDsCount() throws IOException {
        return this.dsCount.get();
    }

    public int getArcCount() throws IOException {
        return this.arcCount.get();
    }

    void setLastUpdateTime(long l) throws IOException {
        this.lastUpdateTime.set(l);
    }

    String dump() throws IOException {
        return "== HEADER ==\nsignature:" + this.getSignature() + " lastUpdateTime:" + this.getLastUpdateTime() + " step:" + this.getStep() + " dsCount:" + this.getDsCount() + " arcCount:" + this.getArcCount() + "\n";
    }

    void appendXml(XmlWriter xmlWriter) throws IOException {
        xmlWriter.writeComment(this.signature.get());
        xmlWriter.writeTag("version", RRDTOOL_VERSION);
        xmlWriter.writeComment("Seconds");
        xmlWriter.writeTag("step", this.step.get());
        xmlWriter.writeComment(Util.getDate(this.lastUpdateTime.get()));
        xmlWriter.writeTag("lastupdate", this.lastUpdateTime.get());
    }

    public void copyStateTo(RrdUpdater rrdUpdater) throws IOException, RrdException {
        if (!(rrdUpdater instanceof Header)) {
            throw new RrdException("Cannot copy Header object to " + rrdUpdater.getClass().getName());
        }
        Header header = (Header)rrdUpdater;
        header.signature.set(this.signature.get());
        header.lastUpdateTime.set(this.lastUpdateTime.get());
    }

    public RrdBackend getRrdBackend() {
        return this.parentDb.getRrdBackend();
    }

    boolean isJRobinHeader() throws IOException {
        return this.signature.get().startsWith(SIGNATURE);
    }

    void validateHeader() throws IOException, RrdException {
        if (!this.isJRobinHeader()) {
            String string = "Invalid file header. File [" + this.parentDb.getCanonicalPath() + "] is not a JRobin RRD file";
            throw new RrdException(string);
        }
    }

    public RrdAllocator getRrdAllocator() {
        return this.parentDb.getRrdAllocator();
    }
}

