/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Anchor;
import com.lowagie.text.Annotation;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.MarkedObject;
import com.lowagie.text.MarkedSection;
import com.lowagie.text.Meta;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Section;
import com.lowagie.text.SimpleTable;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.MultiColumnText;
import com.lowagie.text.pdf.PageResources;
import com.lowagie.text.pdf.PdfAcroForm;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfCell;
import com.lowagie.text.pdf.PdfChunk;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfContents;
import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfFileSpecification;
import com.lowagie.text.pdf.PdfFont;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLine;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNameTree;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPage;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPageLabels;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTable;
import com.lowagie.text.pdf.PdfTextArray;
import com.lowagie.text.pdf.PdfTransition;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.PdfXConformanceException;
import com.lowagie.text.pdf.collection.PdfCollection;
import com.lowagie.text.pdf.internal.PdfAnnotationsImp;
import com.lowagie.text.pdf.internal.PdfViewerPreferencesImp;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

class PdfDocument
extends Document {
    private PdfWriter writer;
    private PdfContentByte text;
    private PdfContentByte graphics;
    private float leading = 0.0f;
    private int alignment = 0;
    private float currentHeight = 0.0f;
    private boolean isParagraph = true;
    private PdfAction anchorAction = null;
    private boolean isNewpage = false;
    private int textEmptySize;
    protected float nextMarginLeft;
    protected float nextMarginRight;
    protected float nextMarginTop;
    protected float nextMarginBottom;
    private boolean firstPageEvent = true;
    private PdfLine line = null;
    private ArrayList lines = new ArrayList();
    private int lastElementType = -1;
    static final String hangingPunctuation = ".,;:'";
    Indentation indentation = new Indentation();
    private PdfInfo info = new PdfInfo();
    private PdfOutline rootOutline;
    private PdfOutline currentOutline;
    protected PdfViewerPreferencesImp viewerPreferences = new PdfViewerPreferencesImp();
    protected PdfPageLabels pageLabels;
    private TreeMap localDestinations = new TreeMap();
    private ArrayList documentJavaScript = new ArrayList();
    private HashMap documentFileAttachment = new HashMap();
    private String openActionName;
    private PdfAction openActionAction;
    private PdfDictionary additionalActions;
    private PdfCollection collection;
    PdfAnnotationsImp annotationsImp;
    protected int markPoint;
    protected Rectangle nextPageSize = null;
    protected HashMap thisBoxSize = new HashMap();
    protected HashMap boxSize = new HashMap();
    private boolean pageEmpty = true;
    protected int duration = -1;
    protected PdfTransition transition = null;
    protected PdfDictionary pageAA = null;
    private PdfIndirectReference thumb;
    protected PageResources pageResources;
    private boolean strictImageSequence = false;
    private float imageEnd = -1.0f;
    private Image imageWait = null;

    public PdfDocument() {
        this.addProducer();
        this.addCreationDate();
    }

    public void addWriter(PdfWriter writer) throws DocumentException {
        if (this.writer == null) {
            this.writer = writer;
            this.annotationsImp = new PdfAnnotationsImp(writer);
            return;
        }
        throw new DocumentException("You can only add a writer to a PdfDocument once.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean add(Element element) throws DocumentException {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        try {
            block2 : switch (element.type()) {
                case 0: {
                    this.info.addkey(((Meta)element).name(), ((Meta)element).content());
                    break;
                }
                case 1: {
                    this.info.addTitle(((Meta)element).content());
                    break;
                }
                case 2: {
                    this.info.addSubject(((Meta)element).content());
                    break;
                }
                case 3: {
                    this.info.addKeywords(((Meta)element).content());
                    break;
                }
                case 4: {
                    this.info.addAuthor(((Meta)element).content());
                    break;
                }
                case 7: {
                    this.info.addCreator(((Meta)element).content());
                    break;
                }
                case 5: {
                    this.info.addProducer();
                    break;
                }
                case 6: {
                    this.info.addCreationDate();
                    break;
                }
                case 10: {
                    if (this.line == null) {
                        this.carriageReturn();
                    }
                    PdfChunk chunk = new PdfChunk((Chunk)element, this.anchorAction);
                    while (true) {
                        PdfChunk overflow;
                        if ((overflow = this.line.add(chunk)) == null) {
                            this.pageEmpty = false;
                            if (!chunk.isAttribute("NEWPAGE")) break block2;
                            this.newPage();
                            break block2;
                        }
                        this.carriageReturn();
                        chunk = overflow;
                        chunk.trimFirstSpace();
                    }
                }
                case 17: {
                    Anchor anchor = (Anchor)element;
                    String url = anchor.reference();
                    this.leading = anchor.leading();
                    if (url != null) {
                        this.anchorAction = new PdfAction(url);
                    }
                    element.process(this);
                    this.anchorAction = null;
                    break;
                }
                case 29: {
                    if (this.line == null) {
                        this.carriageReturn();
                    }
                    Annotation annot = (Annotation)element;
                    Rectangle rect = new Rectangle(0.0f, 0.0f);
                    if (this.line != null) {
                        rect = new Rectangle(annot.llx(this.indentRight() - this.line.widthLeft()), annot.lly(this.indentTop() - this.currentHeight), annot.urx(this.indentRight() - this.line.widthLeft() + 20.0f), annot.ury(this.indentTop() - this.currentHeight - 20.0f));
                    }
                    PdfAnnotation an = PdfAnnotationsImp.convertAnnotation(this.writer, annot, rect);
                    this.annotationsImp.addPlainAnnotation(an);
                    this.pageEmpty = false;
                    break;
                }
                case 11: {
                    this.leading = ((Phrase)element).leading();
                    element.process(this);
                    break;
                }
                case 12: {
                    Paragraph paragraph = (Paragraph)element;
                    this.addSpacing(paragraph.spacingBefore(), this.leading, paragraph.font());
                    this.alignment = paragraph.alignment();
                    this.leading = paragraph.getTotalLeading();
                    this.carriageReturn();
                    if (this.currentHeight + this.line.height() + this.leading > this.indentTop() - this.indentBottom()) {
                        this.newPage();
                    }
                    Indentation indentation = this.indentation;
                    indentation.indentLeft = indentation.indentLeft + paragraph.indentationLeft();
                    Indentation indentation2 = this.indentation;
                    indentation2.indentRight = indentation2.indentRight + paragraph.indentationRight();
                    this.carriageReturn();
                    PdfPageEvent pageEvent = this.writer.getPageEvent();
                    if (pageEvent != null && this.isParagraph) {
                        pageEvent.onParagraph(this.writer, this, this.indentTop() - this.currentHeight);
                    }
                    if (paragraph.getKeepTogether()) {
                        PdfPTable table = new PdfPTable(1);
                        table.setWidthPercentage(100.0f);
                        PdfPCell cell = new PdfPCell();
                        cell.addElement(paragraph);
                        cell.setBorder(0);
                        table.addCell(cell);
                        this.add(table);
                    } else {
                        this.indentation.paragraph += paragraph.indentationLeft();
                        this.line.setExtraIndent(paragraph.getFirstLineIndent());
                        element.process(this);
                        this.indentation.paragraph -= paragraph.indentationLeft();
                    }
                    this.addSpacing(paragraph.spacingAfter(), paragraph.getTotalLeading(), paragraph.font());
                    if (pageEvent != null && this.isParagraph) {
                        pageEvent.onParagraphEnd(this.writer, this, this.indentTop() - this.currentHeight);
                    }
                    this.alignment = 0;
                    Indentation indentation3 = this.indentation;
                    indentation3.indentLeft = indentation3.indentLeft - paragraph.indentationLeft();
                    Indentation indentation4 = this.indentation;
                    indentation4.indentRight = indentation4.indentRight - paragraph.indentationRight();
                    this.carriageReturn();
                    break;
                }
                case 13: 
                case 16: {
                    boolean hasTitle;
                    Section section = (Section)element;
                    boolean bl = hasTitle = section.title() != null;
                    if (section.isTriggerNewPage()) {
                        this.newPage();
                    } else {
                        this.newLine();
                    }
                    if (hasTitle) {
                        float fith = this.indentTop() - this.currentHeight;
                        int rotation = this.pageSize.getRotation();
                        if (rotation == 90 || rotation == 180) {
                            fith = this.pageSize.height() - fith;
                        }
                        PdfDestination destination = new PdfDestination(2, fith);
                        while (true) {
                            if (this.currentOutline.level() < section.depth()) {
                                PdfOutline outline;
                                this.currentOutline = outline = new PdfOutline(this.currentOutline, destination, section.getBookmarkTitle(), section.isBookmarkOpen());
                                break;
                            }
                            this.currentOutline = this.currentOutline.parent();
                        }
                    }
                    this.carriageReturn();
                    Indentation indentation = this.indentation;
                    indentation.indentLeft = indentation.indentLeft + section.indentationLeft();
                    Indentation indentation5 = this.indentation;
                    indentation5.indentRight = indentation5.indentRight + section.indentationRight();
                    Indentation indentation6 = this.indentation;
                    indentation6.sectionIndentLeft = indentation6.sectionIndentLeft + section.indentationLeft();
                    Indentation indentation7 = this.indentation;
                    indentation7.sectionIndentRight = indentation7.sectionIndentRight + section.indentationRight();
                    PdfPageEvent pageEvent = this.writer.getPageEvent();
                    if (pageEvent != null) {
                        if (element.type() == 16) {
                            pageEvent.onChapter(this.writer, this, this.indentTop() - this.currentHeight, section.title());
                        } else {
                            pageEvent.onSection(this.writer, this, this.indentTop() - this.currentHeight, section.depth(), section.title());
                        }
                    }
                    if (hasTitle) {
                        this.isParagraph = false;
                        this.add(section.title());
                        this.isParagraph = true;
                    }
                    Indentation indentation8 = this.indentation;
                    indentation8.indentLeft = indentation8.indentLeft + section.indentation();
                    Indentation indentation9 = this.indentation;
                    indentation9.sectionIndentLeft = indentation9.sectionIndentLeft + section.indentation();
                    element.process(this);
                    Indentation indentation10 = this.indentation;
                    indentation10.indentLeft = indentation10.indentLeft - (section.indentationLeft() + section.indentation());
                    Indentation indentation11 = this.indentation;
                    indentation11.indentRight = indentation11.indentRight - section.indentationRight();
                    Indentation indentation12 = this.indentation;
                    indentation12.sectionIndentLeft = indentation12.sectionIndentLeft - (section.indentationLeft() + section.indentation());
                    Indentation indentation13 = this.indentation;
                    indentation13.sectionIndentRight = indentation13.sectionIndentRight - section.indentationRight();
                    if (pageEvent == null) break;
                    if (element.type() == 16) {
                        pageEvent.onChapterEnd(this.writer, this, this.indentTop() - this.currentHeight);
                        break;
                    }
                    pageEvent.onSectionEnd(this.writer, this, this.indentTop() - this.currentHeight);
                    break;
                }
                case 14: {
                    List list = (List)element;
                    if (list.isAlignindent()) {
                        list.normalizeIndentation();
                    }
                    Indentation indentation = this.indentation;
                    indentation.listIndentLeft = indentation.listIndentLeft + list.indentationLeft();
                    Indentation indentation14 = this.indentation;
                    indentation14.indentRight = indentation14.indentRight + list.indentationRight();
                    element.process(this);
                    Indentation indentation15 = this.indentation;
                    indentation15.listIndentLeft = indentation15.listIndentLeft - list.indentationLeft();
                    Indentation indentation16 = this.indentation;
                    indentation16.indentRight = indentation16.indentRight - list.indentationRight();
                    break;
                }
                case 15: {
                    ListItem listItem = (ListItem)element;
                    this.addSpacing(listItem.spacingBefore(), this.leading, listItem.font());
                    this.alignment = listItem.alignment();
                    Indentation indentation = this.indentation;
                    indentation.listIndentLeft = indentation.listIndentLeft + listItem.indentationLeft();
                    Indentation indentation17 = this.indentation;
                    indentation17.indentRight = indentation17.indentRight + listItem.indentationRight();
                    this.leading = listItem.getTotalLeading();
                    this.carriageReturn();
                    this.line.setListItem(listItem);
                    element.process(this);
                    this.addSpacing(listItem.spacingAfter(), listItem.getTotalLeading(), listItem.font());
                    if (this.line.hasToBeJustified()) {
                        this.line.resetAlignment();
                    }
                    this.carriageReturn();
                    Indentation indentation18 = this.indentation;
                    indentation18.listIndentLeft = indentation18.listIndentLeft - listItem.indentationLeft();
                    Indentation indentation19 = this.indentation;
                    indentation19.indentRight = indentation19.indentRight - listItem.indentationRight();
                    break;
                }
                case 30: {
                    Rectangle rectangle = (Rectangle)element;
                    this.graphics.rectangle(rectangle);
                    this.pageEmpty = false;
                    break;
                }
                case 23: {
                    PdfPTable ptable = (PdfPTable)element;
                    if (ptable.size() <= ptable.getHeaderRows()) break;
                    Indentation indentation = this.indentation;
                    indentation.indentLeft = indentation.indentLeft - (this.indentation.paragraph + this.indentation.sectionIndentLeft);
                    Indentation indentation20 = this.indentation;
                    indentation20.indentRight = indentation20.indentRight - this.indentation.sectionIndentRight;
                    this.ensureNewLine();
                    this.flushLines();
                    Indentation indentation21 = this.indentation;
                    indentation21.indentLeft = indentation21.indentLeft + (this.indentation.paragraph + this.indentation.sectionIndentLeft);
                    Indentation indentation22 = this.indentation;
                    indentation22.indentRight = indentation22.indentRight + this.indentation.sectionIndentRight;
                    this.addPTable(ptable);
                    this.pageEmpty = false;
                    this.newLine();
                    break;
                }
                case 40: {
                    this.ensureNewLine();
                    this.flushLines();
                    MultiColumnText multiText = (MultiColumnText)element;
                    float height = multiText.write(this.writer.getDirectContent(), this, this.indentTop() - this.currentHeight);
                    this.currentHeight += height;
                    this.text.moveText(0.0f, -1.0f * height);
                    this.pageEmpty = false;
                    break;
                }
                case 22: {
                    PdfTable table;
                    if (element instanceof PdfTable) {
                        table = (PdfTable)element;
                        table.updateRowAdditions();
                    } else {
                        if (element instanceof SimpleTable) {
                            PdfPTable ptable = ((SimpleTable)element).createPdfPTable();
                            if (ptable.size() <= ptable.getHeaderRows()) break;
                            this.ensureNewLine();
                            this.flushLines();
                            this.addPTable(ptable);
                            this.pageEmpty = false;
                            break;
                        }
                        if (!(element instanceof Table)) {
                            return false;
                        }
                        try {
                            PdfPTable ptable = ((Table)element).createPdfPTable();
                            if (ptable.size() <= ptable.getHeaderRows()) break;
                            this.ensureNewLine();
                            this.flushLines();
                            this.addPTable(ptable);
                            this.pageEmpty = false;
                            break;
                        }
                        catch (BadElementException bee) {
                            float offset = ((Table)element).getOffset();
                            if (Float.isNaN(offset)) {
                                offset = this.leading;
                            }
                            this.carriageReturn();
                            this.lines.add(new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, offset));
                            this.currentHeight += offset;
                            table = this.getPdfTable((Table)element, false);
                        }
                    }
                    this.add(table, false);
                    break;
                }
                case 32: 
                case 34: 
                case 35: {
                    this.add((Image)element);
                    break;
                }
                case 50: {
                    MarkedObject mo;
                    if (element instanceof MarkedSection && (mo = ((MarkedSection)element).title()) != null) {
                        mo.process(this);
                    }
                    mo = (MarkedObject)element;
                    mo.process(this);
                    break;
                }
                default: {
                    return false;
                }
            }
            this.lastElementType = element.type();
            return true;
        }
        catch (Exception e) {
            throw new DocumentException(e);
        }
    }

    public void open() {
        if (!this.open) {
            super.open();
            this.writer.open();
            this.currentOutline = this.rootOutline = new PdfOutline(this.writer);
        }
        try {
            this.initPage();
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
    }

    public void close() {
        if (this.close) {
            return;
        }
        try {
            boolean wasImage = this.imageWait != null;
            this.newPage();
            if (this.imageWait != null || wasImage) {
                this.newPage();
            }
            if (this.annotationsImp.hasUnusedAnnotations()) {
                throw new RuntimeException("Not all annotations could be added to the document (the document doesn't have enough pages).");
            }
            PdfPageEvent pageEvent = this.writer.getPageEvent();
            if (pageEvent != null) {
                pageEvent.onCloseDocument(this.writer, this);
            }
            super.close();
            this.writer.addLocalDestinations(this.localDestinations);
            this.calculateOutlineCount();
            this.writeOutlines();
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
        this.writer.close();
    }

    public boolean newPage() {
        this.lastElementType = -1;
        this.isNewpage = true;
        if (this.writer == null || this.writer.getDirectContent().size() == 0 && this.writer.getDirectContentUnder().size() == 0 && (this.pageEmpty || this.writer.isPaused())) {
            return false;
        }
        if (!this.open || this.close) {
            throw new RuntimeException("The document isn't open.");
        }
        PdfPageEvent pageEvent = this.writer.getPageEvent();
        if (pageEvent != null) {
            pageEvent.onEndPage(this.writer, this);
        }
        super.newPage();
        this.indentation.imageIndentLeft = 0.0f;
        this.indentation.imageIndentRight = 0.0f;
        try {
            PdfArray array;
            this.flushLines();
            int rotation = this.pageSize.getRotation();
            if (this.writer.isPdfX()) {
                if (this.thisBoxSize.containsKey("art") && this.thisBoxSize.containsKey("trim")) {
                    throw new PdfXConformanceException("Only one of ArtBox or TrimBox can exist in the page.");
                }
                if (!this.thisBoxSize.containsKey("art") && !this.thisBoxSize.containsKey("trim")) {
                    if (this.thisBoxSize.containsKey("crop")) {
                        this.thisBoxSize.put("trim", this.thisBoxSize.get("crop"));
                    } else {
                        this.thisBoxSize.put("trim", new PdfRectangle(this.pageSize, this.pageSize.getRotation()));
                    }
                }
            }
            this.pageResources.addDefaultColorDiff(this.writer.getDefaultColorspace());
            PdfDictionary resources = this.pageResources.getResources();
            PdfPage page = new PdfPage(new PdfRectangle(this.pageSize, rotation), this.thisBoxSize, resources, rotation);
            if (this.transition != null) {
                page.put(PdfName.TRANS, this.transition.getTransitionDictionary());
                this.transition = null;
            }
            if (this.duration > 0) {
                page.put(PdfName.DUR, new PdfNumber(this.duration));
                this.duration = 0;
            }
            if (this.pageAA != null) {
                page.put(PdfName.AA, this.writer.addToBody(this.pageAA).getIndirectReference());
                this.pageAA = null;
            }
            if (this.thumb != null) {
                page.put(PdfName.THUMB, this.thumb);
                this.thumb = null;
            }
            if (this.writer.getUserunit() > 0.0f) {
                page.put(PdfName.USERUNIT, new PdfNumber(this.writer.getUserunit()));
            }
            if (this.annotationsImp.hasUnusedAnnotations() && (array = this.annotationsImp.rotateAnnotations(this.writer, this.pageSize)).size() != 0) {
                page.put(PdfName.ANNOTS, array);
            }
            if (this.writer.isTagged()) {
                page.put(PdfName.STRUCTPARENTS, new PdfNumber(this.writer.getCurrentPageNumber() - 1));
            }
            if (this.text.size() > this.textEmptySize) {
                this.text.endText();
            } else {
                this.text = null;
            }
            this.writer.add(page, new PdfContents(this.writer.getDirectContentUnder(), this.graphics, this.text, this.writer.getDirectContent(), this.pageSize));
            this.initPage();
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
        catch (IOException ioe) {
            throw new ExceptionConverter(ioe);
        }
        this.isNewpage = false;
        return true;
    }

    public boolean setPageSize(Rectangle pageSize) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        this.nextPageSize = new Rectangle(pageSize);
        return true;
    }

    public boolean setMargins(float marginLeft, float marginRight, float marginTop, float marginBottom) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        this.nextMarginLeft = marginLeft;
        this.nextMarginRight = marginRight;
        this.nextMarginTop = marginTop;
        this.nextMarginBottom = marginBottom;
        return true;
    }

    public boolean setMarginMirroring(boolean MarginMirroring) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        return super.setMarginMirroring(MarginMirroring);
    }

    public void setPageCount(int pageN) {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.setPageCount(pageN);
    }

    public void resetPageCount() {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.resetPageCount();
    }

    public void setHeader(HeaderFooter header) {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.setHeader(header);
    }

    public void resetHeader() {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.resetHeader();
    }

    public void setFooter(HeaderFooter footer) {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.setFooter(footer);
    }

    public void resetFooter() {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.resetFooter();
    }

    private void initPage() throws DocumentException {
        ++this.pageN;
        this.annotationsImp.resetAnnotations();
        this.pageResources = new PageResources();
        this.writer.resetContent();
        this.graphics = new PdfContentByte(this.writer);
        this.text = new PdfContentByte(this.writer);
        this.text.reset();
        this.text.beginText();
        this.textEmptySize = this.text.size();
        this.markPoint = 0;
        if (this.marginMirroring && (this.getPageNumber() & 1) == 0) {
            this.marginRight = this.nextMarginLeft;
            this.marginLeft = this.nextMarginRight;
        } else {
            this.marginLeft = this.nextMarginLeft;
            this.marginRight = this.nextMarginRight;
        }
        this.marginTop = this.nextMarginTop;
        this.marginBottom = this.nextMarginBottom;
        this.imageEnd = -1.0f;
        this.indentation.imageIndentRight = 0.0f;
        this.indentation.imageIndentLeft = 0.0f;
        this.indentation.indentBottom = 0.0f;
        this.indentation.indentTop = 0.0f;
        this.currentHeight = 0.0f;
        this.pageSize = this.nextPageSize;
        this.thisBoxSize = new HashMap(this.boxSize);
        if (this.pageSize.backgroundColor() != null || this.pageSize.hasBorders() || this.pageSize.borderColor() != null) {
            this.add(this.pageSize);
        }
        float oldleading = this.leading;
        int oldAlignment = this.alignment;
        this.doFooter();
        this.text.moveText(this.left(), this.top());
        this.doHeader();
        this.pageEmpty = true;
        try {
            if (this.imageWait != null) {
                this.add(this.imageWait);
                this.imageWait = null;
            }
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
        this.leading = oldleading;
        this.alignment = oldAlignment;
        this.carriageReturn();
        PdfPageEvent pageEvent = this.writer.getPageEvent();
        if (pageEvent != null) {
            if (this.firstPageEvent) {
                pageEvent.onOpenDocument(this.writer, this);
            }
            pageEvent.onStartPage(this.writer, this);
        }
        this.firstPageEvent = false;
    }

    private void newLine() throws DocumentException {
        this.lastElementType = -1;
        this.carriageReturn();
        if (this.lines != null && !this.lines.isEmpty()) {
            this.lines.add(this.line);
            this.currentHeight += this.line.height();
        }
        this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
    }

    private void carriageReturn() {
        if (this.lines == null) {
            this.lines = new ArrayList();
        }
        if (this.line != null) {
            if (this.currentHeight + this.line.height() + this.leading < this.indentTop() - this.indentBottom()) {
                if (this.line.size() > 0) {
                    this.currentHeight += this.line.height();
                    this.lines.add(this.line);
                    this.pageEmpty = false;
                }
            } else {
                this.newPage();
            }
        }
        if (this.imageEnd > -1.0f && this.currentHeight > this.imageEnd) {
            this.imageEnd = -1.0f;
            this.indentation.imageIndentRight = 0.0f;
            this.indentation.imageIndentLeft = 0.0f;
        }
        this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
    }

    public float getVerticalPosition(boolean ensureNewLine) {
        if (ensureNewLine) {
            this.ensureNewLine();
        }
        return this.top() - this.currentHeight - this.indentation.indentTop;
    }

    private void ensureNewLine() {
        try {
            if (this.lastElementType == 11 || this.lastElementType == 10) {
                this.newLine();
                this.flushLines();
            }
        }
        catch (DocumentException ex) {
            throw new ExceptionConverter(ex);
        }
    }

    private float flushLines() throws DocumentException {
        if (this.lines == null) {
            return 0.0f;
        }
        boolean newline = false;
        if (this.line != null && this.line.size() > 0) {
            this.lines.add(this.line);
            this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
            newline = true;
        }
        if (this.lines.isEmpty()) {
            return 0.0f;
        }
        Object[] currentValues = new Object[2];
        PdfFont currentFont = null;
        float displacement = 0.0f;
        Float lastBaseFactor = new Float(0.0f);
        currentValues[1] = lastBaseFactor;
        Iterator i = this.lines.iterator();
        while (i.hasNext()) {
            PdfLine l = (PdfLine)i.next();
            if (this.isNewpage && newline) {
                newline = false;
                this.text.moveText(l.indentLeft() - this.indentLeft() + this.indentation.listIndentLeft + this.indentation.paragraph, -l.height());
            } else {
                this.text.moveText(l.indentLeft() - this.indentLeft() + this.indentation.listIndentLeft, -l.height());
            }
            if (l.listSymbol() != null) {
                ColumnText.showTextAligned(this.graphics, 0, new Phrase(l.listSymbol()), this.text.getXTLM() - l.listIndent(), this.text.getYTLM(), 0.0f);
            }
            currentValues[0] = currentFont;
            this.writeLineToContent(l, this.text, this.graphics, currentValues, this.writer.getSpaceCharRatio());
            currentFont = (PdfFont)currentValues[0];
            displacement += l.height();
            if (this.indentLeft() - this.indentation.listIndentLeft == l.indentLeft()) continue;
            this.text.moveText(this.indentLeft() - l.indentLeft() - this.indentation.listIndentLeft, 0.0f);
        }
        this.lines = new ArrayList();
        return displacement;
    }

    void writeLineToContent(PdfLine line, PdfContentByte text, PdfContentByte graphics, Object[] currentValues, float ratio) throws DocumentException {
        float xMarker;
        boolean isJustified;
        PdfFont currentFont = (PdfFont)currentValues[0];
        float lastBaseFactor = ((Float)currentValues[1]).floatValue();
        float hangingCorrection = 0.0f;
        float hScale = 1.0f;
        float lastHScale = Float.NaN;
        float baseWordSpacing = 0.0f;
        float baseCharacterSpacing = 0.0f;
        int numberOfSpaces = line.numberOfSpaces();
        int lineLen = line.toString().length();
        boolean bl = isJustified = line.hasToBeJustified() && (numberOfSpaces != 0 || lineLen > 1);
        if (isJustified) {
            if (line.isNewlineSplit() && line.widthLeft() >= lastBaseFactor * (ratio * (float)numberOfSpaces + (float)lineLen - 1.0f)) {
                if (line.isRTL()) {
                    text.moveText(line.widthLeft() - lastBaseFactor * (ratio * (float)numberOfSpaces + (float)lineLen - 1.0f), 0.0f);
                }
                baseWordSpacing = ratio * lastBaseFactor;
                baseCharacterSpacing = lastBaseFactor;
            } else {
                char c;
                String s;
                float width = line.widthLeft();
                PdfChunk last = line.getChunk(line.size() - 1);
                if (last != null && (s = last.toString()).length() > 0 && hangingPunctuation.indexOf(c = s.charAt(s.length() - 1)) >= 0) {
                    float oldWidth = width;
                    hangingCorrection = (width += last.font().width(c) * 0.4f) - oldWidth;
                }
                float baseFactor = width / (ratio * (float)numberOfSpaces + (float)lineLen - 1.0f);
                baseWordSpacing = ratio * baseFactor;
                baseCharacterSpacing = baseFactor;
                lastBaseFactor = baseFactor;
            }
        }
        int lastChunkStroke = line.getLastStrokeChunk();
        int chunkStrokeIdx = 0;
        float baseXMarker = xMarker = text.getXTLM();
        float yMarker = text.getYTLM();
        boolean adjustMatrix = false;
        Iterator j = line.iterator();
        while (j.hasNext()) {
            PdfChunk chunk = (PdfChunk)j.next();
            Color color = chunk.color();
            hScale = 1.0f;
            if (chunkStrokeIdx <= lastChunkStroke) {
                float width = isJustified ? chunk.getWidthCorrected(baseCharacterSpacing, baseWordSpacing) : chunk.width();
                if (chunk.isStroked()) {
                    float descender;
                    float ascender;
                    float subtract;
                    PdfChunk nextChunk = line.getChunk(chunkStrokeIdx + 1);
                    if (chunk.isAttribute("BACKGROUND")) {
                        subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("BACKGROUND")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        float fontSize = chunk.font().size();
                        ascender = chunk.font().getFont().getFontDescriptor(1, fontSize);
                        descender = chunk.font().getFont().getFontDescriptor(3, fontSize);
                        Object[] bgr = (Object[])chunk.getAttribute("BACKGROUND");
                        graphics.setColorFill((Color)bgr[0]);
                        float[] extra = (float[])bgr[1];
                        graphics.rectangle(xMarker - extra[0], yMarker + descender - extra[1] + chunk.getTextRise(), width - subtract + extra[0] + extra[2], ascender - descender + extra[1] + extra[3]);
                        graphics.fill();
                        graphics.setGrayFill(0.0f);
                    }
                    if (chunk.isAttribute("UNDERLINE")) {
                        subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("UNDERLINE")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        Object[][] unders = (Object[][])chunk.getAttribute("UNDERLINE");
                        Color scolor = null;
                        int k = 0;
                        while (k < unders.length) {
                            Object[] obj = unders[k];
                            scolor = (Color)obj[0];
                            float[] ps = (float[])obj[1];
                            if (scolor == null) {
                                scolor = color;
                            }
                            if (scolor != null) {
                                graphics.setColorStroke(scolor);
                            }
                            float fsize = chunk.font().size();
                            graphics.setLineWidth(ps[0] + fsize * ps[1]);
                            float shift = ps[2] + fsize * ps[3];
                            int cap2 = (int)ps[4];
                            if (cap2 != 0) {
                                graphics.setLineCap(cap2);
                            }
                            graphics.moveTo(xMarker, yMarker + shift);
                            graphics.lineTo(xMarker + width - subtract, yMarker + shift);
                            graphics.stroke();
                            if (scolor != null) {
                                graphics.resetGrayStroke();
                            }
                            if (cap2 != 0) {
                                graphics.setLineCap(0);
                            }
                            ++k;
                        }
                        graphics.setLineWidth(1.0f);
                    }
                    if (chunk.isAttribute("ACTION")) {
                        subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("ACTION")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        text.addAnnotation(new PdfAnnotation(this.writer, xMarker, yMarker, xMarker + width - subtract, yMarker + chunk.font().size(), (PdfAction)chunk.getAttribute("ACTION")));
                    }
                    if (chunk.isAttribute("REMOTEGOTO")) {
                        subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("REMOTEGOTO")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        Object[] obj = (Object[])chunk.getAttribute("REMOTEGOTO");
                        String filename = (String)obj[0];
                        if (obj[1] instanceof String) {
                            this.remoteGoto(filename, (String)obj[1], xMarker, yMarker, xMarker + width - subtract, yMarker + chunk.font().size());
                        } else {
                            this.remoteGoto(filename, (Integer)obj[1], xMarker, yMarker, xMarker + width - subtract, yMarker + chunk.font().size());
                        }
                    }
                    if (chunk.isAttribute("LOCALGOTO")) {
                        subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("LOCALGOTO")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        this.localGoto((String)chunk.getAttribute("LOCALGOTO"), xMarker, yMarker, xMarker + width - subtract, yMarker + chunk.font().size());
                    }
                    if (chunk.isAttribute("LOCALDESTINATION")) {
                        subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("LOCALDESTINATION")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        this.localDestination((String)chunk.getAttribute("LOCALDESTINATION"), new PdfDestination(0, xMarker, yMarker + chunk.font().size(), 0.0f));
                    }
                    if (chunk.isAttribute("GENERICTAG")) {
                        subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("GENERICTAG")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        Rectangle rect = new Rectangle(xMarker, yMarker, xMarker + width - subtract, yMarker + chunk.font().size());
                        PdfPageEvent pev = this.writer.getPageEvent();
                        if (pev != null) {
                            pev.onGenericTag(this.writer, this, rect, (String)chunk.getAttribute("GENERICTAG"));
                        }
                    }
                    if (chunk.isAttribute("PDFANNOTATION")) {
                        subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("PDFANNOTATION")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        float fontSize = chunk.font().size();
                        ascender = chunk.font().getFont().getFontDescriptor(1, fontSize);
                        descender = chunk.font().getFont().getFontDescriptor(3, fontSize);
                        PdfAnnotation annot = PdfFormField.shallowDuplicate((PdfAnnotation)chunk.getAttribute("PDFANNOTATION"));
                        annot.put(PdfName.RECT, new PdfRectangle(xMarker, yMarker + descender, xMarker + width - subtract, yMarker + ascender));
                        text.addAnnotation(annot);
                    }
                    float[] params = (float[])chunk.getAttribute("SKEW");
                    Float hs = (Float)chunk.getAttribute("HSCALE");
                    if (params != null || hs != null) {
                        float b = 0.0f;
                        float c = 0.0f;
                        if (params != null) {
                            b = params[0];
                            c = params[1];
                        }
                        if (hs != null) {
                            hScale = hs.floatValue();
                        }
                        text.setTextMatrix(hScale, b, c, 1.0f, xMarker, yMarker);
                    }
                    if (chunk.isImage()) {
                        Image image = chunk.getImage();
                        float[] matrix = image.matrix();
                        matrix[4] = xMarker + chunk.getImageOffsetX() - matrix[4];
                        matrix[5] = yMarker + chunk.getImageOffsetY() - matrix[5];
                        graphics.addImage(image, matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5]);
                        text.moveText(xMarker + lastBaseFactor + image.scaledWidth() - text.getXTLM(), 0.0f);
                    }
                }
                xMarker += width;
                ++chunkStrokeIdx;
            }
            if (chunk.font().compareTo(currentFont) != 0) {
                currentFont = chunk.font();
                text.setFontAndSize(currentFont.getFont(), currentFont.size());
            }
            float rise = 0.0f;
            Object[] textRender = (Object[])chunk.getAttribute("TEXTRENDERMODE");
            int tr = 0;
            float strokeWidth = 1.0f;
            Color strokeColor = null;
            Float fr = (Float)chunk.getAttribute("SUBSUPSCRIPT");
            if (textRender != null) {
                tr = (Integer)textRender[0] & 3;
                if (tr != 0) {
                    text.setTextRenderingMode(tr);
                }
                if (tr == 1 || tr == 2) {
                    strokeWidth = ((Float)textRender[1]).floatValue();
                    if (strokeWidth != 1.0f) {
                        text.setLineWidth(strokeWidth);
                    }
                    if ((strokeColor = (Color)textRender[2]) == null) {
                        strokeColor = color;
                    }
                    if (strokeColor != null) {
                        text.setColorStroke(strokeColor);
                    }
                }
            }
            if (fr != null) {
                rise = fr.floatValue();
            }
            if (color != null) {
                text.setColorFill(color);
            }
            if (rise != 0.0f) {
                text.setTextRise(rise);
            }
            if (chunk.isImage()) {
                adjustMatrix = true;
            } else if (isJustified && numberOfSpaces > 0 && chunk.isSpecialEncoding()) {
                String s;
                int idx;
                if (hScale != lastHScale) {
                    lastHScale = hScale;
                    text.setWordSpacing(baseWordSpacing / hScale);
                    text.setCharacterSpacing(baseCharacterSpacing / hScale);
                }
                if ((idx = (s = chunk.toString()).indexOf(32)) < 0) {
                    text.showText(chunk.toString());
                } else {
                    float spaceCorrection = -baseWordSpacing * 1000.0f / chunk.font.size() / hScale;
                    PdfTextArray textArray = new PdfTextArray(s.substring(0, idx));
                    int lastIdx = idx;
                    while ((idx = s.indexOf(32, lastIdx + 1)) >= 0) {
                        textArray.add(spaceCorrection);
                        textArray.add(s.substring(lastIdx, idx));
                        lastIdx = idx;
                    }
                    textArray.add(spaceCorrection);
                    textArray.add(s.substring(lastIdx));
                    text.showText(textArray);
                }
            } else {
                if (isJustified && hScale != lastHScale) {
                    lastHScale = hScale;
                    text.setWordSpacing(baseWordSpacing / hScale);
                    text.setCharacterSpacing(baseCharacterSpacing / hScale);
                }
                text.showText(chunk.toString());
            }
            if (rise != 0.0f) {
                text.setTextRise(0.0f);
            }
            if (color != null) {
                text.resetRGBColorFill();
            }
            if (tr != 0) {
                text.setTextRenderingMode(0);
            }
            if (strokeColor != null) {
                text.resetRGBColorStroke();
            }
            if (strokeWidth != 1.0f) {
                text.setLineWidth(1.0f);
            }
            if (!chunk.isAttribute("SKEW") && !chunk.isAttribute("HSCALE")) continue;
            adjustMatrix = true;
            text.setTextMatrix(xMarker, yMarker);
        }
        if (isJustified) {
            text.setWordSpacing(0.0f);
            text.setCharacterSpacing(0.0f);
            if (line.isNewlineSplit()) {
                lastBaseFactor = 0.0f;
            }
        }
        if (adjustMatrix) {
            text.moveText(baseXMarker - text.getXTLM(), 0.0f);
        }
        currentValues[0] = currentFont;
        currentValues[1] = new Float(lastBaseFactor);
    }

    private float indentLeft() {
        return this.left(this.indentation.indentLeft + this.indentation.listIndentLeft + this.indentation.imageIndentLeft);
    }

    private float indentRight() {
        return this.right(this.indentation.indentRight + this.indentation.imageIndentRight);
    }

    private float indentTop() {
        return this.top(this.indentation.indentTop);
    }

    float indentBottom() {
        return this.bottom(this.indentation.indentBottom);
    }

    private void addSpacing(float extraspace, float oldleading, Font f) {
        if (extraspace == 0.0f) {
            return;
        }
        if (this.pageEmpty) {
            return;
        }
        if (this.currentHeight + this.line.height() + this.leading > this.indentTop() - this.indentBottom()) {
            return;
        }
        this.leading = extraspace;
        this.carriageReturn();
        Chunk space = new Chunk(" ", f);
        space.process(this);
        this.carriageReturn();
        this.leading = oldleading;
    }

    PdfInfo getInfo() {
        return this.info;
    }

    PdfCatalog getCatalog(PdfIndirectReference pages) {
        PdfCatalog catalog = new PdfCatalog(pages, this.writer);
        if (this.rootOutline.getKids().size() > 0) {
            catalog.put(PdfName.PAGEMODE, PdfName.USEOUTLINES);
            catalog.put(PdfName.OUTLINES, this.rootOutline.indirectReference());
        }
        this.writer.getPdfVersion().addToCatalog(catalog);
        this.viewerPreferences.addToCatalog(catalog);
        if (this.pageLabels != null) {
            catalog.put(PdfName.PAGELABELS, this.pageLabels.getDictionary());
        }
        catalog.addNames(this.localDestinations, this.documentJavaScript, this.documentFileAttachment, this.writer);
        if (this.openActionName != null) {
            PdfAction action = this.getLocalGotoAction(this.openActionName);
            catalog.setOpenAction(action);
        } else if (this.openActionAction != null) {
            catalog.setOpenAction(this.openActionAction);
        }
        if (this.additionalActions != null) {
            catalog.setAdditionalActions(this.additionalActions);
        }
        if (this.collection != null) {
            catalog.put(PdfName.COLLECTION, this.collection);
        }
        if (this.annotationsImp.hasValidAcroForm()) {
            try {
                catalog.put(PdfName.ACROFORM, this.writer.addToBody(this.annotationsImp.getAcroForm()).getIndirectReference());
            }
            catch (IOException e) {
                throw new ExceptionConverter(e);
            }
        }
        return catalog;
    }

    void addOutline(PdfOutline outline, String name) {
        this.localDestination(name, outline.getPdfDestination());
    }

    public PdfOutline getRootOutline() {
        return this.rootOutline;
    }

    void calculateOutlineCount() {
        if (this.rootOutline.getKids().size() == 0) {
            return;
        }
        this.traverseOutlineCount(this.rootOutline);
    }

    void traverseOutlineCount(PdfOutline outline) {
        ArrayList kids = outline.getKids();
        PdfOutline parent = outline.parent();
        if (kids.isEmpty()) {
            if (parent != null) {
                parent.setCount(parent.getCount() + 1);
            }
        } else {
            int k = 0;
            while (k < kids.size()) {
                this.traverseOutlineCount((PdfOutline)kids.get(k));
                ++k;
            }
            if (parent != null) {
                if (outline.isOpen()) {
                    parent.setCount(outline.getCount() + parent.getCount() + 1);
                } else {
                    parent.setCount(parent.getCount() + 1);
                    outline.setCount(-outline.getCount());
                }
            }
        }
    }

    void writeOutlines() throws IOException {
        if (this.rootOutline.getKids().size() == 0) {
            return;
        }
        this.outlineTree(this.rootOutline);
        this.writer.addToBody((PdfObject)this.rootOutline, this.rootOutline.indirectReference());
    }

    void outlineTree(PdfOutline outline) throws IOException {
        outline.setIndirectReference(this.writer.getPdfIndirectReference());
        if (outline.parent() != null) {
            outline.put(PdfName.PARENT, outline.parent().indirectReference());
        }
        ArrayList kids = outline.getKids();
        int size = kids.size();
        int k = 0;
        while (k < size) {
            this.outlineTree((PdfOutline)kids.get(k));
            ++k;
        }
        k = 0;
        while (k < size) {
            if (k > 0) {
                ((PdfOutline)kids.get(k)).put(PdfName.PREV, ((PdfOutline)kids.get(k - 1)).indirectReference());
            }
            if (k < size - 1) {
                ((PdfOutline)kids.get(k)).put(PdfName.NEXT, ((PdfOutline)kids.get(k + 1)).indirectReference());
            }
            ++k;
        }
        if (size > 0) {
            outline.put(PdfName.FIRST, ((PdfOutline)kids.get(0)).indirectReference());
            outline.put(PdfName.LAST, ((PdfOutline)kids.get(size - 1)).indirectReference());
        }
        k = 0;
        while (k < size) {
            PdfOutline kid = (PdfOutline)kids.get(k);
            this.writer.addToBody((PdfObject)kid, kid.indirectReference());
            ++k;
        }
    }

    void setViewerPreferences(int preferences) {
        this.viewerPreferences.setViewerPreferences(preferences);
    }

    void addViewerPreference(PdfName key, PdfObject value) {
        this.viewerPreferences.addViewerPreference(key, value);
    }

    void setPageLabels(PdfPageLabels pageLabels) {
        this.pageLabels = pageLabels;
    }

    void localGoto(String name, float llx, float lly, float urx, float ury) {
        PdfAction action = this.getLocalGotoAction(name);
        this.annotationsImp.addPlainAnnotation(new PdfAnnotation(this.writer, llx, lly, urx, ury, action));
    }

    void remoteGoto(String filename, String name, float llx, float lly, float urx, float ury) {
        this.annotationsImp.addPlainAnnotation(new PdfAnnotation(this.writer, llx, lly, urx, ury, new PdfAction(filename, name)));
    }

    void remoteGoto(String filename, int page, float llx, float lly, float urx, float ury) {
        this.addAnnotation(new PdfAnnotation(this.writer, llx, lly, urx, ury, new PdfAction(filename, page)));
    }

    void setAction(PdfAction action, float llx, float lly, float urx, float ury) {
        this.addAnnotation(new PdfAnnotation(this.writer, llx, lly, urx, ury, action));
    }

    PdfAction getLocalGotoAction(String name) {
        PdfAction action;
        Object[] obj = (Object[])this.localDestinations.get(name);
        if (obj == null) {
            obj = new Object[3];
        }
        if (obj[0] == null) {
            if (obj[1] == null) {
                obj[1] = this.writer.getPdfIndirectReference();
            }
            action = new PdfAction((PdfIndirectReference)obj[1]);
            obj[0] = action;
            this.localDestinations.put(name, obj);
        } else {
            action = (PdfAction)obj[0];
        }
        return action;
    }

    boolean localDestination(String name, PdfDestination destination) {
        Object[] obj = (Object[])this.localDestinations.get(name);
        if (obj == null) {
            obj = new Object[3];
        }
        if (obj[2] != null) {
            return false;
        }
        obj[2] = destination;
        this.localDestinations.put(name, obj);
        destination.addPage(this.writer.getCurrentPage());
        return true;
    }

    void addJavaScript(PdfAction js) {
        if (js.get(PdfName.JS) == null) {
            throw new RuntimeException("Only JavaScript actions are allowed.");
        }
        try {
            this.documentJavaScript.add(this.writer.addToBody(js).getIndirectReference());
        }
        catch (IOException e) {
            throw new ExceptionConverter(e);
        }
    }

    ArrayList getDocumentJavaScript() {
        return this.documentJavaScript;
    }

    void addFileAttachment(String description, PdfFileSpecification fs) throws IOException {
        if (description == null) {
            PdfString desc = (PdfString)fs.get(PdfName.DESC);
            description = desc == null ? "" : PdfEncodings.convertToString(desc.getBytes(), null);
        }
        fs.addDescription(description, true);
        if (description.length() == 0) {
            description = "Unnamed";
        }
        String fn = PdfEncodings.convertToString(new PdfString(description, "UnicodeBig").getBytes(), null);
        int k = 0;
        while (this.documentFileAttachment.containsKey(fn)) {
            fn = PdfEncodings.convertToString(new PdfString(String.valueOf(description) + " " + ++k, "UnicodeBig").getBytes(), null);
        }
        this.documentFileAttachment.put(fn, fs.getReference());
    }

    HashMap getDocumentFileAttachment() {
        return this.documentFileAttachment;
    }

    void setOpenAction(String name) {
        this.openActionName = name;
        this.openActionAction = null;
    }

    void setOpenAction(PdfAction action) {
        this.openActionAction = action;
        this.openActionName = null;
    }

    void addAdditionalAction(PdfName actionType, PdfAction action) {
        if (this.additionalActions == null) {
            this.additionalActions = new PdfDictionary();
        }
        if (action == null) {
            this.additionalActions.remove(actionType);
        } else {
            this.additionalActions.put(actionType, action);
        }
        if (this.additionalActions.size() == 0) {
            this.additionalActions = null;
        }
    }

    public void setCollection(PdfCollection collection) {
        this.collection = collection;
    }

    PdfAcroForm getAcroForm() {
        return this.annotationsImp.getAcroForm();
    }

    void setSigFlags(int f) {
        this.annotationsImp.setSigFlags(f);
    }

    void addCalculationOrder(PdfFormField formField) {
        this.annotationsImp.addCalculationOrder(formField);
    }

    void addAnnotation(PdfAnnotation annot) {
        this.pageEmpty = false;
        this.annotationsImp.addAnnotation(annot);
    }

    int getMarkPoint() {
        return this.markPoint;
    }

    void incMarkPoint() {
        ++this.markPoint;
    }

    void setCropBoxSize(Rectangle crop) {
        this.setBoxSize("crop", crop);
    }

    void setBoxSize(String boxName, Rectangle size) {
        if (size == null) {
            this.boxSize.remove(boxName);
        } else {
            this.boxSize.put(boxName, new PdfRectangle(size));
        }
    }

    Rectangle getBoxSize(String boxName) {
        PdfRectangle r = (PdfRectangle)this.thisBoxSize.get(boxName);
        if (r != null) {
            return r.getRectangle();
        }
        return null;
    }

    void setPageEmpty(boolean pageEmpty) {
        this.pageEmpty = pageEmpty;
    }

    void setDuration(int seconds) {
        this.duration = seconds > 0 ? seconds : -1;
    }

    void setTransition(PdfTransition transition) {
        this.transition = transition;
    }

    void setPageAction(PdfName actionType, PdfAction action) {
        if (this.pageAA == null) {
            this.pageAA = new PdfDictionary();
        }
        this.pageAA.put(actionType, action);
    }

    void setThumbnail(Image image) throws PdfException, DocumentException {
        this.thumb = this.writer.getImageReference(this.writer.addDirectImageSimple(image));
    }

    PageResources getPageResources() {
        return this.pageResources;
    }

    boolean isStrictImageSequence() {
        return this.strictImageSequence;
    }

    void setStrictImageSequence(boolean strictImageSequence) {
        this.strictImageSequence = strictImageSequence;
    }

    public void clearTextWrap() {
        float tmpHeight = this.imageEnd - this.currentHeight;
        if (this.line != null) {
            tmpHeight += this.line.height();
        }
        if (this.imageEnd > -1.0f && tmpHeight > 0.0f) {
            this.carriageReturn();
            this.currentHeight += tmpHeight;
        }
    }

    private void add(Image image) throws PdfException, DocumentException {
        if (image.hasAbsolutePosition()) {
            this.graphics.addImage(image);
            this.pageEmpty = false;
            return;
        }
        if (this.currentHeight != 0.0f && this.indentTop() - this.currentHeight - image.scaledHeight() < this.indentBottom()) {
            if (!this.strictImageSequence && this.imageWait == null) {
                this.imageWait = image;
                return;
            }
            this.newPage();
            if (this.currentHeight != 0.0f && this.indentTop() - this.currentHeight - image.scaledHeight() < this.indentBottom()) {
                this.imageWait = image;
                return;
            }
        }
        this.pageEmpty = false;
        if (image == this.imageWait) {
            this.imageWait = null;
        }
        boolean textwrap = (image.alignment() & 4) == 4 && (image.alignment() & 1) != 1;
        boolean underlying = (image.alignment() & 8) == 8;
        float diff = this.leading / 2.0f;
        if (textwrap) {
            diff += this.leading;
        }
        float lowerleft = this.indentTop() - this.currentHeight - image.scaledHeight() - diff;
        float[] mt = image.matrix();
        float startPosition = this.indentLeft() - mt[4];
        if ((image.alignment() & 2) == 2) {
            startPosition = this.indentRight() - image.scaledWidth() - mt[4];
        }
        if ((image.alignment() & 1) == 1) {
            startPosition = this.indentLeft() + (this.indentRight() - this.indentLeft() - image.scaledWidth()) / 2.0f - mt[4];
        }
        if (image.hasAbsoluteX()) {
            startPosition = image.absoluteX();
        }
        if (textwrap) {
            if (this.imageEnd < 0.0f || this.imageEnd < this.currentHeight + image.scaledHeight() + diff) {
                this.imageEnd = this.currentHeight + image.scaledHeight() + diff;
            }
            if ((image.alignment() & 2) == 2) {
                Indentation indentation = this.indentation;
                indentation.imageIndentRight = indentation.imageIndentRight + (image.scaledWidth() + image.indentationLeft());
            } else {
                Indentation indentation = this.indentation;
                indentation.imageIndentLeft = indentation.imageIndentLeft + (image.scaledWidth() + image.indentationRight());
            }
        } else {
            startPosition = (image.alignment() & 2) == 2 ? (startPosition -= image.indentationRight()) : ((image.alignment() & 1) == 1 ? (startPosition += image.indentationLeft() - image.indentationRight()) : (startPosition += image.indentationLeft()));
        }
        this.graphics.addImage(image, mt[0], mt[1], mt[2], mt[3], startPosition, lowerleft - mt[5]);
        if (!textwrap && !underlying) {
            this.currentHeight += image.scaledHeight() + diff;
            this.flushLines();
            this.text.moveText(0.0f, -(image.scaledHeight() + diff));
            this.newLine();
        }
    }

    void addPTable(PdfPTable ptable) throws DocumentException {
        ColumnText ct = new ColumnText(this.writer.getDirectContent());
        if (this.currentHeight > 0.0f) {
            Paragraph p = new Paragraph();
            p.setLeading(0.0f);
            ct.addElement(p);
            if (ptable.getKeepTogether() && !this.fitsPage(ptable, 0.0f)) {
                this.newPage();
            }
        }
        ct.addElement(ptable);
        boolean he = ptable.isHeadersInEvent();
        ptable.setHeadersInEvent(true);
        int loop = 0;
        while (true) {
            ct.setSimpleColumn(this.indentLeft(), this.indentBottom(), this.indentRight(), this.indentTop() - this.currentHeight);
            int status = ct.go();
            if ((status & 1) != 0) {
                this.text.moveText(0.0f, ct.getYLine() - this.indentTop() + this.currentHeight);
                this.currentHeight = this.indentTop() - ct.getYLine();
                break;
            }
            loop = this.indentTop() - this.currentHeight == ct.getYLine() ? ++loop : 0;
            if (loop == 3) {
                this.add(new Paragraph("ERROR: Infinite table loop"));
                break;
            }
            this.newPage();
        }
        ptable.setHeadersInEvent(he);
    }

    boolean fitsPage(PdfPTable table, float margin) {
        if (!table.isLockedWidth()) {
            float totalWidth = (this.indentRight() - this.indentLeft()) * table.getWidthPercentage() / 100.0f;
            table.setTotalWidth(totalWidth);
        }
        this.ensureNewLine();
        return table.getTotalHeight() <= this.indentTop() - this.currentHeight - this.indentBottom() - margin;
    }

    PdfTable getPdfTable(Table table, boolean supportRowAdditions) {
        return new PdfTable(table, this.indentLeft(), this.indentRight(), this.indentTop() - this.currentHeight, supportRowAdditions);
    }

    private void add(PdfTable table, boolean onlyFirstPage) throws DocumentException {
        this.flushLines();
        RenderingContext ctx = new RenderingContext();
        ctx.pagetop = this.indentTop();
        ctx.oldHeight = this.currentHeight;
        ctx.cellGraphics = new PdfContentByte(this.writer);
        ctx.rowspanMap = new HashMap();
        ctx.table = table;
        ArrayList<PdfCell> dataCells = table.getCells();
        ArrayList headercells = table.getHeaderCells();
        if (!headercells.isEmpty() && (dataCells.isEmpty() || dataCells.get(0) != headercells.get(0))) {
            ArrayList<PdfCell> allCells = new ArrayList<PdfCell>(dataCells.size() + headercells.size());
            allCells.addAll(headercells);
            allCells.addAll(dataCells);
            dataCells = allCells;
        }
        ArrayList<PdfCell> cells = dataCells;
        ArrayList rows = this.extractRows(cells, ctx);
        boolean isContinue = false;
        while (!cells.isEmpty()) {
            PdfCell cell;
            ctx.lostTableBottom = 0.0f;
            boolean cellsShown = false;
            Iterator iterator = rows.iterator();
            boolean atLeastOneFits = false;
            while (iterator.hasNext()) {
                ArrayList row = (ArrayList)iterator.next();
                this.analyzeRow(rows, ctx);
                this.renderCells(ctx, row, table.hasToFitPageCells() & atLeastOneFits);
                if (!this.mayBeRemoved(row)) break;
                this.consumeRowspan(row, ctx);
                iterator.remove();
                atLeastOneFits = true;
            }
            cells.clear();
            HashSet<PdfCell> opt = new HashSet<PdfCell>();
            iterator = rows.iterator();
            while (iterator.hasNext()) {
                ArrayList row = (ArrayList)iterator.next();
                Iterator cellIterator = row.iterator();
                while (cellIterator.hasNext()) {
                    cell = (PdfCell)cellIterator.next();
                    if (opt.contains(cell)) continue;
                    cells.add(cell);
                    opt.add(cell);
                }
            }
            Rectangle tablerec = new Rectangle(table);
            tablerec.setBorder(table.border());
            tablerec.setBorderWidth(table.borderWidth());
            tablerec.setBorderColor(table.borderColor());
            tablerec.setBackgroundColor(table.backgroundColor());
            PdfContentByte under = this.writer.getDirectContentUnder();
            under.rectangle(tablerec.rectangle(this.top(), this.indentBottom()));
            under.add(ctx.cellGraphics);
            tablerec.setBackgroundColor(null);
            tablerec = tablerec.rectangle(this.top(), this.indentBottom());
            tablerec.setBorder(table.border());
            under.rectangle(tablerec);
            ctx.cellGraphics = new PdfContentByte(null);
            if (rows.isEmpty()) continue;
            isContinue = true;
            this.graphics.setLineWidth(table.borderWidth());
            if (cellsShown && (table.border() & 2) == 2) {
                Color tColor = table.borderColor();
                if (tColor != null) {
                    this.graphics.setColorStroke(tColor);
                }
                this.graphics.moveTo(table.left(), Math.max(table.bottom(), this.indentBottom()));
                this.graphics.lineTo(table.right(), Math.max(table.bottom(), this.indentBottom()));
                this.graphics.stroke();
                if (tColor != null) {
                    this.graphics.resetRGBColorStroke();
                }
            }
            this.pageEmpty = false;
            float difference = ctx.lostTableBottom;
            this.newPage();
            float heightCorrection = 0.0f;
            boolean somethingAdded = false;
            if (this.currentHeight > 0.0f) {
                heightCorrection = 6.0f;
                this.currentHeight += heightCorrection;
                somethingAdded = true;
                this.newLine();
                this.flushLines();
                this.indentation.indentTop = this.currentHeight - this.leading;
                this.currentHeight = 0.0f;
            } else {
                this.flushLines();
            }
            int size = headercells.size();
            if (size > 0) {
                cell = (PdfCell)headercells.get(0);
                float oldTop = cell.top(0.0f);
                int i = 0;
                while (i < size) {
                    cell = (PdfCell)headercells.get(i);
                    cell.setTop(this.indentTop() - oldTop + cell.top(0.0f));
                    cell.setBottom(this.indentTop() - oldTop + cell.bottom(0.0f));
                    ctx.pagetop = cell.bottom();
                    ctx.cellGraphics.rectangle(cell.rectangle(this.indentTop(), this.indentBottom()));
                    ArrayList images = cell.getImages(this.indentTop(), this.indentBottom());
                    Iterator im = images.iterator();
                    while (im.hasNext()) {
                        cellsShown = true;
                        Image image = (Image)im.next();
                        this.graphics.addImage(image);
                    }
                    this.lines = cell.getLines(this.indentTop(), this.indentBottom());
                    float cellTop = cell.top(this.indentTop());
                    this.text.moveText(0.0f, cellTop - heightCorrection);
                    float cellDisplacement = this.flushLines() - cellTop + heightCorrection;
                    this.text.moveText(0.0f, cellDisplacement);
                    ++i;
                }
                this.currentHeight = this.indentTop() - ctx.pagetop + table.cellspacing();
                this.text.moveText(0.0f, ctx.pagetop - this.indentTop() - this.currentHeight);
            } else if (somethingAdded) {
                ctx.pagetop = this.indentTop();
                this.text.moveText(0.0f, -table.cellspacing());
            }
            ctx.oldHeight = this.currentHeight - heightCorrection;
            size = Math.min(cells.size(), table.columns());
            int i = 0;
            while (i < size) {
                float neededHeight;
                float newBottom;
                cell = (PdfCell)cells.get(i);
                if (cell.top(-table.cellspacing()) > ctx.lostTableBottom && (newBottom = ctx.pagetop - difference + cell.bottom()) > ctx.pagetop - (neededHeight = cell.remainingHeight())) {
                    difference += newBottom - (ctx.pagetop - neededHeight);
                }
                ++i;
            }
            size = cells.size();
            table.setTop(this.indentTop());
            table.setBottom(ctx.pagetop - difference + table.bottom(table.cellspacing()));
            i = 0;
            while (i < size) {
                cell = (PdfCell)cells.get(i);
                float newBottom = ctx.pagetop - difference + cell.bottom();
                float newTop = ctx.pagetop - difference + cell.top(-table.cellspacing());
                if (newTop > this.indentTop() - this.currentHeight) {
                    newTop = this.indentTop() - this.currentHeight;
                }
                cell.setTop(newTop);
                cell.setBottom(newBottom);
                ++i;
            }
            if (onlyFirstPage) break;
        }
        float tableHeight = table.top() - table.bottom();
        if (isContinue) {
            this.currentHeight = tableHeight;
            this.text.moveText(0.0f, -(tableHeight - ctx.oldHeight * 2.0f));
        } else {
            this.currentHeight = ctx.oldHeight + tableHeight;
            this.text.moveText(0.0f, -tableHeight);
        }
        this.pageEmpty = false;
    }

    private void analyzeRow(ArrayList rows, RenderingContext ctx) {
        ctx.maxCellBottom = this.indentBottom();
        int rowIndex = 0;
        ArrayList row = (ArrayList)rows.get(rowIndex);
        int maxRowspan = 1;
        Iterator iterator = row.iterator();
        while (iterator.hasNext()) {
            PdfCell cell = (PdfCell)iterator.next();
            maxRowspan = Math.max(ctx.currentRowspan(cell), maxRowspan);
        }
        boolean useTop = true;
        if ((rowIndex += maxRowspan) == rows.size()) {
            rowIndex = rows.size() - 1;
            useTop = false;
        }
        if (rowIndex < 0 || rowIndex >= rows.size()) {
            return;
        }
        row = (ArrayList)rows.get(rowIndex);
        iterator = row.iterator();
        while (iterator.hasNext()) {
            PdfCell cell = (PdfCell)iterator.next();
            Rectangle cellRect = cell.rectangle(ctx.pagetop, this.indentBottom());
            if (useTop) {
                ctx.maxCellBottom = Math.max(ctx.maxCellBottom, cellRect.top());
                continue;
            }
            if (ctx.currentRowspan(cell) != 1) continue;
            ctx.maxCellBottom = Math.max(ctx.maxCellBottom, cellRect.bottom());
        }
    }

    private boolean mayBeRemoved(ArrayList row) {
        Iterator iterator = row.iterator();
        boolean mayBeRemoved = true;
        while (iterator.hasNext()) {
            PdfCell cell = (PdfCell)iterator.next();
            mayBeRemoved &= cell.mayBeRemoved();
        }
        return mayBeRemoved;
    }

    private void consumeRowspan(ArrayList row, RenderingContext ctx) {
        Iterator iterator = row.iterator();
        while (iterator.hasNext()) {
            PdfCell c = (PdfCell)iterator.next();
            ctx.consumeRowspan(c);
        }
    }

    private ArrayList extractRows(ArrayList cells, RenderingContext ctx) {
        PdfCell previousCell = null;
        ArrayList rows = new ArrayList();
        ArrayList<PdfCell> rowCells = new ArrayList<PdfCell>();
        Iterator iterator = cells.iterator();
        while (iterator.hasNext()) {
            boolean isCurrentCellPartOfRow;
            PdfCell cell = (PdfCell)iterator.next();
            boolean isAdded = false;
            boolean isEndOfRow = !iterator.hasNext();
            boolean bl = isCurrentCellPartOfRow = !iterator.hasNext();
            if (previousCell != null && cell.left() <= previousCell.left()) {
                isEndOfRow = true;
                isCurrentCellPartOfRow = false;
            }
            if (isCurrentCellPartOfRow) {
                rowCells.add(cell);
                isAdded = true;
            }
            if (isEndOfRow) {
                if (!rowCells.isEmpty()) {
                    rows.add(rowCells);
                }
                rowCells = new ArrayList();
            }
            if (!isAdded) {
                rowCells.add(cell);
            }
            previousCell = cell;
        }
        if (!rowCells.isEmpty()) {
            rows.add(rowCells);
        }
        int i = rows.size() - 1;
        while (i >= 0) {
            ArrayList row = (ArrayList)rows.get(i);
            int j = 0;
            while (j < row.size()) {
                PdfCell c = (PdfCell)row.get(j);
                int rowspan = c.rowspan();
                int k = 1;
                while (k < rowspan && rows.size() <= i + k) {
                    ArrayList spannedRow = (ArrayList)rows.get(i + k);
                    if (spannedRow.size() > j) {
                        spannedRow.add(j, c);
                    }
                    ++k;
                }
                ++j;
            }
            --i;
        }
        return rows;
    }

    private void renderCells(RenderingContext ctx, java.util.List cells, boolean hasToFit) throws DocumentException {
        PdfCell cell;
        Iterator iterator;
        if (hasToFit) {
            iterator = cells.iterator();
            while (iterator.hasNext()) {
                cell = (PdfCell)iterator.next();
                if (cell.isHeader() || !(cell.bottom() < this.indentBottom())) continue;
                return;
            }
        }
        iterator = cells.iterator();
        while (iterator.hasNext()) {
            cell = (PdfCell)iterator.next();
            if (ctx.isCellRenderedOnPage(cell, this.getPageNumber())) continue;
            float correction = 0.0f;
            if (ctx.numCellRendered(cell) >= 1) {
                correction = 1.0f;
            }
            this.lines = cell.getLines(ctx.pagetop, this.indentBottom() - correction);
            if (this.lines != null && !this.lines.isEmpty()) {
                float cellTop = cell.top(ctx.pagetop - ctx.oldHeight);
                this.text.moveText(0.0f, cellTop);
                float cellDisplacement = this.flushLines() - cellTop;
                this.text.moveText(0.0f, cellDisplacement);
                if (ctx.oldHeight + cellDisplacement > this.currentHeight) {
                    this.currentHeight = ctx.oldHeight + cellDisplacement;
                }
                ctx.cellRendered(cell, this.getPageNumber());
            }
            float indentBottom = Math.max(cell.bottom(), this.indentBottom());
            Rectangle tableRect = ctx.table.rectangle(ctx.pagetop, this.indentBottom());
            indentBottom = Math.max(tableRect.bottom(), indentBottom);
            Rectangle cellRect = cell.rectangle(tableRect.top(), indentBottom);
            if (cellRect.height() > 0.0f) {
                ctx.lostTableBottom = indentBottom;
                ctx.cellGraphics.rectangle(cellRect);
            }
            ArrayList images = cell.getImages(ctx.pagetop, this.indentBottom());
            Iterator i = images.iterator();
            while (i.hasNext()) {
                Image image = (Image)i.next();
                this.graphics.addImage(image);
            }
        }
    }

    boolean breakTableIfDoesntFit(PdfTable table) throws DocumentException {
        table.updateRowAdditions();
        if (!table.hasToFitPageTable() && table.bottom() <= this.indentation.indentBottom) {
            this.add(table, true);
            return true;
        }
        return false;
    }

    float bottom(Table table) {
        PdfTable tmp = this.getPdfTable(table, false);
        return tmp.bottom();
    }

    private void doFooter() throws DocumentException {
        if (this.footer == null) {
            return;
        }
        float tmpIndentLeft = this.indentation.indentLeft;
        float tmpIndentRight = this.indentation.indentRight;
        float tmpListIndentLeft = this.indentation.listIndentLeft;
        float tmpImageIndentLeft = this.indentation.imageIndentLeft;
        float tmpImageIndentRight = this.indentation.imageIndentRight;
        this.indentation.indentRight = 0.0f;
        this.indentation.indentLeft = 0.0f;
        this.indentation.listIndentLeft = 0.0f;
        this.indentation.imageIndentLeft = 0.0f;
        this.indentation.imageIndentRight = 0.0f;
        this.footer.setPageNumber(this.pageN);
        this.leading = this.footer.paragraph().getTotalLeading();
        this.add(this.footer.paragraph());
        this.indentation.indentBottom = this.currentHeight;
        this.text.moveText(this.left(), this.indentBottom());
        this.flushLines();
        this.text.moveText(-this.left(), -this.bottom());
        this.footer.setTop(this.bottom(this.currentHeight));
        this.footer.setBottom(this.bottom() - 0.75f * this.leading);
        this.footer.setLeft(this.left());
        this.footer.setRight(this.right());
        this.graphics.rectangle(this.footer);
        this.indentation.indentBottom = this.currentHeight + this.leading * 2.0f;
        this.currentHeight = 0.0f;
        this.indentation.indentLeft = tmpIndentLeft;
        this.indentation.indentRight = tmpIndentRight;
        this.indentation.listIndentLeft = tmpListIndentLeft;
        this.indentation.imageIndentLeft = tmpImageIndentLeft;
        this.indentation.imageIndentRight = tmpImageIndentRight;
    }

    private void doHeader() throws DocumentException {
        if (this.header == null) {
            return;
        }
        float tmpIndentLeft = this.indentation.indentLeft;
        float tmpIndentRight = this.indentation.indentRight;
        float tmpListIndentLeft = this.indentation.listIndentLeft;
        float tmpImageIndentLeft = this.indentation.imageIndentLeft;
        float tmpImageIndentRight = this.indentation.imageIndentRight;
        this.indentation.indentRight = 0.0f;
        this.indentation.indentLeft = 0.0f;
        this.indentation.listIndentLeft = 0.0f;
        this.indentation.imageIndentLeft = 0.0f;
        this.indentation.imageIndentRight = 0.0f;
        this.header.setPageNumber(this.pageN);
        this.leading = this.header.paragraph().getTotalLeading();
        this.text.moveText(0.0f, this.leading);
        this.add(this.header.paragraph());
        this.newLine();
        this.indentation.indentTop = this.currentHeight - this.leading;
        this.header.setTop(this.top() + this.leading);
        this.header.setBottom(this.indentTop() + this.leading * 2.0f / 3.0f);
        this.header.setLeft(this.left());
        this.header.setRight(this.right());
        this.graphics.rectangle(this.header);
        this.flushLines();
        this.currentHeight = 0.0f;
        this.indentation.indentLeft = tmpIndentLeft;
        this.indentation.indentRight = tmpIndentRight;
        this.indentation.listIndentLeft = tmpListIndentLeft;
        this.indentation.imageIndentLeft = tmpImageIndentLeft;
        this.indentation.imageIndentRight = tmpImageIndentRight;
    }

    public static class PdfInfo
    extends PdfDictionary {
        PdfInfo() {
            this.addProducer();
            this.addCreationDate();
        }

        PdfInfo(String author, String title, String subject) {
            this();
            this.addTitle(title);
            this.addSubject(subject);
            this.addAuthor(author);
        }

        void addTitle(String title) {
            this.put(PdfName.TITLE, new PdfString(title, "UnicodeBig"));
        }

        void addSubject(String subject) {
            this.put(PdfName.SUBJECT, new PdfString(subject, "UnicodeBig"));
        }

        void addKeywords(String keywords) {
            this.put(PdfName.KEYWORDS, new PdfString(keywords, "UnicodeBig"));
        }

        void addAuthor(String author) {
            this.put(PdfName.AUTHOR, new PdfString(author, "UnicodeBig"));
        }

        void addCreator(String creator) {
            this.put(PdfName.CREATOR, new PdfString(creator, "UnicodeBig"));
        }

        void addProducer() {
            this.put(PdfName.PRODUCER, new PdfString(PdfDocument.getVersion()));
        }

        void addCreationDate() {
            PdfDate date = new PdfDate();
            this.put(PdfName.CREATIONDATE, date);
            this.put(PdfName.MODDATE, date);
        }

        void addkey(String key, String value) {
            if (key.equals("Producer") || key.equals("CreationDate")) {
                return;
            }
            this.put(new PdfName(key), new PdfString(value, "UnicodeBig"));
        }
    }

    static class PdfCatalog
    extends PdfDictionary {
        PdfWriter writer;

        PdfCatalog(PdfIndirectReference pages, PdfWriter writer) {
            super(CATALOG);
            this.writer = writer;
            this.put(PdfName.PAGES, pages);
        }

        void addNames(TreeMap localDestinations, ArrayList documentJavaScript, HashMap documentFileAttachment, PdfWriter writer) {
            if (localDestinations.isEmpty() && documentJavaScript.isEmpty() && documentFileAttachment.isEmpty()) {
                return;
            }
            try {
                PdfDictionary names = new PdfDictionary();
                if (!localDestinations.isEmpty()) {
                    PdfArray ar = new PdfArray();
                    Iterator i = localDestinations.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry entry = i.next();
                        String name = (String)entry.getKey();
                        Object[] obj = (Object[])entry.getValue();
                        PdfIndirectReference ref = (PdfIndirectReference)obj[1];
                        ar.add(new PdfString(name));
                        ar.add(ref);
                    }
                    PdfDictionary dests = new PdfDictionary();
                    dests.put(PdfName.NAMES, ar);
                    names.put(PdfName.DESTS, writer.addToBody(dests).getIndirectReference());
                }
                if (!documentJavaScript.isEmpty()) {
                    Object[] s = new String[documentJavaScript.size()];
                    int k = 0;
                    while (k < s.length) {
                        s[k] = Integer.toHexString(k);
                        ++k;
                    }
                    Arrays.sort(s);
                    PdfArray ar = new PdfArray();
                    int k2 = 0;
                    while (k2 < s.length) {
                        ar.add(new PdfString((String)s[k2]));
                        ar.add((PdfIndirectReference)documentJavaScript.get(k2));
                        ++k2;
                    }
                    PdfDictionary js = new PdfDictionary();
                    js.put(PdfName.NAMES, ar);
                    names.put(PdfName.JAVASCRIPT, writer.addToBody(js).getIndirectReference());
                }
                if (!documentFileAttachment.isEmpty()) {
                    names.put(PdfName.EMBEDDEDFILES, writer.addToBody(PdfNameTree.writeTree(documentFileAttachment, writer)).getIndirectReference());
                }
                this.put(PdfName.NAMES, writer.addToBody(names).getIndirectReference());
            }
            catch (IOException e) {
                throw new ExceptionConverter(e);
            }
        }

        void setOpenAction(PdfAction action) {
            this.put(PdfName.OPENACTION, action);
        }

        void setAdditionalActions(PdfDictionary actions) {
            try {
                this.put(PdfName.AA, this.writer.addToBody(actions).getIndirectReference());
            }
            catch (Exception e) {
                throw new ExceptionConverter(e);
            }
        }
    }

    class Indentation {
        float paragraph = 0.0f;
        private float indentLeft = 0.0f;
        private float sectionIndentLeft = 0.0f;
        private float listIndentLeft = 0.0f;
        private float imageIndentLeft = 0.0f;
        private float indentRight = 0.0f;
        private float sectionIndentRight = 0.0f;
        private float imageIndentRight = 0.0f;
        private float indentTop = 0.0f;
        private float indentBottom = 0.0f;

        Indentation() {
        }
    }

    private static class RenderingContext {
        float pagetop = -1.0f;
        float oldHeight = -1.0f;
        PdfContentByte cellGraphics = null;
        float lostTableBottom;
        float maxCellBottom;
        float maxCellHeight;
        Map rowspanMap;
        Map pageMap = new HashMap();
        public PdfTable table;

        private RenderingContext() {
        }

        public int consumeRowspan(PdfCell c) {
            if (c.rowspan() == 1) {
                return 1;
            }
            Integer i = (Integer)this.rowspanMap.get(c);
            if (i == null) {
                i = new Integer(c.rowspan());
            }
            i = new Integer(i - 1);
            this.rowspanMap.put(c, i);
            if (i < 1) {
                return 1;
            }
            return i;
        }

        public int currentRowspan(PdfCell c) {
            Integer i = (Integer)this.rowspanMap.get(c);
            if (i == null) {
                return c.rowspan();
            }
            return i;
        }

        public int cellRendered(PdfCell cell, int pageNumber) {
            Integer i = (Integer)this.pageMap.get(cell);
            i = i == null ? new Integer(1) : new Integer(i + 1);
            this.pageMap.put(cell, i);
            Integer pageInteger = new Integer(pageNumber);
            HashSet<PdfCell> set = (HashSet<PdfCell>)this.pageMap.get(pageInteger);
            if (set == null) {
                set = new HashSet<PdfCell>();
                this.pageMap.put(pageInteger, set);
            }
            set.add(cell);
            return i;
        }

        public int numCellRendered(PdfCell cell) {
            Integer i = (Integer)this.pageMap.get(cell);
            if (i == null) {
                i = new Integer(0);
            }
            return i;
        }

        public boolean isCellRenderedOnPage(PdfCell cell, int pageNumber) {
            Integer pageInteger = new Integer(pageNumber);
            Set set = (Set)this.pageMap.get(pageInteger);
            if (set != null) {
                return set.contains(cell);
            }
            return false;
        }
    }
}

