/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.asm;

import java.io.IOException;
import java.io.InputStream;
import net.sf.cglib.asm.Attribute;
import net.sf.cglib.asm.ClassVisitor;
import net.sf.cglib.asm.ClassWriter;
import net.sf.cglib.asm.CodeVisitor;
import net.sf.cglib.asm.Label;
import net.sf.cglib.asm.Type;

public class ClassReader {
    public final byte[] b;
    private int[] items;
    private String[] strings;
    private int maxStringLength;
    private int header;

    public ClassReader(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public ClassReader(byte[] byArray, int n, int n2) {
        this.b = byArray;
        this.items = new int[this.readUnsignedShort(n + 8)];
        this.strings = new String[this.items.length];
        int n3 = 0;
        int n4 = n + 10;
        for (int i = 1; i < this.items.length; ++i) {
            int n5;
            this.items[i] = n4 + 1;
            byte by = byArray[n4];
            switch (by) {
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    n5 = 5;
                    break;
                }
                case 5: 
                case 6: {
                    n5 = 9;
                    ++i;
                    break;
                }
                case 1: {
                    n5 = 3 + this.readUnsignedShort(n4 + 1);
                    n3 = n5 > n3 ? n5 : n3;
                    break;
                }
                default: {
                    n5 = 3;
                }
            }
            n4 += n5;
        }
        this.maxStringLength = n3;
        this.header = n4;
    }

    public ClassReader(InputStream inputStream) throws IOException {
        this(ClassReader.readClass(inputStream));
    }

    public ClassReader(String string) throws IOException {
        this(ClassLoader.getSystemResourceAsStream(string.replace('.', '/') + ".class"));
    }

    private static byte[] readClass(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IOException("Class not found");
        }
        byte[] byArray = new byte[inputStream.available()];
        int n = 0;
        while (true) {
            byte[] byArray2;
            int n2;
            if ((n2 = inputStream.read(byArray, n, byArray.length - n)) == -1) {
                if (n < byArray.length) {
                    byArray2 = new byte[n];
                    System.arraycopy(byArray, 0, byArray2, 0, n);
                    byArray = byArray2;
                }
                return byArray;
            }
            if ((n += n2) != byArray.length) continue;
            byArray2 = new byte[byArray.length + 1000];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            byArray = byArray2;
        }
    }

    public void accept(ClassVisitor classVisitor, boolean bl) {
        this.accept(classVisitor, new Attribute[0], bl);
    }

    public void accept(ClassVisitor classVisitor, Attribute[] attributeArray, boolean bl) {
        String[] stringArray;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        int n2;
        byte[] byArray = this.b;
        char[] cArray = new char[this.maxStringLength];
        int n3 = this.header;
        int n4 = this.readInt(4);
        int n5 = this.readUnsignedShort(n3);
        String string = this.readClass(n3 + 2, cArray);
        int n6 = this.items[this.readUnsignedShort(n3 + 4)];
        String string2 = n6 == 0 ? null : this.readUTF8(n6, cArray);
        String[] stringArray2 = new String[this.readUnsignedShort(n3 + 6)];
        String string3 = null;
        Object object5 = null;
        int n7 = 0;
        n3 += 8;
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            stringArray2[n2] = this.readClass(n3, cArray);
            n3 += 2;
        }
        n6 = n3;
        n2 = this.readUnsignedShort(n6);
        n6 += 2;
        while (n2 > 0) {
            n = this.readUnsignedShort(n6 + 6);
            n6 += 8;
            while (n > 0) {
                n6 += 6 + this.readInt(n6 + 2);
                --n;
            }
            --n2;
        }
        n2 = this.readUnsignedShort(n6);
        n6 += 2;
        while (n2 > 0) {
            n = this.readUnsignedShort(n6 + 6);
            n6 += 8;
            while (n > 0) {
                n6 += 6 + this.readInt(n6 + 2);
                --n;
            }
            --n2;
        }
        n2 = this.readUnsignedShort(n6);
        n6 += 2;
        while (n2 > 0) {
            object4 = this.readUTF8(n6, cArray);
            if (((String)object4).equals("SourceFile")) {
                string3 = this.readUTF8(n6 + 6, cArray);
            } else if (((String)object4).equals("Deprecated")) {
                n5 |= 0x20000;
            } else if (((String)object4).equals("Synthetic")) {
                n5 |= 0x1000;
            } else if (((String)object4).equals("InnerClasses")) {
                n7 = n6 + 6;
            } else {
                object3 = this.readAttribute(attributeArray, (String)object4, n6 + 6, this.readInt(n6 + 2), cArray, -1, null);
                if (object3 != null) {
                    ((Attribute)object3).next = object5;
                    object5 = object3;
                }
            }
            n6 += 6 + this.readInt(n6 + 2);
            --n2;
        }
        classVisitor.visit(n4, n5, string, string2, stringArray2, string3);
        if (n7 != 0) {
            n2 = this.readUnsignedShort(n7);
            n7 += 2;
            while (n2 > 0) {
                classVisitor.visitInnerClass(this.readUnsignedShort(n7) == 0 ? null : this.readClass(n7, cArray), this.readUnsignedShort(n7 + 2) == 0 ? null : this.readClass(n7 + 2, cArray), this.readUnsignedShort(n7 + 4) == 0 ? null : this.readUTF8(n7 + 4, cArray), this.readUnsignedShort(n7 + 6));
                n7 += 8;
                --n2;
            }
        }
        n2 = this.readUnsignedShort(n3);
        n3 += 2;
        while (n2 > 0) {
            n5 = this.readUnsignedShort(n3);
            object4 = this.readUTF8(n3 + 2, cArray);
            object2 = this.readUTF8(n3 + 4, cArray);
            object = null;
            int n8 = 0;
            n = this.readUnsignedShort(n3 + 6);
            n3 += 8;
            while (n > 0) {
                stringArray = this.readUTF8(n3, cArray);
                if (stringArray.equals("ConstantValue")) {
                    n8 = this.readUnsignedShort(n3 + 6);
                } else if (stringArray.equals("Synthetic")) {
                    n5 |= 0x1000;
                } else if (stringArray.equals("Deprecated")) {
                    n5 |= 0x20000;
                } else {
                    object3 = this.readAttribute(attributeArray, (String)stringArray, n3 + 6, this.readInt(n3 + 2), cArray, -1, null);
                    if (object3 != null) {
                        ((Attribute)object3).next = object;
                        object = object3;
                    }
                }
                n3 += 6 + this.readInt(n3 + 2);
                --n;
            }
            stringArray = n8 == 0 ? null : this.readConst(n8, cArray);
            classVisitor.visitField(n5, (String)object4, (String)object2, stringArray, (Attribute)object);
            --n2;
        }
        n2 = this.readUnsignedShort(n3);
        n3 += 2;
        while (n2 > 0) {
            n5 = this.readUnsignedShort(n3);
            object4 = this.readUTF8(n3 + 2, cArray);
            object2 = this.readUTF8(n3 + 4, cArray);
            object = null;
            Object object6 = null;
            n6 = 0;
            n7 = 0;
            n = this.readUnsignedShort(n3 + 6);
            n3 += 8;
            while (n > 0) {
                stringArray = this.readUTF8(n3, cArray);
                int n9 = this.readInt(n3 += 2);
                n3 += 4;
                if (stringArray.equals("Code")) {
                    n6 = n3;
                } else if (stringArray.equals("Exceptions")) {
                    n7 = n3;
                } else if (stringArray.equals("Synthetic")) {
                    n5 |= 0x1000;
                } else if (stringArray.equals("Deprecated")) {
                    n5 |= 0x20000;
                } else {
                    object3 = this.readAttribute(attributeArray, (String)stringArray, n3, n9, cArray, -1, null);
                    if (object3 != null) {
                        ((Attribute)object3).next = object;
                        object = object3;
                    }
                }
                n3 += n9;
                --n;
            }
            if (n7 == 0) {
                stringArray = null;
            } else {
                stringArray = new String[this.readUnsignedShort(n7)];
                n7 += 2;
                for (n = 0; n < stringArray.length; ++n) {
                    stringArray[n] = this.readClass(n7, cArray);
                    n7 += 2;
                }
            }
            CodeVisitor codeVisitor = classVisitor.visitMethod(n5, (String)object4, (String)object2, stringArray, (Attribute)object);
            if (codeVisitor != null && n6 != 0) {
                int n10;
                int n11;
                int n12 = this.readUnsignedShort(n6);
                int n13 = this.readUnsignedShort(n6 + 2);
                int n14 = this.readInt(n6 + 4);
                int n15 = n6 += 8;
                int n16 = n6 + n14;
                Label[] labelArray = new Label[n14 + 1];
                block40: while (n6 < n16) {
                    int n17 = byArray[n6] & 0xFF;
                    switch (ClassWriter.TYPE[n17]) {
                        case 0: 
                        case 4: {
                            ++n6;
                            continue block40;
                        }
                        case 8: {
                            n11 = n6 - n15 + this.readShort(n6 + 1);
                            if (labelArray[n11] == null) {
                                labelArray[n11] = new Label();
                            }
                            n6 += 3;
                            continue block40;
                        }
                        case 9: {
                            n11 = n6 - n15 + this.readInt(n6 + 1);
                            if (labelArray[n11] == null) {
                                labelArray[n11] = new Label();
                            }
                            n6 += 5;
                            continue block40;
                        }
                        case 16: {
                            n17 = byArray[n6 + 1] & 0xFF;
                            if (n17 == 132) {
                                n6 += 6;
                                continue block40;
                            }
                            n6 += 4;
                            continue block40;
                        }
                        case 13: {
                            n7 = n6 - n15;
                            n6 = n6 + 4 - (n7 & 3);
                            n11 = n7 + this.readInt(n6);
                            n6 += 4;
                            if (labelArray[n11] == null) {
                                labelArray[n11] = new Label();
                            }
                            n = this.readInt(n6);
                            n6 += 4;
                            for (n = this.readInt(n6 += 4) - n + 1; n > 0; --n) {
                                n11 = n7 + this.readInt(n6);
                                n6 += 4;
                                if (labelArray[n11] != null) continue;
                                labelArray[n11] = new Label();
                            }
                            continue block40;
                        }
                        case 14: {
                            n7 = n6 - n15;
                            n6 = n6 + 4 - (n7 & 3);
                            n11 = n7 + this.readInt(n6);
                            n6 += 4;
                            if (labelArray[n11] == null) {
                                labelArray[n11] = new Label();
                            }
                            n = this.readInt(n6);
                            n6 += 4;
                            while (n > 0) {
                                n11 = n7 + this.readInt(n6 += 4);
                                n6 += 4;
                                if (labelArray[n11] == null) {
                                    labelArray[n11] = new Label();
                                }
                                --n;
                            }
                            continue block40;
                        }
                        case 1: 
                        case 3: 
                        case 10: {
                            n6 += 2;
                            continue block40;
                        }
                        case 2: 
                        case 5: 
                        case 6: 
                        case 11: 
                        case 12: {
                            n6 += 3;
                            continue block40;
                        }
                        case 7: {
                            n6 += 5;
                            continue block40;
                        }
                    }
                    n6 += 4;
                }
                n = this.readUnsignedShort(n6);
                n6 += 2;
                while (n > 0) {
                    n11 = this.readUnsignedShort(n6);
                    if (labelArray[n11] == null) {
                        labelArray[n11] = new Label();
                    }
                    if (labelArray[n11 = this.readUnsignedShort(n6 + 2)] == null) {
                        labelArray[n11] = new Label();
                    }
                    if (labelArray[n11 = this.readUnsignedShort(n6 + 4)] == null) {
                        labelArray[n11] = new Label();
                    }
                    n6 += 8;
                    --n;
                }
                n = this.readUnsignedShort(n6);
                n6 += 2;
                while (n > 0) {
                    String string4 = this.readUTF8(n6, cArray);
                    if (string4.equals("LocalVariableTable")) {
                        if (!bl) {
                            n7 = n6 + 8;
                            for (n10 = this.readUnsignedShort(n6 + 6); n10 > 0; --n10) {
                                n11 = this.readUnsignedShort(n7);
                                if (labelArray[n11] == null) {
                                    labelArray[n11] = new Label();
                                }
                                if (labelArray[n11 += this.readUnsignedShort(n7 + 2)] == null) {
                                    labelArray[n11] = new Label();
                                }
                                n7 += 10;
                            }
                        }
                    } else if (string4.equals("LineNumberTable")) {
                        if (!bl) {
                            n7 = n6 + 8;
                            for (n10 = this.readUnsignedShort(n6 + 6); n10 > 0; --n10) {
                                n11 = this.readUnsignedShort(n7);
                                if (labelArray[n11] == null) {
                                    labelArray[n11] = new Label();
                                }
                                labelArray[n11].line = this.readUnsignedShort(n7 + 2);
                                n7 += 4;
                            }
                        }
                    } else {
                        for (n10 = 0; n10 < attributeArray.length; ++n10) {
                            if (!attributeArray[n10].type.equals(string4) || (object3 = attributeArray[n10].read(this, n6 + 6, this.readInt(n6 + 2), cArray, n15 - 8, labelArray)) == null) continue;
                            ((Attribute)object3).next = object6;
                            object6 = object3;
                        }
                    }
                    n6 += 6 + this.readInt(n6 + 2);
                    --n;
                }
                n6 = n15;
                block48: while (n6 < n16) {
                    n7 = n6 - n15;
                    Label label = labelArray[n7];
                    if (label != null) {
                        codeVisitor.visitLabel(label);
                        if (!bl && label.line > 0) {
                            codeVisitor.visitLineNumber(label.line, label);
                        }
                    }
                    int n18 = byArray[n6] & 0xFF;
                    switch (ClassWriter.TYPE[n18]) {
                        case 0: {
                            codeVisitor.visitInsn(n18);
                            ++n6;
                            continue block48;
                        }
                        case 4: {
                            if (n18 > 54) {
                                codeVisitor.visitVarInsn(54 + ((n18 -= 59) >> 2), n18 & 3);
                            } else {
                                codeVisitor.visitVarInsn(21 + ((n18 -= 26) >> 2), n18 & 3);
                            }
                            ++n6;
                            continue block48;
                        }
                        case 8: {
                            codeVisitor.visitJumpInsn(n18, labelArray[n7 + this.readShort(n6 + 1)]);
                            n6 += 3;
                            continue block48;
                        }
                        case 9: {
                            codeVisitor.visitJumpInsn(n18, labelArray[n7 + this.readInt(n6 + 1)]);
                            n6 += 5;
                            continue block48;
                        }
                        case 16: {
                            n18 = byArray[n6 + 1] & 0xFF;
                            if (n18 == 132) {
                                codeVisitor.visitIincInsn(this.readUnsignedShort(n6 + 2), this.readShort(n6 + 4));
                                n6 += 6;
                                continue block48;
                            }
                            codeVisitor.visitVarInsn(n18, this.readUnsignedShort(n6 + 2));
                            n6 += 4;
                            continue block48;
                        }
                        case 13: {
                            n6 = n6 + 4 - (n7 & 3);
                            n11 = n7 + this.readInt(n6);
                            int n19 = this.readInt(n6 += 4);
                            int n20 = this.readInt(n6 += 4);
                            n6 += 4;
                            Label[] labelArray2 = new Label[n20 - n19 + 1];
                            for (n = 0; n < labelArray2.length; ++n) {
                                labelArray2[n] = labelArray[n7 + this.readInt(n6)];
                                n6 += 4;
                            }
                            codeVisitor.visitTableSwitchInsn(n19, n20, labelArray[n11], labelArray2);
                            continue block48;
                        }
                        case 14: {
                            n6 = n6 + 4 - (n7 & 3);
                            n11 = n7 + this.readInt(n6);
                            n = this.readInt(n6 += 4);
                            n6 += 4;
                            int[] nArray = new int[n];
                            Label[] labelArray3 = new Label[n];
                            for (n = 0; n < nArray.length; ++n) {
                                nArray[n] = this.readInt(n6);
                                labelArray3[n] = labelArray[n7 + this.readInt(n6 += 4)];
                                n6 += 4;
                            }
                            codeVisitor.visitLookupSwitchInsn(labelArray[n11], nArray, labelArray3);
                            continue block48;
                        }
                        case 3: {
                            codeVisitor.visitVarInsn(n18, byArray[n6 + 1] & 0xFF);
                            n6 += 2;
                            continue block48;
                        }
                        case 1: {
                            codeVisitor.visitIntInsn(n18, byArray[n6 + 1]);
                            n6 += 2;
                            continue block48;
                        }
                        case 2: {
                            codeVisitor.visitIntInsn(n18, this.readShort(n6 + 1));
                            n6 += 3;
                            continue block48;
                        }
                        case 10: {
                            codeVisitor.visitLdcInsn(this.readConst(byArray[n6 + 1] & 0xFF, cArray));
                            n6 += 2;
                            continue block48;
                        }
                        case 11: {
                            codeVisitor.visitLdcInsn(this.readConst(this.readUnsignedShort(n6 + 1), cArray));
                            n6 += 3;
                            continue block48;
                        }
                        case 6: 
                        case 7: {
                            int n21 = this.items[this.readUnsignedShort(n6 + 1)];
                            String string5 = this.readClass(n21, cArray);
                            n21 = this.items[this.readUnsignedShort(n21 + 2)];
                            String string6 = this.readUTF8(n21, cArray);
                            String string7 = this.readUTF8(n21 + 2, cArray);
                            if (n18 < 182) {
                                codeVisitor.visitFieldInsn(n18, string5, string6, string7);
                            } else {
                                codeVisitor.visitMethodInsn(n18, string5, string6, string7);
                            }
                            if (n18 == 185) {
                                n6 += 5;
                                continue block48;
                            }
                            n6 += 3;
                            continue block48;
                        }
                        case 5: {
                            codeVisitor.visitTypeInsn(n18, this.readClass(n6 + 1, cArray));
                            n6 += 3;
                            continue block48;
                        }
                        case 12: {
                            codeVisitor.visitIincInsn(byArray[n6 + 1] & 0xFF, byArray[n6 + 2]);
                            n6 += 3;
                            continue block48;
                        }
                    }
                    codeVisitor.visitMultiANewArrayInsn(this.readClass(n6 + 1, cArray), byArray[n6 + 3] & 0xFF);
                    n6 += 4;
                }
                Label label = labelArray[n16 - n15];
                if (label != null) {
                    codeVisitor.visitLabel(label);
                }
                n = this.readUnsignedShort(n6);
                n6 += 2;
                while (n > 0) {
                    Label label2 = labelArray[this.readUnsignedShort(n6)];
                    Label label3 = labelArray[this.readUnsignedShort(n6 + 2)];
                    Label label4 = labelArray[this.readUnsignedShort(n6 + 4)];
                    int n22 = this.readUnsignedShort(n6 + 6);
                    if (n22 == 0) {
                        codeVisitor.visitTryCatchBlock(label2, label3, label4, null);
                    } else {
                        codeVisitor.visitTryCatchBlock(label2, label3, label4, this.readUTF8(this.items[n22], cArray));
                    }
                    n6 += 8;
                    --n;
                }
                n = this.readUnsignedShort(n6);
                n6 += 2;
                if (!bl) {
                    while (n > 0) {
                        String string8 = this.readUTF8(n6, cArray);
                        if (string8.equals("LocalVariableTable")) {
                            n7 = n6 + 8;
                            for (n10 = this.readUnsignedShort(n6 + 6); n10 > 0; --n10) {
                                n11 = this.readUnsignedShort(n7);
                                Label label5 = labelArray[n11];
                                Label label6 = labelArray[n11 += this.readUnsignedShort(n7 + 2)];
                                codeVisitor.visitLocalVariable(this.readUTF8(n7 + 4, cArray), this.readUTF8(n7 + 6, cArray), label5, label6, this.readUnsignedShort(n7 + 8));
                                n7 += 10;
                            }
                        }
                        n6 += 6 + this.readInt(n6 + 2);
                        --n;
                    }
                }
                while (object6 != null) {
                    object3 = ((Attribute)object6).next;
                    ((Attribute)object6).next = null;
                    codeVisitor.visitAttribute((Attribute)object6);
                    object6 = object3;
                }
                codeVisitor.visitMaxs(n12, n13);
            }
            --n2;
        }
        object4 = null;
        object3 = object5;
        while (object3 != null) {
            object2 = ((Attribute)object3).next;
            ((Attribute)object3).next = object4;
            object4 = object3;
            object3 = object2;
        }
        while (object4 != null) {
            object3 = ((Attribute)object4).next;
            ((Attribute)object4).next = null;
            classVisitor.visitAttribute((Attribute)object4);
            object4 = object3;
        }
        classVisitor.visitEnd();
    }

    public int getItem(int n) {
        return this.items[n];
    }

    public int readByte(int n) {
        return this.b[n] & 0xFF;
    }

    public int readUnsignedShort(int n) {
        byte[] byArray = this.b;
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    public short readShort(int n) {
        byte[] byArray = this.b;
        return (short)((byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF);
    }

    public int readInt(int n) {
        byte[] byArray = this.b;
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    public long readLong(int n) {
        long l = this.readInt(n);
        long l2 = (long)this.readInt(n + 4) & 0xFFFFFFFFL;
        return l << 32 | l2;
    }

    public String readUTF8(int n, char[] cArray) {
        int n2 = this.readUnsignedShort(n);
        String string = this.strings[n2];
        if (string != null) {
            return string;
        }
        n = this.items[n2];
        int n3 = this.readUnsignedShort(n);
        int n4 = (n += 2) + n3;
        byte[] byArray = this.b;
        int n5 = 0;
        block4: while (n < n4) {
            byte by;
            int n6 = byArray[n++] & 0xFF;
            switch (n6 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cArray[n5++] = (char)n6;
                    continue block4;
                }
                case 12: 
                case 13: {
                    by = byArray[n++];
                    cArray[n5++] = (char)((n6 & 0x1F) << 6 | by & 0x3F);
                    continue block4;
                }
            }
            by = byArray[n++];
            byte by2 = byArray[n++];
            cArray[n5++] = (char)((n6 & 0xF) << 12 | (by & 0x3F) << 6 | by2 & 0x3F);
        }
        this.strings[n2] = string = new String(cArray, 0, n5);
        return string;
    }

    public String readClass(int n, char[] cArray) {
        return this.readUTF8(this.items[this.readUnsignedShort(n)], cArray);
    }

    public Object readConst(int n, char[] cArray) {
        int n2 = this.items[n];
        switch (this.b[n2 - 1]) {
            case 3: {
                return new Integer(this.readInt(n2));
            }
            case 4: {
                return new Float(Float.intBitsToFloat(this.readInt(n2)));
            }
            case 5: {
                return new Long(this.readLong(n2));
            }
            case 6: {
                return new Double(Double.longBitsToDouble(this.readLong(n2)));
            }
            case 7: {
                String string = this.readUTF8(n2, cArray);
                return Type.getType(string.charAt(0) == '[' ? string : "L" + string + ";");
            }
        }
        return this.readUTF8(n2, cArray);
    }

    protected Attribute readAttribute(Attribute[] attributeArray, String string, int n, int n2, char[] cArray, int n3, Label[] labelArray) {
        for (int i = 0; i < attributeArray.length; ++i) {
            if (!attributeArray[i].type.equals(string)) continue;
            return attributeArray[i].read(this, n, n2, cArray, n3, labelArray);
        }
        return new Attribute(string);
    }
}

