/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.sql.Connection;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logicalcobwebs.proxool.ConnectionPool;
import org.logicalcobwebs.proxool.ConnectionPoolDefinition;
import org.logicalcobwebs.proxool.FormatHelper;
import org.logicalcobwebs.proxool.PrototyperController;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxyConnectionIF;

class HouseKeeper {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$logicalcobwebs$proxool$HouseKeeper == null ? (class$org$logicalcobwebs$proxool$HouseKeeper = HouseKeeper.class$("org.logicalcobwebs.proxool.HouseKeeper")) : class$org$logicalcobwebs$proxool$HouseKeeper));
    private ConnectionPool connectionPool;
    private long timeLastSwept;
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$HouseKeeper;

    public HouseKeeper(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sweep() throws ProxoolException {
        ConnectionPoolDefinition definition = this.connectionPool.getDefinition();
        Log log = this.connectionPool.getLog();
        Statement testStatement = null;
        try {
            this.connectionPool.acquirePrimaryReadLock();
            Connection connection = null;
            ProxyConnectionIF proxyConnection = null;
            int recentlyStartedActiveConnectionCountTemp = 0;
            int[] verifiedConnectionCountByState = new int[4];
            ProxyConnectionIF[] proxyConnections = this.connectionPool.getProxyConnections();
            for (int i = 0; i < proxyConnections.length; ++i) {
                proxyConnection = proxyConnections[i];
                connection = proxyConnection.getConnection();
                if (!this.connectionPool.isConnectionPoolUp()) break;
                if (proxyConnection.setStatus(1, 3)) {
                    try {
                        String sql;
                        testStatement = connection.createStatement();
                        if (proxyConnection.isReallyClosed()) {
                            proxyConnection.setStatus(3, 0);
                            this.connectionPool.removeProxyConnection(proxyConnection, 6, "it appears to be closed", true, true);
                        }
                        if ((sql = definition.getHouseKeepingTestSql()) != null && sql.length() > 0) {
                            boolean testResult = false;
                            try {
                                testResult = testStatement.execute(sql);
                            }
                            catch (Throwable throwable) {
                                if (log.isDebugEnabled() && definition.isVerbose()) {
                                    log.debug((Object)(this.connectionPool.displayStatistics() + " - Testing connection " + proxyConnection.getId() + (testResult ? ": True" : ": False")));
                                }
                                throw throwable;
                            }
                            if (log.isDebugEnabled() && definition.isVerbose()) {
                                log.debug((Object)(this.connectionPool.displayStatistics() + " - Testing connection " + proxyConnection.getId() + (testResult ? ": True" : ": False")));
                            }
                        }
                        proxyConnection.setStatus(3, 1);
                    }
                    catch (Throwable e) {
                        proxyConnection.setStatus(3, 0);
                        this.connectionPool.removeProxyConnection(proxyConnection, 6, "it has problems: " + e, false, true);
                    }
                    finally {
                        try {
                            testStatement.close();
                        }
                        catch (Throwable t) {}
                    }
                }
                if (proxyConnection.getAge() > definition.getMaximumConnectionLifetime()) {
                    String reason = "age is " + proxyConnection.getAge() + "ms";
                    if (proxyConnection.setStatus(1, 3)) {
                        if (proxyConnection.setStatus(3, 0)) {
                            this.connectionPool.expireProxyConnection(proxyConnection, 7, reason, false);
                        }
                    } else {
                        proxyConnection.markForExpiry(reason);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(this.connectionPool.displayStatistics() + " - #" + FormatHelper.formatMediumNumber(proxyConnection.getId()) + " marked for expiry."));
                        }
                    }
                }
                if (proxyConnection.isActive()) {
                    long activeTime = System.currentTimeMillis() - proxyConnection.getTimeLastStartActive();
                    if (activeTime < definition.getRecentlyStartedThreshold()) {
                        ++recentlyStartedActiveConnectionCountTemp;
                    }
                    if (activeTime > definition.getMaximumActiveTime()) {
                        this.connectionPool.removeProxyConnection(proxyConnection, 1, "it has been active for too long", true, true);
                        String lastSqlCallMsg = proxyConnection.getLastSqlCall() != null ? ", and the last SQL it performed is '" + proxyConnection.getLastSqlCall() + "'." : (!proxyConnection.getDefinition().isTrace() ? ", but the last SQL it performed is unknown because the trace property is not enabled." : ", but the last SQL it performed is unknown.");
                        log.warn((Object)("#" + FormatHelper.formatMediumNumber(proxyConnection.getId()) + " was active for " + activeTime + " milliseconds and has been removed automaticaly. The Thread responsible was named '" + proxyConnection.getRequester() + "'" + lastSqlCallMsg));
                    }
                }
                int n = proxyConnection.getStatus();
                verifiedConnectionCountByState[n] = verifiedConnectionCountByState[n] + 1;
            }
            this.calculateUpState(recentlyStartedActiveConnectionCountTemp);
        }
        catch (Throwable e) {
            log.error((Object)"Housekeeping log.error( :", e);
        }
        finally {
            this.connectionPool.releasePrimaryReadLock();
            this.timeLastSwept = System.currentTimeMillis();
            if (definition.isVerbose() && log.isDebugEnabled()) {
                log.debug((Object)(this.connectionPool.displayStatistics() + " - House keeping triggerSweep done"));
            }
        }
        PrototyperController.triggerSweep(definition.getAlias());
    }

    private long getTimeSinceLastSweep() {
        return System.currentTimeMillis() - this.timeLastSwept;
    }

    protected boolean isSweepDue() {
        if (this.connectionPool.isConnectionPoolUp()) {
            return this.getTimeSinceLastSweep() > this.connectionPool.getDefinition().getHouseKeepingSleepTime();
        }
        LOG.warn((Object)"House keeper is still being asked to sweep despite the connection pool being down");
        return false;
    }

    private void calculateUpState(int recentlyStartedActiveConnectionCount) {
        try {
            int calculatedUpState = 0;
            int availableConnectionCount = this.connectionPool.getAvailableConnectionCount();
            if (availableConnectionCount > 0 || recentlyStartedActiveConnectionCount > 0) {
                if (this.connectionPool.getTimeOfLastRefusal() > System.currentTimeMillis() - this.connectionPool.getDefinition().getOverloadWithoutRefusalLifetime()) {
                    calculatedUpState = 2;
                } else if (this.connectionPool.getActiveConnectionCount() > 0) {
                    calculatedUpState = 1;
                }
            } else {
                calculatedUpState = 3;
            }
            this.connectionPool.setUpState(calculatedUpState);
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    protected String getAlias() {
        return this.connectionPool.getDefinition().getAlias();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

